/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.ee.propagation.am;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.ee.common.Account;
import com.sun.ts.tests.jpa.ee.propagation.am.Stateless3IF;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import javax.ejb.EJBException;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;

@Stateless(name="Stateless3Bean")
@Remote(value={Stateless3IF.class})
@TransactionManagement(value=TransactionManagementType.CONTAINER)
public class Stateless3Bean
implements Stateless3IF {
    @PersistenceUnit(unitName="CTS-APPMANAGED-UNIT")
    private EntityManagerFactory entityManagerFactory;
    private EntityManager entityManager;
    public SessionContext sessionContext;
    private Map myMap = new HashMap();
    private Account accountRef;
    private static final int[] ACCOUNTS = new int[]{1000, 1075, 40, 30564, 387};
    private static final double[] BALANCES = new double[]{50000.0, 10490.75, 200.5, 25000.0, 1000000.0};

    @Resource
    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public void transfer(int from, int to, double amt) {
        TestUtil.logTrace((String)"transfer()");
        this.withdraw(from, amt);
        this.deposit(to, amt);
    }

    public double balance(int acct) {
        double balance;
        TestUtil.logTrace((String)"balance()");
        Account thisAccount = (Account)this.entityManager.find(Account.class, (Object)acct);
        try {
            balance = thisAccount.balance();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Exception occurred in balance: " + e);
        }
        return balance;
    }

    public double deposit(int acct, double amt) {
        double balance;
        TestUtil.logTrace((String)"deposit()");
        Account thisAccount = (Account)this.entityManager.find(Account.class, (Object)acct);
        try {
            balance = thisAccount.deposit(amt);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Exception occurred in deposit: " + e);
        }
        return balance;
    }

    public double withdraw(int acct, double amt) {
        double balance;
        TestUtil.logTrace((String)"withdraw()");
        Account thisAccount = (Account)this.entityManager.find(Account.class, (Object)acct);
        try {
            balance = thisAccount.withdraw(amt);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Exception occurred in withdraw: " + e);
        }
        return balance;
    }

    public boolean checkAccountStatus(Account acct) {
        TestUtil.logTrace((String)"checkAccountStatus()");
        Account thisAccount = (Account)this.entityManager.find(Account.class, (Object)acct.id());
        return acct.equals(thisAccount);
    }

    public String getAllAccounts() {
        StringBuffer accounts = new StringBuffer();
        try {
            List result = this.entityManager.createQuery("select a from Account a").getResultList();
            for (Account a1 : result) {
                accounts.append("" + a1.id() + "  " + a1.balance() + "\n");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Exception occurred in getAllAccounts: " + e);
        }
        return accounts.toString();
    }

    public void removeTestData() {
        TestUtil.logTrace((String)"entering removeTestData()");
        try {
            this.entityManager.createNativeQuery("DELETE FROM ACCOUNT").executeUpdate();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        TestUtil.logTrace((String)"Clearing cache");
        this.entityManagerFactory.getCache().evictAll();
        TestUtil.logTrace((String)"leaving removeTestData()");
    }

    public void createTestData() {
        TestUtil.logTrace((String)"entering createTestData()");
        try {
            TestUtil.logTrace((String)"Create 5 Account Entities");
            for (int i = 0; i < ACCOUNTS.length; ++i) {
                TestUtil.logTrace((String)("Creating account=" + ACCOUNTS[i] + ", balance=" + BALANCES[i]));
                System.out.println("Creating account=" + ACCOUNTS[i] + ", balance=" + BALANCES[i]);
                this.accountRef = new Account(ACCOUNTS[i], BALANCES[i]);
                this.entityManager.persist((Object)this.accountRef);
            }
            this.entityManager.flush();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"createTestData: Unexpected Exception caught in createTestData", (Throwable)e);
        }
        finally {
            TestUtil.logTrace((String)"createTestData complete");
        }
        TestUtil.logTrace((String)"leaving createTestData()");
    }

    @Override
    public void init(Properties p) {
        TestUtil.logTrace((String)"entering init()");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
        TestUtil.logTrace((String)"leaving init()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test1() {
        boolean pass = false;
        try {
            this.createEntityManager();
            this.createTestData();
            String accounts = this.getAllAccounts();
            if (accounts != null) {
                TestUtil.logTrace((String)accounts);
            }
            Account ACCOUNT = (Account)this.entityManager.find(Account.class, (Object)1075);
            pass = this.checkAccountStatus(ACCOUNT);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception:", (Throwable)e);
        }
        finally {
            this.closeEntityManager();
        }
        TestUtil.logTrace((String)"leaving test1()");
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test2() {
        Double EXPECTED_BALANCE = 10540.75;
        boolean pass = false;
        try {
            this.createEntityManager();
            this.createTestData();
            Account ACCOUNT = (Account)this.entityManager.find(Account.class, (Object)1075);
            Double balance = this.balance(ACCOUNT.id());
            balance = this.deposit(ACCOUNT.id(), 100.0);
            balance = this.withdraw(ACCOUNT.id(), 50.0);
            if (EXPECTED_BALANCE.compareTo(balance) == 0) {
                TestUtil.logTrace((String)"Expected balance received.");
                pass = true;
            } else {
                TestUtil.logErr((String)(" Did not get Expected balance, got:" + balance + "Expected: " + EXPECTED_BALANCE));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception:", (Throwable)e);
        }
        finally {
            this.closeEntityManager();
        }
        TestUtil.logTrace((String)"leaving test2()");
        return pass;
    }

    public void createEntityManager() {
        TestUtil.logTrace((String)"entering createEntityManager()");
        if (this.entityManagerFactory != null) {
            TestUtil.logTrace((String)"EntityManagerFactory is not null");
            this.entityManager = this.entityManagerFactory.createEntityManager(this.myMap);
        } else {
            TestUtil.logErr((String)"Unexpected: EntityManagerFactory is null");
        }
        TestUtil.logTrace((String)"leaving createEntityManager()");
    }

    public void closeEntityManager() {
        TestUtil.logTrace((String)"entering closeEntityManager()");
        try {
            if (this.entityManager.isOpen()) {
                this.entityManager.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("closeEntityManager: Unexpected Exception caught while closing an Application-Managed EntityManager" + e));
        }
        TestUtil.logTrace((String)"leaving closeEntityManager()");
    }

    @Override
    public void doCleanup() {
        TestUtil.logTrace((String)"entering doCleanup()");
        this.createEntityManager();
        this.removeTestData();
        this.closeEntityManager();
        TestUtil.logTrace((String)"leaving doCleanup()");
    }
}

