/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.common;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXR_Util;
import java.io.FileInputStream;
import java.io.Serializable;
import java.net.PasswordAuthentication;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.x500.X500PrivateCredential;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.CapabilityProfile;
import javax.xml.registry.Connection;
import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;

public class JAXRCommonClient
extends ServiceEETest
implements Serializable {
    protected Properties props = null;
    protected Connection conn = null;
    protected ConnectionFactory factory = null;
    public String supr = "JAXRCommonClient";
    protected static final String WEBSERVERPORT = "webServerPort";
    protected static final String WEBSERVERHOST = "webServerHost";
    protected static final String JAXRPASSWORD = "jaxrPassword";
    protected static final String JAXRUSER = "jaxrUser";
    protected static final String JAXRPASSWORD2 = "jaxrPassword2";
    protected static final String JAXRUSER2 = "jaxrUser2";
    protected static final String QUERYMANAGERURL = "queryManagerURL";
    protected static final String REGISTRYURL = "registryURL";
    protected static final String AUTHENTICATIONMETHOD = "authenticationMethod";
    protected static final String JAXRALIAS = "jaxrAlias";
    protected static final String JAXRALIAS2 = "jaxrAlias2";
    protected static final String JAXRALIAS_PASSWORD = "jaxrAliasPassword";
    protected static final String JAXRALIAS2_PASSWORD = "jaxrAlias2Password";
    protected static final String JAXR_WEBCONTEXT = "jaxrWebContext";
    protected static final String JAXR_CONNECTIONFACTORY_LOOKUP = "jaxrConnectionFactoryLookup";
    protected static final int USE_JNDI = 0;
    protected static final int USE_NEWINSTANCE = 1;
    protected static final String JAXR_SECURITY_TYPE = "jaxrSecurityCredentialType";
    protected static final int USE_USERNAME_PASSWORD = 0;
    protected static final int USE_DIGITAL_CERTIFICATES = 1;
    protected static final String TS_HOME = "ts_home";
    protected String tshome;
    protected int jaxrConnectionFactoryLookup;
    protected int jaxrSecurityCredentialType;
    protected String webServerHost;
    protected String webServerPort;
    protected String jaxrPassword;
    protected String jaxrUser;
    protected String jaxrPassword2;
    protected String jaxrUser2;
    protected String jaxrAlias;
    protected String jaxrAliasPassword;
    protected String jaxrAlias2;
    protected String jaxrAlias2Password;
    protected String jaxrWebContext;
    protected String registryURL;
    protected String queryManagerURL;
    protected String authenticationMethod;
    protected String baseuri;
    protected RegistryService rs = null;
    protected BusinessLifeCycleManager blm = null;
    protected CapabilityProfile cp = null;
    protected int capabilityLevel;
    protected PasswordAuthentication passwdAuth = null;
    protected Collection debug = null;

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        this.debug = null;
        try {
            this.debug = new ArrayList();
            this.tshome = p.getProperty(TS_HOME);
            this.jaxrSecurityCredentialType = Integer.parseInt(p.getProperty(JAXR_SECURITY_TYPE));
            this.jaxrConnectionFactoryLookup = Integer.parseInt(p.getProperty(JAXR_CONNECTIONFACTORY_LOOKUP));
            this.jaxrUser = p.getProperty(JAXRUSER);
            this.jaxrPassword = p.getProperty(JAXRPASSWORD);
            this.webServerPort = p.getProperty(WEBSERVERPORT);
            this.webServerHost = p.getProperty(WEBSERVERHOST);
            this.jaxrUser2 = p.getProperty(JAXRUSER2);
            this.jaxrPassword2 = p.getProperty(JAXRPASSWORD2);
            this.jaxrAlias = p.getProperty(JAXRALIAS);
            this.jaxrAlias2 = p.getProperty(JAXRALIAS2);
            this.jaxrWebContext = p.getProperty(JAXR_WEBCONTEXT);
            this.baseuri = "http://" + this.webServerHost + ":" + this.webServerPort + "/" + this.jaxrWebContext + "/";
            this.jaxrAliasPassword = p.getProperty(JAXRALIAS_PASSWORD);
            this.jaxrAlias2Password = p.getProperty(JAXRALIAS2_PASSWORD);
            this.props.setProperty("javax.xml.registry.queryManagerURL", p.getProperty(QUERYMANAGERURL));
            this.props.setProperty("javax.xml.registry.lifeCycleManagerURL", p.getProperty(REGISTRYURL));
            this.props.setProperty("javax.xml.registry.security.authenticationMethod", p.getProperty(AUTHENTICATIONMETHOD));
            switch (this.jaxrConnectionFactoryLookup) {
                case 0: {
                    String jaxrLookup = p.getProperty("jaxrJNDIResource");
                    TSNamingContext nctx = null;
                    nctx = new TSNamingContext();
                    this.factory = (ConnectionFactory)nctx.lookup(jaxrLookup);
                    break;
                }
                case 1: {
                    this.factory = ConnectionFactory.newInstance();
                    break;
                }
                default: {
                    throw new EETest.Fault("setup failed: jaxrConnectionFactoryLookup is invalid");
                }
            }
            this.factory.setProperties(this.props);
            this.conn = this.factory.createConnection();
            if (!(this.conn instanceof Connection)) {
                this.logMsg("From JAXRCommonClient: Error did not get a connection object");
            }
            this.rs = this.conn.getRegistryService();
            if (!(this.rs instanceof RegistryService)) {
                this.logMsg("From JAXRCommonClient: Error did not get a rs object");
            }
            this.cp = this.rs.getCapabilityProfile();
            this.capabilityLevel = this.cp.getCapabilityLevel();
            Set credentials = null;
            switch (this.jaxrSecurityCredentialType) {
                case 0: {
                    credentials = this.getUsernamePasswordCredentials();
                    break;
                }
                case 1: {
                    credentials = this.getDigitalCertificateCredentials(this.jaxrAlias, this.jaxrAliasPassword);
                    break;
                }
                default: {
                    throw new EETest.Fault("setup failed: jaxrSecurityCredentialType is invalid");
                }
            }
            this.conn.setCredentials(credentials);
            try {
                this.blm = this.rs.getBusinessLifeCycleManager();
            }
            catch (JAXRException je) {
                TestUtil.logMsg((String)"JAXRException");
                TestUtil.printStackTrace((Throwable)je);
            }
        }
        catch (Exception e) {
            TestUtil.logMsg((String)("exception getMessage: " + e.getMessage()));
            TestUtil.logMsg((String)("exception getCause: " + e.getCause()));
            e.printStackTrace();
            TestUtil.logErr((String)(" exception" + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setup failed:", e);
        }
        finally {
            TestUtil.logTrace((String)this.debug.toString());
            this.debug.clear();
        }
    }

    public Set getUsernamePasswordCredentials() {
        HashSet<PasswordAuthentication> credentials = new HashSet<PasswordAuthentication>();
        this.passwdAuth = new PasswordAuthentication(this.jaxrUser, this.jaxrPassword.toCharArray());
        credentials.add(this.passwdAuth);
        return credentials;
    }

    public Set getDigitalCertificateCredentials(String useralias, String aliasPassword) throws EETest.Fault {
        String keystoreType = "JKS";
        HashSet<X500PrivateCredential> credentials = new HashSet<X500PrivateCredential>();
        try {
            String keystoreFile = System.getProperty("javax.net.ssl.keyStore");
            String keystorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
            char[] keystorePasswordBytes = null;
            keystorePasswordBytes = keystorePassword.toCharArray();
            KeyStore ks = KeyStore.getInstance(keystoreType);
            TestUtil.logMsg((String)(" ===============> userAlias=" + useralias + " aliasPassword=" + aliasPassword + " keyStorePassword=" + keystorePassword + "keystoreFile=" + keystoreFile));
            ks.load(new FileInputStream(keystoreFile), keystorePasswordBytes);
            Certificate certificate = ks.getCertificate(useralias);
            PrivateKey key = (PrivateKey)ks.getKey(useralias, aliasPassword.toCharArray());
            X509Certificate cert = (X509Certificate)certificate;
            X500PrivateCredential privateCredential = null;
            privateCredential = new X500PrivateCredential(cert, key, useralias);
            credentials.add(privateCredential);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setup failed: Unable to create credential for digital certificate", e);
        }
        return credentials;
    }

    public void cleanup() throws EETest.Fault {
        try {
            this.logMsg("JAXRCommonClient.cleanup:Closing connection");
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public boolean cleanUpRegistry(Collection keys, String objectType) {
        try {
            BulkResponse br;
            this.blm = this.rs.getBusinessLifeCycleManager();
            if (objectType.equals("Organization")) {
                Collection users;
                BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
                BulkResponse br2 = bqm.getRegistryObjects(keys, objectType);
                if (br2.getExceptions() != null) {
                    this.debug.add("Error:    cleanUpRegistry failed \n");
                    return false;
                }
                Collection orgs = br2.getCollection();
                Organization org2 = null;
                for (Organization org2 : orgs) {
                }
                Collection services = org2.getServices();
                if (services.size() > 0) {
                    org2.removeServices(services);
                }
                if ((users = org2.getUsers()).size() > 0) {
                    org2.removeUsers(users);
                }
            }
            if (!JAXR_Util.checkBulkResponse("saveOrganizations", br = this.blm.deleteObjects(keys, objectType), this.debug)) {
                this.debug.add("Error:    cleanUpRegistry failed \n");
                return false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean cleanUpRegistry() {
        return this.cleanUpRegistry("TS Default Organization");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanUpRegistry(String orgName) {
        try {
            ArrayList<String> names = new ArrayList<String>();
            names.add(orgName);
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            BulkResponse br = bqm.findOrganizations(null, names, null, null, null, null);
            if (!JAXR_Util.checkBulkResponse("findOrganizations", br, this.debug)) {
                this.debug.add("Error reported in cleanUpRegistry:  findOrganizations failed \n");
                boolean bl = false;
                return bl;
            }
            Collection orgs = br.getCollection();
            if (orgs.size() == 0) {
                this.debug.add(" OK: nothing in the registry to clean! \n");
                boolean bl = true;
                return bl;
            }
            Iterator iter = orgs.iterator();
            ArrayList<Key> orgKeys = new ArrayList<Key>();
            Object key = null;
            while (iter.hasNext()) {
                Collection users;
                Organization org = (Organization)iter.next();
                orgKeys.add(org.getKey());
                Collection services = org.getServices();
                if (services.size() > 0) {
                    org.removeServices(services);
                }
                if ((users = org.getUsers()).size() <= 0) continue;
                org.removeUsers(users);
            }
            br = this.blm.deleteOrganizations(orgKeys);
            if (!JAXR_Util.checkBulkResponse("deleteOrganizations", br, this.debug)) {
                this.debug.add("Error reported in cleanUpRegistry:  deleteOrganizations failed \n");
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (JAXRException e) {
            TestUtil.printStackTrace((Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            TestUtil.logTrace((String)this.debug.toString());
            this.debug.clear();
        }
    }

    public Key saveMyOrganization(Organization org) {
        Key key2 = null;
        ArrayList<Organization> orgs = new ArrayList<Organization>();
        orgs.add(org);
        try {
            BulkResponse br = this.blm.saveOrganizations(orgs);
            if (br.getExceptions() != null) {
                this.debug.add("Error:   saveOrganizations failed \n");
                return null;
            }
            Collection orgKeys = br.getCollection();
            for (Key key2 : orgKeys) {
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return key2;
    }
}

