/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.ee.w2j.document.literal.stockquote;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Util;
import com.sun.ts.tests.jaxrpc.ee.w2j.document.literal.stockquote.StockQuotePortType;
import java.net.URL;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.Stub;

public class Client
extends ServiceEETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private static final String MODEPROP = "platform.mode";
    String modeProperty = null;
    private static final String PKG_NAME = "com.sun.ts.tests.jaxrpc.ee.w2j.document.literal.stockquote.";
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private final String NAMESPACEURI = "http://example.com/stockquote/service";
    private QName SERVICE_QNAME;
    private QName PORT_QNAME;
    private static final String ENDPOINT_URL = "stockquote.endpoint.1";
    private static final String WSDLLOC_URL = "stockquote.wsdlloc.1";
    private String url = null;
    private URL wsdlurl = null;
    StockQuotePortType port = null;
    Stub stub = null;

    private void getTestURLs() throws Exception {
        TestUtil.logMsg((String)"Get URL's used by the test");
        String file = JAXRPC_Util.getURLFromProp(ENDPOINT_URL);
        this.url = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXRPC_Util.getURLFromProp(WSDLLOC_URL);
        this.wsdlurl = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, file);
        TestUtil.logMsg((String)("Service Endpoint URL: " + this.url));
        TestUtil.logMsg((String)("WSDL Location URL:    " + this.wsdlurl));
    }

    private void getStubStandalone() throws Exception {
        TestUtil.logMsg((String)"Get stub from service implementation class using JAXRPC porting instance");
        this.port = (StockQuotePortType)JAXRPC_Util.getStub("com.sun.ts.tests.jaxrpc.ee.w2j.document.literal.stockquote.StockQuoteService", "getStockQuotePort");
        TestUtil.logMsg((String)"Cast stub to base Stub class ...");
        this.stub = (Stub)this.port;
    }

    private void getStub() throws Exception {
        TestUtil.logMsg((String)"JNDI lookup for Service1");
        InitialContext ctx = new InitialContext();
        TestUtil.logMsg((String)"java:comp/env/service/w2jdlstockquote");
        Service svc = (Service)ctx.lookup("java:comp/env/service/w2jdlstockquote");
        TestUtil.logMsg((String)"Get port from Service1");
        this.port = (StockQuotePortType)svc.getPort(StockQuotePortType.class);
        TestUtil.logMsg((String)"Port obtained");
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        this.SERVICE_QNAME = new QName("http://example.com/stockquote/service", "StockQuoteService");
        this.PORT_QNAME = new QName("http://example.com/stockquote/service", "StockQuotePort");
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            this.modeProperty = p.getProperty(MODEPROP);
            if (this.modeProperty.equals("standalone")) {
                this.getTestURLs();
                this.getStubStandalone();
                TestUtil.logMsg((String)("Setting target endpoint to " + this.url + " ..."));
                this.stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.url);
            } else {
                this.getStub();
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setup failed:", e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void invokeStockQuoteService() throws EETest.Fault {
        TestUtil.logTrace((String)"invokeStockQuoteService");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Invoke getLastTradePrice(\"GTE\") and expect 24.25");
            float response = this.port.getLastTradePrice("GTE");
            if (response != 24.25f) {
                TestUtil.logErr((String)("RPC failed - expected: \"24.25\", received: " + response));
                pass = false;
            } else {
                TestUtil.logMsg((String)("RPC passed - received expected response: " + response));
            }
            TestUtil.logMsg((String)"Invoke getLastTradePrice(\"GE\") and expect 45.5");
            response = this.port.getLastTradePrice("GE");
            if (response != 45.5f) {
                TestUtil.logErr((String)("RPC failed - expected: \"45.5\", received: " + response));
                pass = false;
            } else {
                TestUtil.logMsg((String)("RPC passed - received expected response: " + response));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("invokeStockQuoteService");
        }
        if (!pass) {
            throw new EETest.Fault("invokeStockQuoteService failed");
        }
    }
}

