/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common.parser;

import com.sun.ts.tests.interop.csiv2.common.parser.Entry;
import com.sun.ts.tests.interop.csiv2.common.parser.IORASContextEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.IORSASContextEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.IORTransportMechEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.ParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CompoundSecMechEntry
extends Entry {
    private int targetRequires;
    private IORTransportMechEntry iorTransportMech;
    private IORASContextEntry iorASContext;
    private IORSASContextEntry iorSASContext;

    public CompoundSecMechEntry(Element element) throws ParseException {
        if (!element.getTagName().equals("compound-sec-mech")) {
            throw new ParseException("Unexpected tag: " + element.getTagName());
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("target-requires")) {
                this.targetRequires = Integer.parseInt(this.getText(node));
                continue;
            }
            if (node.getNodeName().equals("ior-transport-mech")) {
                this.iorTransportMech = new IORTransportMechEntry((Element)node);
                continue;
            }
            if (node.getNodeName().equals("ior-as-context")) {
                this.iorASContext = new IORASContextEntry((Element)node);
                continue;
            }
            if (!node.getNodeName().equals("ior-sas-context")) continue;
            this.iorSASContext = new IORSASContextEntry((Element)node);
        }
    }

    public String toString() {
        String result = "<compound-sec-mech>\n";
        result = result + "<target-requires>" + this.targetRequires + "</target-requires>\n";
        result = result + this.iorTransportMech.toString();
        result = result + this.iorASContext.toString();
        result = result + this.iorSASContext.toString();
        result = result + "</compound-sec-mech>\n";
        return result;
    }

    public int getTargetRequires() {
        return this.targetRequires;
    }

    public IORTransportMechEntry getIorTransportMech() {
        return this.iorTransportMech;
    }

    public IORASContextEntry getIorASContext() {
        return this.iorASContext;
    }

    public IORSASContextEntry getIorSASContext() {
        return this.iorSASContext;
    }
}

