/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry_infomodel.Slot;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.xml.registry.infomodel.Slot;

public class JAXRClient
extends JAXRCommonClient {
    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            this.logMsg("in cleanup");
            if (this.conn != null) {
                this.logTrace("Cleanup is closing the connection");
                this.conn.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void slot_getNameTest() throws EETest.Fault {
        String testName = "slot_getNameTest";
        boolean pass = true;
        String name = "addressLines";
        String value1 = "1 Network Drive";
        String value2 = "Burlington,MA";
        String slotType = "myLocalAddress";
        try {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value1);
            values.add(value2);
            Slot slot = this.blm.createSlot(name, values, slotType);
            this.debug.add("\n");
            this.debug.add("getName should return:" + name + "\n");
            this.debug.add("getName returned:" + slot.getName() + "\n");
            if (!slot.getName().equals(name)) {
                throw new EETest.Fault(testName + " returned invalid testname");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void slot_setNameTest() throws EETest.Fault {
        String testName = "slot_setNameTest";
        boolean pass = true;
        String name = "addressLines";
        String name2 = "sortCode";
        String value1 = "1 Network Drive";
        String value2 = "Burlington,MA";
        String slotType = "myLocalAddress";
        try {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value1);
            values.add(value2);
            Slot slot = this.blm.createSlot(name, values, slotType);
            slot.setName(name2);
            this.debug.add("\n");
            this.debug.add("getName should return:" + name2 + "\n");
            this.debug.add("getName returned:" + slot.getName() + "\n");
            if (!slot.getName().equals(name2)) {
                throw new EETest.Fault(testName + " returned invalid testname");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void slot_getSlotTypeTest() throws EETest.Fault {
        String testName = "slot_getSlotTypeTest";
        boolean pass = true;
        String name = "addressLines";
        String value1 = "1 Network Drive";
        String value2 = "Burlington,MA";
        String slotType = "myLocalAddress";
        try {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value1);
            values.add(value2);
            Slot slot = this.blm.createSlot(name, values, slotType);
            this.debug.add("\n");
            this.debug.add("getSlotType should return:" + slotType + "\n");
            this.debug.add("getSlotType returned:" + slot.getSlotType() + "\n");
            if (!slot.getSlotType().equals(slotType)) {
                throw new EETest.Fault(testName + " returned invalid slotType");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void slot_setSlotTypeTest() throws EETest.Fault {
        String testName = "slot_setSlotTypeTest";
        boolean pass = true;
        String name = "addressLines";
        String value1 = "1 Network Drive";
        String value2 = "Burlington,MA";
        String slotType = "myLocalAddress";
        String slotType2 = "myWorkAddress";
        try {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value1);
            values.add(value2);
            Slot slot = this.blm.createSlot(name, values, slotType);
            slot.setSlotType(slotType2);
            this.debug.add("\n");
            this.debug.add("slotType should return:" + slotType2 + "\n");
            this.debug.add("slotType returned:" + slot.getSlotType() + "\n");
            if (!slot.getSlotType().equals(slotType2)) {
                throw new EETest.Fault(testName + " returned invalid slotType");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void slot_getValuesTest() throws EETest.Fault {
        String testName = "slot_getValuesTest";
        boolean pass = true;
        String name = "addressLines";
        String value1 = "1 Network Drive";
        String value2 = "Burlington,MA";
        String slotType = "myLocalAddress";
        try {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value1);
            values.add(value2);
            Slot slot = this.blm.createSlot(name, values, slotType);
            Collection c = slot.getValues();
            Object[] slotValues = c.toArray();
            this.debug.add("\n");
            this.debug.add("value 1 should return: " + value1 + "\n");
            this.debug.add("value 2 should return: " + value2 + "\n");
            for (int i = 0; i < c.size(); ++i) {
                this.debug.add("value " + i + " returned " + (String)slotValues[i] + "\n");
            }
            if (!c.containsAll(values)) {
                throw new EETest.Fault(testName + " returned invalid values");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void slot_setValuesTest() throws EETest.Fault {
        String testName = "slot_setValuesTest";
        boolean pass = true;
        String name = "addressLines";
        String value1 = "1 Network Drive";
        String value2 = "Burlington,MA";
        String newValue1 = "47 Amsden Street";
        String newValue2 = "Arlington, MA";
        String slotType = "myLocalAddress";
        try {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value1);
            values.add(value2);
            Slot slot = this.blm.createSlot(name, values, slotType);
            ArrayList<String> newValues = new ArrayList<String>();
            newValues.add(newValue1);
            newValues.add(newValue2);
            slot.setValues(newValues);
            Collection c = slot.getValues();
            Object[] slotValues = c.toArray();
            this.debug.add("\n");
            this.debug.add("value 1 should return: " + newValue1 + "\n");
            this.debug.add("value 2 should return: " + newValue2 + "\n");
            for (int i = 0; i < c.size(); ++i) {
                this.debug.add("value " + i + " returned " + (String)slotValues[i] + "\n");
            }
            if (!c.containsAll(newValues)) {
                throw new EETest.Fault(testName + " returned invalid values");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }
}

