/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.api.javax_xml_namespace.QName;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import java.util.Properties;
import javax.xml.namespace.QName;

public class Client
extends ServiceEETest {
    private Properties props = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void QNameConstructorTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"QNameConstructorTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via QName(String localPart) ...");
            QName n = new QName("localPart");
            if (n != null) {
                TestUtil.logMsg((String)"QName object created successfully");
            } else {
                TestUtil.logErr((String)"QName object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("QNameConstructorTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("QNameConstructorTest1 failed");
        }
    }

    public void QNameConstructorTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"QNameConstructorTest2");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via QName(String namespaceURI, String localPart) ...");
            QName n = new QName("http://foo.bar.com", "localPart");
            if (n != null) {
                TestUtil.logMsg((String)"QName object created successfully");
            } else {
                TestUtil.logErr((String)"QName object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("QNameConstructorTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("QNameConstructorTest2 failed");
        }
    }

    public void getLocalPartTest() throws EETest.Fault {
        TestUtil.logTrace((String)"getLocalPartTest");
        String localPart = "localPart";
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via QName(String namespaceURI, String localPart) ...");
            QName n = new QName("http://foo.bar.com", "localPart");
            if (n != null) {
                String s = n.getLocalPart();
                if (s.equals(localPart)) {
                    TestUtil.logMsg((String)("Local Part received as expected: " + localPart));
                } else {
                    TestUtil.logErr((String)("Local Part: expected - " + localPart + ", received - " + s));
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"QName object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("getLocalPartTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("getLocalPartTest failed");
        }
    }

    public void getNamespaceURITest() throws EETest.Fault {
        TestUtil.logTrace((String)"getNamespaceURITest");
        String namespaceURI = "http://foo.bar.com";
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via QName(String namespaceURI, String localPart) ...");
            QName n = new QName("http://foo.bar.com", "localPart");
            if (n != null) {
                String s = n.getNamespaceURI();
                if (s.equals(namespaceURI)) {
                    TestUtil.logMsg((String)("Local Part received as expected: " + namespaceURI));
                } else {
                    TestUtil.logErr((String)("Local Part: expected - " + namespaceURI + ", received - " + s));
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"QName object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("getNamespaceURITest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("getNamespaceURITest failed");
        }
    }

    public void equalsTest() throws EETest.Fault {
        TestUtil.logTrace((String)"equalsTest");
        boolean pass = true;
        if (!this.equalsTest1()) {
            pass = false;
        }
        if (!this.equalsTest2()) {
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("equalsTest failed");
        }
    }

    private boolean equalsTest1() {
        TestUtil.logTrace((String)"equalsTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via QName(String namespaceURI, String localPart) ...");
            QName n = new QName("http://foo.bar.com", "localPart");
            if (n != null) {
                if (n.equals(n)) {
                    TestUtil.logMsg((String)"QName objects are equal - expected");
                } else {
                    TestUtil.logErr((String)"QName objects are not equal - unexpected");
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"QName object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    private boolean equalsTest2() {
        TestUtil.logTrace((String)"equalsTest2");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via QName(String namespaceURI, String localPart) ...");
            QName n1 = new QName("http://foo.bar.com", "localPart1");
            QName n2 = new QName("http://foo.bar.com", "localPart2");
            if (n1 != null && n2 != null) {
                if (!n1.equals(n2)) {
                    TestUtil.logMsg((String)"QName objects are not equal - expected");
                } else {
                    TestUtil.logErr((String)"QName objects are equal - unexpected");
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"QName object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    public void hashCodeTest() throws EETest.Fault {
        TestUtil.logTrace((String)"hashCodeTest");
        boolean pass = true;
        if (!this.hashCodeTest1()) {
            pass = false;
        }
        if (!this.hashCodeTest2()) {
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("hashCodeTest failed");
        }
    }

    private boolean hashCodeTest1() {
        TestUtil.logTrace((String)"hashCodeTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via QName(String namespaceURI, String localPart) ...");
            QName n1 = new QName("http://foo.bar.com", "localPart");
            QName n2 = new QName("http://foo.bar.com", "localPart");
            if (n1 != null) {
                int hashCode2;
                int hashCode1 = n1.hashCode();
                if (hashCode1 == (hashCode2 = n2.hashCode())) {
                    TestUtil.logMsg((String)"QName objects hashCodes are equal - expected");
                } else {
                    TestUtil.logErr((String)"QName objects hashCodes are not equal - unexpected");
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"QName object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    private boolean hashCodeTest2() {
        TestUtil.logTrace((String)"hashCodeTest2");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via QName(String namespaceURI, String localPart) ...");
            QName n1 = new QName("http://foo.bar.com", "localPart1");
            QName n2 = new QName("http://foo.bar.com", "localPart2");
            if (n1 != null && n2 != null) {
                int hashCode2;
                int hashCode1 = n1.hashCode();
                if (hashCode1 != (hashCode2 = n2.hashCode())) {
                    TestUtil.logMsg((String)"QName objects hashCodes are not equal - expected");
                } else {
                    TestUtil.logErr((String)"QName objects hashCodes are equal - unexpected");
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"QName object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    public void toStringTest() throws EETest.Fault {
        TestUtil.logTrace((String)"toStringTest");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via QName(String namespaceURI, String localPart) ...");
            QName n = new QName("http://foo.bar.com", "localPart");
            if (n != null) {
                String s = n.toString();
                TestUtil.logMsg((String)("String representation of QName is: " + s));
            } else {
                TestUtil.logErr((String)"QName object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("toStringTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("toStringTest failed");
        }
    }
}

