/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.jpa22.repeatable.convert;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.jpa22.repeatable.convert.Address;
import com.sun.ts.tests.jpa.jpa22.repeatable.convert.B;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final long serialVersionUID = 22L;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertsTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            this.getEntityTransaction().begin();
            String street = "500.Oracle.Parkway";
            String city = "Redwood Shores";
            B b = new B("1", "name1", 1000, new Address(street, city, 1));
            this.getEntityManager().persist((Object)b);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            B b1 = (B)this.getEntityManager().find(B.class, (Object)b.id);
            TestUtil.logTrace((String)("B:" + b1.toString()));
            if (b1.getBValue().equals(1000)) {
                TestUtil.logTrace((String)("Received expected value:" + b1.getBValue()));
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Converter was not properly applied, expected value:1000, actual" + b1.getBValue()));
            }
            Address a = b1.getAddress();
            if (a.getStreet().equals(street.replace(".", "_"))) {
                TestUtil.logTrace((String)("Received expected street:" + a.getStreet()));
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Converter was not properly applied, expected street:" + street + ", actual:" + a.getStreet()));
            }
            if (a.getState() == 1) {
                TestUtil.logTrace((String)("Received expected state:" + a.getState()));
                pass3 = true;
            } else {
                TestUtil.logErr((String)("Converter was not properly applied, expected state: 1, actual: " + a.getState()));
            }
            this.getEntityTransaction().rollback();
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Unexpected exception received:", (Throwable)ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception while rolling back TX:", (Throwable)re);
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("convertsTest failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DEPARTMENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM B_EMBEDDABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM CUST_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PHONES").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

