/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common.parser;

import com.sun.ts.tests.interop.csiv2.common.parser.Entry;
import com.sun.ts.tests.interop.csiv2.common.parser.IdentityTokenEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.ParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EstablishContextEntry
extends Entry {
    private long clientContextID;
    private IdentityTokenEntry identityToken;
    private byte[] clientAuthToken;
    private int authzTokenCount;

    public EstablishContextEntry(Element element) throws ParseException {
        if (!element.getTagName().equals("establish-context")) {
            throw new ParseException("Unexpected tag: " + element.getTagName());
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("client-context-id")) {
                this.clientContextID = Long.parseLong(this.getText(node));
                continue;
            }
            if (node.getNodeName().equals("identity-token")) {
                this.identityToken = new IdentityTokenEntry((Element)node);
                continue;
            }
            if (node.getNodeName().equals("client-auth-token")) {
                this.clientAuthToken = EstablishContextEntry.parseBinHex(this.getText(node));
                continue;
            }
            if (!node.getNodeName().equals("authz-token-count")) continue;
            this.authzTokenCount = Integer.parseInt(this.getText(node));
        }
    }

    public long getClientContextID() {
        return this.clientContextID;
    }

    public IdentityTokenEntry getIdentityToken() {
        return this.identityToken;
    }

    public byte[] getClientAuthToken() {
        return this.clientAuthToken;
    }

    public int getAuthzTokenCount() {
        return this.authzTokenCount;
    }

    public String toString() {
        String result = "<establish-context>\n";
        result = result + "<client-context-id>" + this.clientContextID + "</client-context-id>\n";
        result = result + this.identityToken.toString();
        result = result + "<client-auth-token>" + EstablishContextEntry.binHex(this.clientAuthToken) + "</client-auth-token>\n";
        result = result + "<authz-token-count>" + this.authzTokenCount + "</authz-token-count>\n";
        result = result + "</establish-context>\n";
        return result;
    }
}

