/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.sharedclients;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.sharedclients.SOAPClient;
import com.sun.ts.tests.jaxrpc.sharedclients.SecureClient;
import com.sun.ts.tests.jaxrpc.wsi.utils.PropertyUtils;
import java.lang.reflect.Constructor;
import java.util.Properties;

public class ClientFactory {
    public static SOAPClient getClient(Class clazz, Properties properties) throws EETest.Fault {
        int mode;
        String property = properties.getProperty("platform.mode");
        if (property == null) {
            throw new EETest.Fault("The 'platform.mode' property value is not defined");
        }
        if (property.equalsIgnoreCase("standalone")) {
            mode = 0;
        } else if (property.equalsIgnoreCase("javaEE")) {
            mode = 1;
        } else {
            throw new EETest.Fault("The 'platform.mode' property value '" + property + "' is invalid");
        }
        String webServerHost = PropertyUtils.getProperty(properties, "webServerHost");
        int webServerPort = SecureClient.class.isAssignableFrom(clazz) ? PropertyUtils.getIntegerProperty(properties, "secureWebServerPort") : PropertyUtils.getIntegerProperty(properties, "webServerPort");
        try {
            Constructor ctr = clazz.getConstructor(String.class, Integer.TYPE, Integer.TYPE);
            return (SOAPClient)ctr.newInstance(webServerHost, new Integer(webServerPort), new Integer(mode));
        }
        catch (NoSuchMethodException e) {
            throw new EETest.Fault("Client '" + clazz.getName() + "' does not have required constructor", e);
        }
        catch (ClassCastException e) {
            throw new EETest.Fault("Client '" + clazz.getName() + "' does not extend '" + SOAPClient.class.getName() + "'", e);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Unable to instantiate '" + clazz.getName() + "'", e);
        }
    }

    private ClientFactory() {
    }
}

