/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices12.ejb.annotations.WSEjbMultipleClientInjectionTest2;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.common.JAXWS_Util;
import com.sun.ts.tests.webservices12.ejb.annotations.WSEjbMultipleClientInjectionTest2.Hello;
import com.sun.ts.tests.webservices12.ejb.annotations.WSEjbMultipleClientInjectionTest2.HelloService;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.xml.ws.WebServiceRef;

public class Client
extends EETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private URL url = null;
    private URLConnection urlConn = null;
    private String SERVLET = "/WSEjbMultipleClientInjectionTest2Clnt2_web/ServletTest";
    private Hello port;
    @WebServiceRef(name="service/wsejbmultipleclientinjectiontest2")
    static HelloService service = null;

    private void getPort() throws Exception {
        TestUtil.logMsg((String)"Get wsejbmultipleclientinjectiontest2 Service via @WebServiceRef annotation");
        TestUtil.logMsg((String)"Uses name attribute @WebServiceRef(name=\"service/wsejbmultipleclientinjectiontest2\")");
        TestUtil.logMsg((String)("service=" + (Object)((Object)service)));
        TestUtil.logMsg((String)"Get port from service");
        this.port = service.getHello();
        TestUtil.logMsg((String)("port=" + this.port));
        TestUtil.logMsg((String)"Port obtained");
        JAXWS_Util.dumpTargetEndpointAddress(this.port);
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            if (pass) {
                this.getPort();
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void MultipleClientInjectionMultipleClntEarsTest() throws EETest.Fault {
        boolean pass = true;
        TestUtil.logMsg((String)"MultipleClientInjectionMultipleClntEarsTest");
        TestUtil.logMsg((String)"Test injection in both appclient and servletclient");
        try {
            TestUtil.logMsg((String)"Test appclient injection .....");
            if (service == null) {
                TestUtil.logErr((String)"appclient injection failed");
                pass = false;
            } else {
                TestUtil.logMsg((String)"appclient injection passed");
            }
            TestUtil.logMsg((String)"Test servletclient injection .....");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            this.props.setProperty("TEST", "test2");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = p.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                TestUtil.logErr((String)"servletclient injection failed");
                pass = false;
            } else {
                TestUtil.logMsg((String)"servletclient injection passed");
            }
        }
        catch (Throwable t) {
            throw new EETest.Fault("MultipleClientInjectionMultipleClntEarsTest failed");
        }
        if (!pass) {
            throw new EETest.Fault("MultipleClientInjectionMultipleClntEarsTest failed");
        }
    }

    public void MultipleClientInjectionMultipleClntEarsInvokeHelloBye() throws EETest.Fault {
        boolean pass = true;
        TestUtil.logMsg((String)"MultipleClientInjectionMultipleClntEarsInvokeHelloBye");
        TestUtil.logMsg((String)"Test injection in both appclient and servletclient");
        try {
            TestUtil.logMsg((String)"Test appclient invocation .....");
            TestUtil.logMsg((String)"Invoke hello method");
            String txt = this.port.hello("Hello there");
            if (txt.equals("Hello there to you too!")) {
                TestUtil.logMsg((String)"Invoke of hello passed");
            } else {
                pass = false;
                TestUtil.logErr((String)"Invoke of hello failed");
            }
            TestUtil.logMsg((String)"Invoke bye method");
            txt = this.port.bye("Bye");
            if (txt.equals("Bye and take care!")) {
                TestUtil.logMsg((String)"Invoke of bye passed");
            } else {
                pass = false;
                TestUtil.logErr((String)"Invoke of bye failed");
            }
            TestUtil.logMsg((String)"Test servletclient invocation .....");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            this.props.setProperty("TEST", "test2");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = p.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
            }
        }
        catch (Throwable t) {
            throw new EETest.Fault("MultipleClientInjectionMultipleClntEarsInvokeHelloBye failed");
        }
        if (!pass) {
            throw new EETest.Fault("MultipleClientInjectionMultipleClntEarsInvokeHelloBye failed");
        }
    }
}

