/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.ee.w2j.rpc.encoded.simpletest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Util;
import com.sun.ts.tests.jaxrpc.ee.w2j.rpc.encoded.simpletest.Hello;
import java.net.URL;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.Service;
import javax.xml.rpc.Stub;

public class Client
extends ServiceEETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private static final String MODEPROP = "platform.mode";
    String modeProperty = null;
    private static final String PKG_NAME = "com.sun.ts.tests.jaxrpc.ee.w2j.rpc.encoded.simpletest.";
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private final String NAMESPACEURI = "http://simpletestservice.org/wsdl";
    private QName SERVICE_QNAME;
    private QName PORT_QNAME;
    private static final String ENDPOINT_URL = "w2jsimpletest.endpoint.1";
    private static final String WSDLLOC_URL = "w2jsimpletest.wsdlloc.1";
    private String url = null;
    private URL wsdlurl = null;
    Hello port = null;
    Stub stub = null;
    Service service = null;

    private void getTestURLs() throws Exception {
        TestUtil.logMsg((String)"Get URL's used by the test");
        String file = JAXRPC_Util.getURLFromProp(ENDPOINT_URL);
        this.url = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXRPC_Util.getURLFromProp(WSDLLOC_URL);
        this.wsdlurl = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, file);
        TestUtil.logMsg((String)("Service Endpoint URL: " + this.url));
        TestUtil.logMsg((String)("WSDL Location URL:    " + this.wsdlurl));
    }

    private void getStubStandalone() throws Exception {
        TestUtil.logMsg((String)"Get stub from service implementation class using JAXRPC porting instance");
        this.port = (Hello)JAXRPC_Util.getStub("com.sun.ts.tests.jaxrpc.ee.w2j.rpc.encoded.simpletest.SimpleTestService", "getHelloPort");
        TestUtil.logMsg((String)"Cast stub to base Stub class ...");
        this.stub = (Stub)this.port;
    }

    private void getStub() throws Exception {
        InitialContext ic = new InitialContext();
        TestUtil.logMsg((String)"Obtained InitialContext");
        this.service = (Service)ic.lookup("java:comp/env/service/w2jresimpletest");
        TestUtil.logMsg((String)"Obtained service");
        this.port = (Hello)this.service.getPort(Hello.class);
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        this.SERVICE_QNAME = new QName("http://simpletestservice.org/wsdl", "SimpleTestService");
        this.PORT_QNAME = new QName("http://simpletestservice.org/wsdl", "HelloPort");
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            this.modeProperty = p.getProperty(MODEPROP);
            if (this.modeProperty.equals("standalone")) {
                this.getTestURLs();
                this.getStubStandalone();
                TestUtil.logMsg((String)("Setting target endpoint to " + this.url + " ..."));
                this.stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.url);
            } else {
                this.getStub();
                String file = JAXRPC_Util.getURLFromProp(ENDPOINT_URL);
                this.url = new TSURL().getURLString(PROTOCOL, this.hostname, this.portnum, file);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setup failed:", e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void InvokeRPCViaStubTest() throws EETest.Fault {
        TestUtil.logTrace((String)"InvokeRPCViaStubTest");
        boolean pass = true;
        String singleLineExpected = "Hello, foo!";
        String multiLineExpected = "Hello, bar\nand\nGoodbye!";
        try {
            TestUtil.logMsg((String)("Invoking RPC method hello(\"foo\") and expect '" + singleLineExpected + "' ..."));
            String response = this.port.hello("foo");
            if (!response.equals(singleLineExpected)) {
                TestUtil.logErr((String)("RPC failed - expected \"" + singleLineExpected + "\", received: " + response));
                pass = false;
            } else {
                TestUtil.logMsg((String)("RPC passed - received expected response: " + response));
            }
            TestUtil.logMsg((String)("Invoking RPC method hello(\"bar\nand\nGoodbye!\") and expect '" + multiLineExpected + "' ..."));
            response = this.port.hello("bar\nand\nGoodbye");
            if (!response.equals(multiLineExpected)) {
                TestUtil.logErr((String)("RPC failed - expected \"" + multiLineExpected + "\", received: " + response));
                pass = false;
            } else {
                TestUtil.logMsg((String)("RPC passed - received expected response: " + response));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("InvokeRPCViaStubTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("InvokeRPCViaStubTest failed");
        }
    }

    public void InvokeRPCViaDIITest() throws EETest.Fault {
        TestUtil.logTrace((String)"InvokeRPCViaDIITest");
        boolean pass = true;
        String expected = "Hello, foo!";
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.SERVICE_QNAME);
            } else {
                InitialContext ic = new InitialContext();
                TestUtil.logMsg((String)"Obtained InitialContext");
                service = (Service)ic.lookup("java:comp/env/service/w2jresimpletest2");
            }
            Call call = service.createCall();
            call = JAXRPC_Util.setCallProperties(call, " ");
            TestUtil.logMsg((String)"Initialize rest of Call object");
            call.setPortTypeName(this.PORT_QNAME);
            call.setTargetEndpointAddress(this.url);
            call.setOperationName(new QName("http://simpletestservice.org/wsdl", "hello"));
            boolean b = call.isParameterAndReturnSpecRequired(new QName("http://simpletestservice.org/wsdl", "hello"));
            if (b) {
                call.addParameter("string", new QName("http://www.w3.org/2001/XMLSchema", "string"), ParameterMode.IN);
                call.setReturnType(new QName("http://www.w3.org/2001/XMLSchema", "string"));
            }
            Object[] params = new String[]{new String("foo")};
            TestUtil.logMsg((String)("Invoking RPC method hello(\"foo\") and expect '" + expected + "' ..."));
            String response = (String)call.invoke(params);
            if (!response.equals(expected)) {
                TestUtil.logErr((String)("RPC failed - expected \"" + expected + "\", received: " + response));
                pass = false;
            } else {
                TestUtil.logMsg((String)("RPC passed - received expected response: " + response));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("InvokeRPCViaDIITest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("InvokeRPCViaDIITest failed");
        }
    }

    public void InvokeRPCViaDIIOneWayTest() throws EETest.Fault {
        TestUtil.logTrace((String)"InvokeRPCViaDIIOneWayTest");
        boolean pass = true;
        String expected = "Hello, foo!";
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.SERVICE_QNAME);
            } else {
                InitialContext ic = new InitialContext();
                TestUtil.logMsg((String)"Obtained InitialContext");
                service = (Service)ic.lookup("java:comp/env/service/w2jresimpletest2");
            }
            Call call = service.createCall();
            call = JAXRPC_Util.setCallProperties(call, " ");
            TestUtil.logMsg((String)"Initialize rest of Call object");
            call.setPortTypeName(this.PORT_QNAME);
            call.setTargetEndpointAddress(this.url);
            call.setOperationName(new QName("http://simpletestservice.org/wsdl", "helloOneWay"));
            boolean b = call.isParameterAndReturnSpecRequired(new QName("http://simpletestservice.org/wsdl", "helloOneWay"));
            if (b) {
                call.addParameter("string", new QName("http://www.w3.org/2001/XMLSchema", "string"), ParameterMode.IN);
            }
            Object[] params = new String[]{new String("foo")};
            TestUtil.logMsg((String)"Invoking RPC method helloOneWay(\"foo\") ...");
            call.invokeOneWay(params);
            TestUtil.logMsg((String)"RPC passed - invokeOneWay call successful");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("InvokeRPCViaDIIOneWayTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("InvokeRPCViaDIIOneWayTest failed");
        }
    }

    public void InvokeRPCViaDynProxyTest() throws EETest.Fault {
        TestUtil.logTrace((String)"InvokeRPCViaDynProxyTest");
        boolean pass = true;
        String expected = "Hello, foo!";
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.wsdlurl, this.SERVICE_QNAME);
            } else {
                InitialContext ic = new InitialContext();
                TestUtil.logMsg((String)"Obtained InitialContext");
                service = (Service)ic.lookup("java:comp/env/service/w2jresimpletest");
            }
            TestUtil.logMsg((String)"Obtained service");
            Hello hello = (Hello)service.getPort(this.PORT_QNAME, Hello.class);
            TestUtil.logMsg((String)("Invoking RPC method hello(\"foo\") and expect '" + expected + "' ..."));
            if (hello != null) {
                String response = hello.hello("foo");
                if (!response.equals(expected)) {
                    TestUtil.logErr((String)("RPC failed - expected \"" + expected + "\", received: " + response));
                    pass = false;
                } else {
                    TestUtil.logMsg((String)("RPC passed - received expected response: " + response));
                }
            } else {
                TestUtil.logErr((String)"RPC failed - proxy object returned was null");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("InvokeRPCViaDynProxyTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("InvokeRPCViaDynProxyTest failed");
        }
    }
}

