/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.concurrency.api.SkippedException;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import java.io.Serializable;
import java.util.Properties;
import javax.enterprise.concurrent.SkippedException;

public class Client
extends ServiceEETest
implements Serializable {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
    }

    public void SkippedExceptionNoArgTest() throws EETest.Fault {
        boolean pass = false;
        try {
            throw new SkippedException();
        }
        catch (SkippedException se) {
            TestUtil.logTrace((String)"SkippedException Caught as Expected");
            if (se.getMessage() == null) {
                TestUtil.logTrace((String)"Received expected null message");
                pass = true;
            } else {
                TestUtil.logErr((String)("SkippedException should have had null message, actual message=" + se.getMessage()));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("SkippedExceptionNoArgTest failed");
        }
    }

    public void SkippedExceptionStringTest() throws EETest.Fault {
        boolean pass = false;
        String expected = "thisisthedetailmessage";
        try {
            throw new SkippedException(expected);
        }
        catch (SkippedException se) {
            TestUtil.logTrace((String)"SkippedException Caught as Expected");
            if (se.getMessage().equals(expected)) {
                TestUtil.logTrace((String)"Received expected message");
                pass = true;
            } else {
                TestUtil.logErr((String)("Expected:" + expected + ", actual message=" + se.getMessage()));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("SkippedExceptionStringTest failed");
        }
    }

    public void SkippedExceptionThrowableTest() throws EETest.Fault {
        Throwable cause;
        boolean pass1 = false;
        boolean pass2 = false;
        Throwable expected = new Throwable("thisisthethrowable");
        try {
            throw new SkippedException(expected);
        }
        catch (SkippedException se) {
            TestUtil.logTrace((String)"SkippedException Caught as Expected");
            cause = se.getCause();
            if (cause.equals(expected)) {
                TestUtil.logTrace((String)"Received expected cause");
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Expected:" + expected + ", actual message=" + cause));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        expected = null;
        try {
            throw new SkippedException(expected);
        }
        catch (SkippedException se) {
            TestUtil.logTrace((String)"SkippedException Caught as Expected");
            cause = se.getCause();
            if (cause == null) {
                TestUtil.logTrace((String)"Received expected null cause");
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Expected:null, actual message=" + cause));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("SkippedExceptionThrowableTest failed");
        }
    }

    public void SkippedExceptionStringThrowableTest() throws EETest.Fault {
        Throwable cause;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        String sExpected = "thisisthedetailmessage";
        Throwable tExpected = new Throwable("thisisthethrowable");
        try {
            throw new SkippedException(sExpected, tExpected);
        }
        catch (SkippedException se) {
            TestUtil.logTrace((String)"SkippedException Caught as Expected");
            if (se.getMessage().equals(sExpected)) {
                TestUtil.logTrace((String)"Received expected message");
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Expected:" + sExpected + ", actual message=" + se.getMessage()));
            }
            cause = se.getCause();
            if (cause.equals(tExpected)) {
                TestUtil.logTrace((String)"Received expected cause");
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Expected:" + tExpected + ", actual message=" + cause));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        tExpected = null;
        try {
            throw new SkippedException(sExpected, tExpected);
        }
        catch (SkippedException se) {
            TestUtil.logTrace((String)"SkippedException Caught as Expected");
            if (se.getMessage().equals(sExpected)) {
                TestUtil.logTrace((String)"Received expected message");
                pass3 = true;
            } else {
                TestUtil.logErr((String)("Expected:" + sExpected + ", actual message=" + se.getMessage()));
            }
            cause = se.getCause();
            if (cause == null) {
                TestUtil.logTrace((String)"Received expected null cause");
                pass4 = true;
            } else {
                TestUtil.logErr((String)("Expected:null, actual message=" + cause));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new EETest.Fault("SkippedExceptionStringThrowableTest failed");
        }
    }
}

