/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsonobjecttests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import com.sun.ts.tests.jsonp.api.jsonobjecttests.CreateObjectBuilder;
import com.sun.ts.tests.jsonp.api.jsonobjecttests.ObjectBuild;
import com.sun.ts.tests.jsonp.common.JSONP_Util;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.JsonWriter;

public class Client
extends ServiceEETest {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void jsonObjectTest1() throws EETest.Fault {
        boolean pass = true;
        try {
            JsonObject myJsonObject;
            this.logMsg("Create sample JsonObject for testing");
            JsonObject object = JSONP_Util.createSampleJsonObject();
            this.logMsg("Create sample JsonArray for testing");
            JsonArray array = JSONP_Util.createSampleJsonArray();
            this.logMsg("Create the expected map of JsonObject values");
            HashMap<String, JsonValue> expMap = new HashMap<String, JsonValue>();
            expMap.put("false", JsonValue.FALSE);
            expMap.put("true", JsonValue.TRUE);
            expMap.put("null", JsonValue.NULL);
            expMap.put("doublemin", (JsonValue)JSONP_Util.createJsonNumber(Double.MIN_VALUE));
            expMap.put("doublemax", (JsonValue)JSONP_Util.createJsonNumber(Double.MAX_VALUE));
            expMap.put("intmin", (JsonValue)JSONP_Util.createJsonNumber(Integer.MIN_VALUE));
            expMap.put("intmax", (JsonValue)JSONP_Util.createJsonNumber(Integer.MAX_VALUE));
            expMap.put("longmin", (JsonValue)JSONP_Util.createJsonNumber(Long.MIN_VALUE));
            expMap.put("longmax", (JsonValue)JSONP_Util.createJsonNumber(Long.MAX_VALUE));
            expMap.put("bigdecimal", (JsonValue)JSONP_Util.createJsonNumber(BigDecimal.valueOf(1.2345678912345679E8)));
            expMap.put("biginteger", (JsonValue)JSONP_Util.createJsonNumber(new BigInteger("123456789")));
            expMap.put("string", (JsonValue)JSONP_Util.createJsonString("string1"));
            expMap.put("false2", JsonValue.FALSE);
            expMap.put("true2", JsonValue.TRUE);
            expMap.put("null2", JsonValue.NULL);
            expMap.put("object", (JsonValue)object);
            expMap.put("array", (JsonValue)array);
            JSONP_Util.dumpMap(expMap, "Expected Map");
            this.logMsg("Create JsonObject using all JsonObjectBuilder API's");
            JsonObject actMap = myJsonObject = Json.createObjectBuilder().add("false", JsonValue.FALSE).add("true", JsonValue.TRUE).add("null", JsonValue.NULL).add("doublemin", Double.MIN_VALUE).add("doublemax", Double.MAX_VALUE).add("intmin", Integer.MIN_VALUE).add("intmax", Integer.MAX_VALUE).add("longmin", Long.MIN_VALUE).add("longmax", Long.MAX_VALUE).add("bigdecimal", BigDecimal.valueOf(1.2345678912345679E8)).add("biginteger", new BigInteger("123456789")).add("string", "string1").add("false2", false).add("true2", true).addNull("null2").add("object", (JsonValue)object).add("array", (JsonValue)array).build();
            JSONP_Util.dumpMap((Map<String, JsonValue>)actMap, "Actual Map");
            this.logMsg("Compare actual Map of JsonObject values with expected Map of JsonObject values");
            pass = JSONP_Util.assertEqualsMap(expMap, (Map<String, JsonValue>)actMap);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonObjectTest1 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonObjectTest1 Failed");
        }
    }

    public void jsonObjectTest2() throws EETest.Fault {
        boolean pass = true;
        try {
            JsonObject myJsonObject2;
            this.logMsg("Create sample JsonObject for testing");
            JsonObject object = JSONP_Util.createSampleJsonObject();
            this.logMsg("Create sample JsonArray for testing");
            JsonArray array = JSONP_Util.createSampleJsonArray();
            this.logMsg("Create JsonObject 'myJsonObject1' using all JsonObjectBuilder API's");
            JsonObject myJsonObject1 = Json.createObjectBuilder().add("false", JsonValue.FALSE).add("true", JsonValue.TRUE).add("null", JsonValue.NULL).add("doublemin", Double.MIN_VALUE).add("doublemax", Double.MAX_VALUE).add("intmin", Integer.MIN_VALUE).add("intmax", Integer.MAX_VALUE).add("longmin", Long.MIN_VALUE).add("longmax", Long.MAX_VALUE).add("bigdecimal", BigDecimal.valueOf(1.2345678912345679E8)).add("biginteger", new BigInteger("123456789")).add("string", "string1").add("false2", false).add("true2", true).addNull("null2").add("object", (JsonValue)object).add("array", (JsonValue)array).build();
            this.logMsg("Write the JsonObject 'myJsonObject1' out to a JsonWriter");
            StringWriter sw = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sw);){
                writer.writeObject(myJsonObject1);
                this.logMsg("Close JsonWriter");
            }
            this.logMsg("Save contents of the JsonWriter as a String");
            String contents = sw.toString();
            this.logMsg("Dump contents of JsonWriter as a String");
            this.logMsg("JsonWriterContents=" + contents);
            this.logMsg("Read the JsonObject back into 'myJsonObject2' using a JsonReader");
            try (JsonReader reader = Json.createReader((Reader)new StringReader(contents));){
                myJsonObject2 = reader.readObject();
                this.logMsg("Save contents of the JsonReader as a String");
                contents = reader.toString();
            }
            this.logMsg("Dump contents of JsonReader as a String");
            this.logMsg("JsonReaderContents=" + contents);
            this.logMsg("Compare myJsonObject1 and myJsonObject2 for equality");
            pass = JSONP_Util.assertEqualsJsonObjects(myJsonObject1, myJsonObject2);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonObjectTest2 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonObjectTest2 Failed");
        }
    }

    public void jsonObjectTest3() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create sample JsonObject for testing");
            JsonObject object = JSONP_Util.createSampleJsonObject();
            this.logMsg("Create sample JsonArray for testing");
            JsonArray array = JSONP_Util.createSampleJsonArray();
            this.logMsg("Create myObject JsonObject with 22 name/value pairs");
            JsonObject myObject = Json.createObjectBuilder().add("key0", -1).add("key1", 1).add("key2", 1).add("key3", -1000.0).add("key4", 1000.0).add("key5", 1000.0).add("key6", -2000.0).add("key7", 2000.0).add("key8", 2000.0).add("key9", Long.MAX_VALUE).add("key10", Long.MIN_VALUE).add("key11", Integer.MAX_VALUE).add("key12", Integer.MIN_VALUE).add("key13", Double.MAX_VALUE).add("key14", Double.MIN_VALUE).add("key15", BigDecimal.valueOf(1.2345678912345679E8)).add("key16", new BigInteger("123456789")).add("key17", JsonValue.TRUE).add("key18", JsonValue.FALSE).add("key19", JsonValue.NULL).add("key20", "!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM").add("key21", false).add("key22", true).addNull("key23").add("key24", (JsonValue)object).add("key25", (JsonValue)array).build();
            this.logMsg("Checking intValue of key0 for correctness");
            if (!JSONP_Util.assertEquals(-1, myObject.getJsonNumber("key0").intValue())) {
                pass = false;
            }
            this.logMsg("key0 via JsonNumber.toString()=" + myObject.getJsonNumber("key0").toString());
            this.logMsg("Checking intValue of key1 for correctness");
            if (!JSONP_Util.assertEquals(1, myObject.getInt("key1"))) {
                pass = false;
            }
            this.logMsg("key1 via JsonNumber.toString()=" + myObject.getInt("key1"));
            this.logMsg("Checking intValue of key2 for correctness");
            if (!JSONP_Util.assertEquals(1, myObject.getJsonNumber("key2").intValue())) {
                pass = false;
            }
            this.logMsg("key2 via JsonNumber.toString()=" + myObject.getJsonNumber("key2").toString());
            this.logMsg("Checking intValue of key3 for correctness");
            if (!JSONP_Util.assertEquals(-1000, myObject.getInt("key3"))) {
                pass = false;
            }
            this.logMsg("key3 via JsonNumber.toString()=" + myObject.getJsonNumber("key3").toString());
            this.logMsg("Checking intValue of key4 for correctness");
            if (!JSONP_Util.assertEquals(1000, myObject.getJsonNumber("key4").intValue())) {
                pass = false;
            }
            this.logMsg("key4 via JsonNumber.toString()=" + myObject.getJsonNumber("key4").toString());
            this.logMsg("Checking intValue of key5 for correctness");
            if (!JSONP_Util.assertEquals(1000, myObject.getJsonNumber("key5").intValue())) {
                pass = false;
            }
            this.logMsg("key5 via JsonNumber.toString()=" + myObject.getJsonNumber("key5").toString());
            this.logMsg("Checking intValue of key6 for correctness");
            if (!JSONP_Util.assertEquals(-2000, myObject.getJsonNumber("key6").intValue())) {
                pass = false;
            }
            this.logMsg("key6 via JsonNumber.toString()=" + myObject.getJsonNumber("key6").toString());
            this.logMsg("Checking intValue of key7 for correctness");
            if (!JSONP_Util.assertEquals(2000, myObject.getJsonNumber("key7").intValue())) {
                pass = false;
            }
            this.logMsg("key7 via JsonNumber.toString()=" + myObject.getJsonNumber("key7").toString());
            this.logMsg("Checking intValue of key8 for correctness");
            if (!JSONP_Util.assertEquals(2000, myObject.getJsonNumber("key8").intValue())) {
                pass = false;
            }
            this.logMsg("key8 via JsonNumber.toString()=" + myObject.getJsonNumber("key8").toString());
            this.logMsg("Checking longValue of key9 for correctness");
            if (!JSONP_Util.assertEquals(Long.MAX_VALUE, myObject.getJsonNumber("key9").longValue())) {
                pass = false;
            }
            this.logMsg("LongMax via JsonNumber.toString()=" + myObject.getJsonNumber("key9").toString());
            if (!JSONP_Util.assertEquals("9223372036854775807", myObject.getJsonNumber("key9").toString())) {
                pass = false;
            }
            this.logMsg("Checking longValue of key10 for correctness");
            if (!JSONP_Util.assertEquals(Long.MIN_VALUE, myObject.getJsonNumber("key10").longValue())) {
                pass = false;
            }
            this.logMsg("LongMin via JsonNumber.toString()=" + myObject.getJsonNumber("key10").toString());
            if (!JSONP_Util.assertEquals("-9223372036854775808", myObject.getJsonNumber("key10").toString())) {
                pass = false;
            }
            this.logMsg("Checking intValue of key11 for correctness");
            if (!JSONP_Util.assertEquals(Integer.MAX_VALUE, myObject.getJsonNumber("key11").intValue())) {
                pass = false;
            }
            this.logMsg("IntMax via JsonNumber.toString()=" + myObject.getJsonNumber("key11").toString());
            if (!JSONP_Util.assertEquals("2147483647", myObject.getJsonNumber("key11").toString())) {
                pass = false;
            }
            this.logMsg("Checking intValue of key12 for correctness");
            if (!JSONP_Util.assertEquals(Integer.MIN_VALUE, myObject.getJsonNumber("key12").intValue())) {
                pass = false;
            }
            this.logMsg("IntMin via JsonNumber.toString()=" + myObject.getJsonNumber("key12").toString());
            if (!JSONP_Util.assertEquals("-2147483648", myObject.getJsonNumber("key12").toString())) {
                pass = false;
            }
            this.logMsg("Checking doubleValue of key13 for correctness");
            if (!JSONP_Util.assertEquals(Double.MAX_VALUE, myObject.getJsonNumber("key13").doubleValue())) {
                pass = false;
            }
            this.logMsg("Checking doubleValue of key14 for correctness");
            if (!JSONP_Util.assertEquals(Double.MIN_VALUE, myObject.getJsonNumber("key14").doubleValue())) {
                pass = false;
            }
            this.logMsg("Checking bigDecimalValue of key15 for correctness");
            if (!JSONP_Util.assertEquals(BigDecimal.valueOf(1.2345678912345679E8), myObject.getJsonNumber("key15").bigDecimalValue())) {
                pass = false;
            }
            this.logMsg("Checking bigIntegerValue of key16 for correctness");
            if (!JSONP_Util.assertEquals(new BigInteger("123456789"), myObject.getJsonNumber("key16").bigIntegerValue())) {
                pass = false;
            }
            this.logMsg("Checking getBoolean of key17 for correctness");
            if (!JSONP_Util.assertEquals(true, myObject.getBoolean("key17"))) {
                pass = false;
            }
            this.logMsg("Checking getBoolean of key18 for correctness");
            if (!JSONP_Util.assertEquals(false, myObject.getBoolean("key18"))) {
                pass = false;
            }
            this.logMsg("Checking isNull of key19 for correctness");
            if (!JSONP_Util.assertEquals(true, myObject.isNull("key19"))) {
                pass = false;
            }
            this.logMsg("Checking getJsonString of key20 for correctness");
            if (!JSONP_Util.assertEquals("!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM", myObject.getJsonString("key20").getString())) {
                pass = false;
            }
            this.logMsg("Checking getString of key20 for correctness");
            if (!JSONP_Util.assertEquals("!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM", myObject.getString("key20"))) {
                pass = false;
            }
            this.logMsg("Checking getBoolean of key21 for correctness");
            if (!JSONP_Util.assertEquals(false, myObject.getBoolean("key21"))) {
                pass = false;
            }
            this.logMsg("Checking getBoolean of key22 for correctness");
            if (!JSONP_Util.assertEquals(true, myObject.getBoolean("key22"))) {
                pass = false;
            }
            this.logMsg("Checking isNull of key23 for correctness");
            if (!JSONP_Util.assertEquals(true, myObject.isNull("key23"))) {
                pass = false;
            }
            this.logMsg("Checking getJsonObject of key24 for correctness");
            if (!JSONP_Util.assertEqualsJsonObjects(object, myObject.getJsonObject("key24"))) {
                pass = false;
            }
            this.logMsg("Checking getJsonArray of key25 for correctness");
            if (!JSONP_Util.assertEqualsJsonArrays(array, myObject.getJsonArray("key25"))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(true, myObject.getBoolean("key17"))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(false, myObject.getBoolean("key18"))) {
                pass = false;
            }
            this.logMsg("Testing JsonObject.getBoolean(String, boolean) with/without default value setting.");
            if (!JSONP_Util.assertEquals(true, myObject.getBoolean("key17", false))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(false, myObject.getBoolean("key18", true))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(true, myObject.getBoolean("key0", true))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(true, myObject.getBoolean("key19", true))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(true, myObject.getBoolean("key20", true))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(true, myObject.getBoolean("key24", true))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(true, myObject.getBoolean("key25", true))) {
                pass = false;
            }
            this.logMsg("Testing JsonObject.getInt(String, int) with/without default value setting.");
            if (!JSONP_Util.assertEquals(-1, myObject.getInt("key0", 10))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(10, myObject.getInt("key18", 10))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(10, myObject.getInt("key19", 10))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(10, myObject.getInt("key20", 10))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(10, myObject.getInt("key24", 10))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals(10, myObject.getInt("key25", 10))) {
                pass = false;
            }
            this.logMsg("Testing JsonObject.getString(String, String) with/without default value setting.");
            if (!JSONP_Util.assertEquals("!@#$%^&*()_+|~1234567890-=;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM", myObject.getString("key20", "foo"))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals("foo", myObject.getString("key0", "foo"))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals("foo", myObject.getString("key18", "foo"))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals("foo", myObject.getString("key19", "foo"))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals("foo", myObject.getString("key24", "foo"))) {
                pass = false;
            }
            if (!JSONP_Util.assertEquals("foo", myObject.getString("key25", "foo"))) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonObjectTest3 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonObjectTest3 Failed");
        }
    }

    public void jsonObjectTest4() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create sample JsonObject for testing");
            JsonObject myJsonObject1 = JSONP_Util.createSampleJsonObject();
            this.logMsg("Write the JsonObject 'myJsonObject1' out to a JsonWriter");
            StringWriter sw = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sw);){
                writer.writeObject(myJsonObject1);
                this.logMsg("Close JsonWriter");
            }
            this.logMsg("Save contents of the JsonWriter as a String");
            String contents = sw.toString();
            this.logMsg("Dump contents of JsonWriter as a String");
            this.logMsg("JsonWriterContents=" + contents);
            this.logMsg("Remove whitespace from contents.");
            String actJsonText = JSONP_Util.removeWhitespace(contents);
            this.logMsg("Compare expected JsonObject text with actual JsonObject text for equality");
            pass = JSONP_Util.assertEqualsJsonText("{\"firstName\":\"John\",\"lastName\":\"Smith\",\"age\":25,\"elderly\":false,\"patriot\":true,\"address\":{\"streetAddress\":\"21 2nd Street\",\"city\":\"New York\",\"state\":\"NY\",\"postalCode\":\"10021\"},\"phoneNumber\":[{\"type\":\"home\",\"number\":\"212 555-1234\"},{\"type\":\"cell\",\"number\":\"646 555-4567\"}],\"objectOfFooBar\":{\"objectFooBar\":{\"foo\":\"bar\"},\"arrayFooBar\":[\"foo\",\"bar\"]},\"arrayOfFooBar\":[{\"foo\":\"bar\"},[\"foo\",\"bar\"]]}", actJsonText);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonObjectTest4 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonObjectTest4 Failed");
        }
    }

    public void jsonObjectExceptionTests() throws EETest.Fault {
        JsonObject object;
        JsonObject value;
        JsonObject value2;
        Object value3;
        boolean pass = true;
        JsonObject testObject = null;
        JsonArray testArray = null;
        try {
            this.logMsg("Create sample JsonObject for testing");
            testObject = JSONP_Util.createSampleJsonObject();
            this.logMsg("Create sample JsonArray for testing");
            testArray = JSONP_Util.createSampleJsonArray();
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonObject to JsonNumber via getJsonNumber(String)");
            value3 = testObject.getJsonNumber("address");
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonObject to JsonString via getJsonString(String)");
            value3 = testObject.getJsonString("address");
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonObject to JsonArray via getJsonArray(String)");
            value3 = testObject.getJsonArray("address");
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonArray to JsonNumber via getNumber(String)");
            value3 = testObject.getJsonNumber("phoneNumber");
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonArray to JsonString via getJsonString(String)");
            value3 = testObject.getJsonString("phoneNumber");
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonObject to String via getString(String)");
            value3 = testObject.getString("address");
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonArray to String via getString(String)");
            value3 = testObject.getString("phoneNumber");
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonObject to int via getInt(String)");
            int value4 = testObject.getInt("address");
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonArray to int via getInt(String)");
            int value5 = testObject.getInt("phoneNumber");
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonArray to JsonObject via getJsonObject(String)");
            value2 = testObject.getJsonObject("phoneNumber");
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonNumber to JsonString via getJsonString(String)");
            value2 = testObject.getJsonString("age");
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonNumber to JsonObject via getJsonNumber(String)");
            value2 = testObject.getJsonObject("age");
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonNumber to JsonArray via getJsonArray(String)");
            value2 = testObject.getJsonArray("age");
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonString to JsonNumber via getJsonNumber(String)");
            value2 = testObject.getJsonNumber("firstName");
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonString to int via getInt(String)");
            int value6 = testObject.getInt("firstName");
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonString to JsonObject via getJsonString(String)");
            value = testObject.getJsonObject("firstName");
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonString to JsonArray via getJsonArray(String)");
            value = testObject.getJsonArray("firstName");
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonValue.FALSE to JsonNumber via getJsonNumber(String)");
            value = testObject.getJsonNumber("elderly");
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonValue.FALSE to JsonString via getJsonString(String)");
            value = testObject.getJsonString("elderly");
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonValue.FALSE to JsonObject via getJsonObject(String)");
            value = testObject.getJsonObject("elderly");
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a JsonValue.FALSE to JsonArray via getJsonArray(String)");
            value = testObject.getJsonArray("elderly");
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a non JsonValue.FALSE|JsonValue.TRUE to boolean via getBoolean(String)");
            boolean value7 = testObject.getBoolean("firstName");
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a non JsonValue.FALSE|JsonValue.TRUE to boolean via getBoolean(String)");
            boolean value8 = testObject.getBoolean("age");
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a non JsonValue.FALSE|JsonValue.TRUE to boolean via getBoolean(String)");
            boolean value9 = testObject.getBoolean("objectOfFooBar");
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ClassCastException trying to cast a non JsonValue.FALSE|JsonValue.TRUE to boolean via getBoolean(String)");
            boolean value10 = testObject.getBoolean("arrayOfFooBar");
            pass = false;
            this.logErr("Failed to throw ClassCastException");
        }
        catch (ClassCastException e) {
            this.logMsg("Got expected ClassCastException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NumberFormatException calling add(String, Double.NaN)");
            object = Json.createObjectBuilder().add("double", Double.NaN).build();
            pass = false;
            this.logErr("Failed to throw NumberFormatException");
        }
        catch (NumberFormatException e) {
            this.logMsg("Got expected NumberFormatException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NumberFormatException calling add(String, Double.NEGATIVE_INFINITY)");
            object = Json.createObjectBuilder().add("double", Double.NEGATIVE_INFINITY).build();
            pass = false;
            this.logErr("Failed to throw NumberFormatException");
        }
        catch (NumberFormatException e) {
            this.logMsg("Got expected NumberFormatException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NumberFormatException calling add(String, Double.POSITIVE_INFINITY)");
            object = Json.createObjectBuilder().add("double", Double.POSITIVE_INFINITY).build();
            pass = false;
            this.logErr("Failed to throw NumberFormatException");
        }
        catch (NumberFormatException e) {
            this.logMsg("Got expected NumberFormatException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ArithmeticException calling add(\"number\", 12345.12345) and attempting to extract as an exact integer value");
            object = Json.createObjectBuilder().add("number", 12345.12345).build();
            this.logMsg("Call JsonObject.getJsonNumber(\"number\").intValueExact()");
            int value11 = object.getJsonNumber("number").intValueExact();
            pass = false;
            this.logErr("Failed to throw ArithmeticException");
        }
        catch (ArithmeticException e) {
            this.logMsg("Got expected ArithmeticException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ArithmeticException calling add(\"number\", 12345.12345) and attempting to extract as an exact long value");
            object = Json.createObjectBuilder().add("number", 12345.12345).build();
            this.logMsg("Call JsonObject.getJsonNumber(\"number\").longValueExact()");
            long value12 = object.getJsonNumber("number").longValueExact();
            pass = false;
            this.logErr("Failed to throw ArithmeticException");
        }
        catch (ArithmeticException e) {
            this.logMsg("Got expected ArithmeticException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip ArithmeticException calling add(\"number\", 12345.12345) and attempting to extract as an exact biginteger value");
            object = Json.createObjectBuilder().add("number", 12345.12345).build();
            this.logMsg("Call JsonObject.getJsonNumber(\"number\").bigIntegerValueExact()");
            BigInteger value13 = object.getJsonNumber("number").bigIntegerValueExact();
            pass = false;
            this.logErr("Failed to throw ArithmeticException");
        }
        catch (ArithmeticException e) {
            this.logMsg("Got expected ArithmeticException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip UnsupportedOperationException JsonObject.put(K,V) trying to modify JsonObject map which should be immutable");
            testObject.put((Object)"foo", (Object)JsonValue.FALSE);
            pass = false;
            this.logErr("Failed to throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            this.logMsg("Got expected UnsupportedOperationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip UnsupportedOperationException JsonObject.putAll(Map) trying to modify JsonObject map which should be immutable");
            testObject.putAll((Map)testObject);
            pass = false;
            this.logErr("Failed to throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            this.logMsg("Got expected UnsupportedOperationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip UnsupportedOperationException JsonObject.clear() trying to modify JsonObject map which should be immutable");
            testObject.clear();
            pass = false;
            this.logErr("Failed to throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            this.logMsg("Got expected UnsupportedOperationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip UnsupportedOperationException JsonObject.remove(K) trying to modify JsonObject map which should be immutable");
            testObject.remove((Object)"firstName");
            pass = false;
            this.logErr("Failed to throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            this.logMsg("Got expected UnsupportedOperationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NullPointerException for JsonObject.getBoolean(String) when no mapping exists for name.");
            boolean value14 = testObject.getBoolean("foo");
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NullPointerException for JsonObject.getInt(String) when no mapping exists for name.");
            int value15 = testObject.getInt("foo");
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NullPointerException for JsonObject.getString(String) when no mapping exists for name.");
            String value16 = testObject.getString("foo");
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NullPointerException for JsonObject.isNull(String) when no mapping exists for name.");
            boolean value17 = testObject.isNull("foo");
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonObjectExceptionTests Failed");
        }
    }

    public void jsonObjectNullNameValueExceptionTests() throws EETest.Fault {
        boolean pass = true;
        JsonObjectBuilder job = Json.createObjectBuilder();
        try {
            this.logMsg("Trip NullPointerException for JsonObjectBuilder.add(String, JsonValue) when name is null.");
            job.add(null, JsonValue.TRUE);
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NullPointerException for JsonObjectBuilder.add(String, JsonValue) when value is null.");
            job.add("name", (JsonValue)null);
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NullPointerException for JsonObjectBuilder.add(String, String) when name is null.");
            job.add(null, "value");
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NullPointerException for JsonObjectBuilder.add(String, String) when value is null.");
            job.add("name", (String)null);
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NullPointerException for JsonObjectBuilder.add(String, BigInteger) when name is null.");
            job.add(null, new BigInteger("123456789"));
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NullPointerException for JsonObjectBuilder.add(String, BigInteger) when value is null.");
            job.add("name", (BigInteger)null);
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NullPointerException for JsonObjectBuilder.add(String, BigDecimal) when name is null.");
            job.add(null, new BigDecimal("123456789"));
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NullPointerException for JsonObjectBuilder.add(String, BigDecimal) when value is null.");
            job.add("name", (BigDecimal)null);
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NullPointerException for JsonObjectBuilder.add(String, int) when name is null.");
            job.add(null, 123456789);
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NullPointerException for JsonObjectBuilder.add(String, long) when name is null.");
            job.add(null, 123456789L);
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NullPointerException for JsonObjectBuilder.add(String, double) when name is null.");
            job.add(null, 123456.789);
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NullPointerException for JsonObject.add(String, boolean) when name is null.");
            job.add(null, true);
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NullPointerException for JsonObject.addNull(String) when name is null.");
            job.addNull(null);
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NullPointerException for JsonObjectBuilder.add(String, JsonObjectBuilder) when name is null.");
            job.add(null, Json.createObjectBuilder());
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NullPointerException for JsonObjectBuilder.add(String, JsonObjectBuilder) when value is null.");
            job.add("name", (JsonObjectBuilder)null);
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NullPointerException for JsonArrayBuilder.add(String, JsonArrayBuilder) when name is null.");
            job.add(null, Json.createArrayBuilder());
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NullPointerException for JsonArrayBuilder.add(String, JsonArrayBuilder) when value is null.");
            job.add("name", (JsonArrayBuilder)null);
            pass = false;
            this.logErr("Failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logMsg("Got expected NullPointerException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonObjectNullNameValueExceptionTests Failed");
        }
    }

    public void jsonCreateObjectBuilder11Test() throws EETest.Fault {
        CreateObjectBuilder createTest = new CreateObjectBuilder();
        TestResult result = createTest.test();
        result.eval();
    }

    public void jsonObjectBuilder11Test() throws EETest.Fault {
        ObjectBuild buildTest = new ObjectBuild();
        TestResult result = buildTest.test();
        result.eval();
    }
}

