/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.web;

import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

public class WebServer {
    protected static final String PROTOCOL = "http";
    protected static final String WEB_HOST_PROP = "webServerHost";
    protected static final String WEB_PORT_PROP = "webServerPort";
    protected static final String RESULT_PROP = "ctsWebTestResult";
    protected static final String TEST_NAME_PROP = "ctsWebTestName";
    protected String host;
    protected int port;
    protected URL url;
    protected URLConnection conn;
    protected Properties props;

    private WebServer(String hostName, int portNumber, Properties p) throws IllegalArgumentException {
        if (null == hostName) {
            throw new IllegalArgumentException("null host name!");
        }
        this.host = hostName;
        this.port = portNumber;
        this.props = p;
    }

    public static WebServer newInstance(Properties props) throws IllegalArgumentException {
        int port;
        if (null == props) {
            String msg = "null properties!";
            TestUtil.logErr((String)("[TSTestURL] " + msg));
            throw new IllegalArgumentException(msg);
        }
        String host = props.getProperty(WEB_HOST_PROP);
        if (null == host || host.equals("")) {
            String msg = "Empty webServerHost property: " + host;
            WebServer.printConfigError(msg);
            throw new IllegalArgumentException(msg);
        }
        String portValue = props.getProperty(WEB_PORT_PROP);
        if (null == portValue || portValue.equals("")) {
            String msg = "Empty webServerPort property: " + portValue;
            WebServer.printConfigError(msg);
            throw new IllegalArgumentException(msg);
        }
        try {
            port = Integer.parseInt(portValue);
        }
        catch (Exception e) {
            String msg = "Invalid webServerPort property: '" + portValue + "' : " + e.getMessage();
            WebServer.printConfigError(msg);
            throw new IllegalArgumentException(msg);
        }
        return new WebServer(host, port, props);
    }

    public boolean test(String webFile, String testName) {
        return null != this.call(webFile, testName, this.props);
    }

    public Properties call(String webFile, String testName, Properties args) throws IllegalArgumentException {
        Properties results;
        if (null == args) {
            throw new IllegalArgumentException("null args!");
        }
        try {
            args.setProperty(TEST_NAME_PROP, testName);
            URL url = new TSURL().getURL(PROTOCOL, this.host, this.port, webFile);
            this.conn = TestUtil.sendPostData((Properties)args, (URL)url);
            TestUtil.logMsg((String)("Getting response from url connection: " + url.toString()));
            results = TestUtil.getResponseProperties((URLConnection)this.conn);
            if (null == results) {
                TestUtil.logErr((String)"[TSTestURL] null response props!");
                return null;
            }
            String status = results.getProperty(RESULT_PROP);
            if (!Boolean.valueOf(status).booleanValue()) {
                return null;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            e.printStackTrace();
            return null;
        }
        return results;
    }

    protected static void printConfigError(String msg) {
        TestUtil.logErr((String)("[TSTestURL] " + msg));
        TestUtil.logErr((String)"Please check you that webServerHost and webServerPort properties are set correctly in you ts.jte file");
    }
}

