/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.listener.AbstractItemWriteListener;
import jakarta.batch.runtime.context.JobContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import java.util.logging.Logger;

@Named(value="myItemWriteListenerImpl")
public class MyItemWriteListenerImpl
extends AbstractItemWriteListener {
    private static final String sourceClass = MyItemWriteListenerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    int beforecounter = 1;
    int aftercounter = 1;
    public static final String GOOD_EXIT_STATUS = "MyItemWriteListener: GOOD STATUS";
    public static final String BAD_EXIT_STATUS = "MyItemWriteListener: BAD STATUS";
    @Inject
    JobContext jobCtx;
    @Inject
    @BatchProperty(name="app.listenertest")
    String applistenerTest;

    public void beforeWrite(List<Object> items) throws Exception {
        if (items != null && "WRITE".equals(this.applistenerTest)) {
            logger.finer("In beforeWrite()");
            ++this.beforecounter;
            logger.fine("AJM: beforecounter = " + this.beforecounter);
        }
    }

    public void afterWrite(List<Object> items) throws Exception {
        logger.fine("AJM: applistenerTest = " + this.applistenerTest);
        if (items != null && "WRITE".equals(this.applistenerTest)) {
            logger.finer("In afterWrite()");
            ++this.aftercounter;
            logger.fine("AJM: aftercounter = " + this.aftercounter);
            if (this.beforecounter == this.aftercounter) {
                this.jobCtx.setExitStatus(GOOD_EXIT_STATUS);
            } else {
                this.jobCtx.setExitStatus(BAD_EXIT_STATUS);
            }
        }
    }

    public void onWriteError(List<Object> items, Exception e) throws Exception {
        logger.finer("In onWriteError()" + e);
        this.jobCtx.setExitStatus("MyItemWriteListenerImpl.onWriteError");
    }
}

