/**
 * Copyright (c) 2010, 2012 Obeo.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Obeo - initial API and implementation
 */
package org.eclipse.mylyn.docs.intent.core.document.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

import org.eclipse.mylyn.docs.intent.core.document.*;

import org.eclipse.mylyn.docs.intent.markup.markup.Container;
import org.eclipse.mylyn.docs.intent.markup.markup.HasAttributes;
import org.eclipse.mylyn.docs.intent.markup.markup.Section;
import org.eclipse.mylyn.docs.intent.markup.markup.StructureElement;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.mylyn.docs.intent.core.document.IntentDocumentPackage
 * @generated
 */
public class IntentDocumentSwitch<T> extends Switch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static IntentDocumentPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IntentDocumentSwitch() {
		if (modelPackage == null) {
			modelPackage = IntentDocumentPackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @parameter ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case IntentDocumentPackage.INTENT_GENERIC_ELEMENT: {
				IntentGenericElement intentGenericElement = (IntentGenericElement)theEObject;
				T result = caseIntentGenericElement(intentGenericElement);
				if (result == null)
					result = defaultCase(theEObject);
				return result;
			}
			case IntentDocumentPackage.INTENT_STRUCTURED_ELEMENT: {
				IntentStructuredElement intentStructuredElement = (IntentStructuredElement)theEObject;
				T result = caseIntentStructuredElement(intentStructuredElement);
				if (result == null)
					result = caseSection(intentStructuredElement);
				if (result == null)
					result = caseIntentGenericElement(intentStructuredElement);
				if (result == null)
					result = caseStructureElement(intentStructuredElement);
				if (result == null)
					result = caseContainer(intentStructuredElement);
				if (result == null)
					result = caseHasAttributes(intentStructuredElement);
				if (result == null)
					result = defaultCase(theEObject);
				return result;
			}
			case IntentDocumentPackage.INTENT_SECTION: {
				IntentSection intentSection = (IntentSection)theEObject;
				T result = caseIntentSection(intentSection);
				if (result == null)
					result = caseIntentStructuredElement(intentSection);
				if (result == null)
					result = caseSection(intentSection);
				if (result == null)
					result = caseIntentGenericElement(intentSection);
				if (result == null)
					result = caseStructureElement(intentSection);
				if (result == null)
					result = caseContainer(intentSection);
				if (result == null)
					result = caseHasAttributes(intentSection);
				if (result == null)
					result = defaultCase(theEObject);
				return result;
			}
			case IntentDocumentPackage.INTENT_DOCUMENT: {
				IntentDocument intentDocument = (IntentDocument)theEObject;
				T result = caseIntentDocument(intentDocument);
				if (result == null)
					result = caseIntentSection(intentDocument);
				if (result == null)
					result = caseIntentStructuredElement(intentDocument);
				if (result == null)
					result = caseSection(intentDocument);
				if (result == null)
					result = caseIntentGenericElement(intentDocument);
				if (result == null)
					result = caseStructureElement(intentDocument);
				if (result == null)
					result = caseContainer(intentDocument);
				if (result == null)
					result = caseHasAttributes(intentDocument);
				if (result == null)
					result = defaultCase(theEObject);
				return result;
			}
			case IntentDocumentPackage.GENERIC_UNIT: {
				GenericUnit genericUnit = (GenericUnit)theEObject;
				T result = caseGenericUnit(genericUnit);
				if (result == null)
					result = caseIntentGenericElement(genericUnit);
				if (result == null)
					result = defaultCase(theEObject);
				return result;
			}
			case IntentDocumentPackage.UNIT_INSTRUCTION: {
				UnitInstruction unitInstruction = (UnitInstruction)theEObject;
				T result = caseUnitInstruction(unitInstruction);
				if (result == null)
					result = caseIntentGenericElement(unitInstruction);
				if (result == null)
					result = defaultCase(theEObject);
				return result;
			}
			case IntentDocumentPackage.INTENT_REFERENCE_INSTRUCTION: {
				IntentReferenceInstruction intentReferenceInstruction = (IntentReferenceInstruction)theEObject;
				T result = caseIntentReferenceInstruction(intentReferenceInstruction);
				if (result == null)
					result = caseUnitInstruction(intentReferenceInstruction);
				if (result == null)
					result = caseIntentReference(intentReferenceInstruction);
				if (result == null)
					result = caseIntentGenericElement(intentReferenceInstruction);
				if (result == null)
					result = defaultCase(theEObject);
				return result;
			}
			case IntentDocumentPackage.LABEL_DECLARATION: {
				LabelDeclaration labelDeclaration = (LabelDeclaration)theEObject;
				T result = caseLabelDeclaration(labelDeclaration);
				if (result == null)
					result = caseUnitInstruction(labelDeclaration);
				if (result == null)
					result = caseIntentGenericElement(labelDeclaration);
				if (result == null)
					result = defaultCase(theEObject);
				return result;
			}
			case IntentDocumentPackage.LABEL_REFERENCE_INSTRUCTION: {
				LabelReferenceInstruction labelReferenceInstruction = (LabelReferenceInstruction)theEObject;
				T result = caseLabelReferenceInstruction(labelReferenceInstruction);
				if (result == null)
					result = caseUnitInstruction(labelReferenceInstruction);
				if (result == null)
					result = caseIntentReference(labelReferenceInstruction);
				if (result == null)
					result = caseIntentGenericElement(labelReferenceInstruction);
				if (result == null)
					result = defaultCase(theEObject);
				return result;
			}
			case IntentDocumentPackage.INTENT_REFERENCE: {
				IntentReference intentReference = (IntentReference)theEObject;
				T result = caseIntentReference(intentReference);
				if (result == null)
					result = defaultCase(theEObject);
				return result;
			}
			default:
				return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Intent Generic Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Intent Generic Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntentGenericElement(IntentGenericElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Intent Structured Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Intent Structured Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntentStructuredElement(IntentStructuredElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Intent Section</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Intent Section</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntentSection(IntentSection object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Intent Document</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Intent Document</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntentDocument(IntentDocument object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Generic Unit</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Generic Unit</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGenericUnit(GenericUnit object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Unit Instruction</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Unit Instruction</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseUnitInstruction(UnitInstruction object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Intent Reference Instruction</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Intent Reference Instruction</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntentReferenceInstruction(IntentReferenceInstruction object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Label Declaration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Label Declaration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLabelDeclaration(LabelDeclaration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Label Reference Instruction</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Label Reference Instruction</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLabelReferenceInstruction(LabelReferenceInstruction object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Intent Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Intent Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntentReference(IntentReference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Structure Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Structure Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStructureElement(StructureElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Container</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Container</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseContainer(Container object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Has Attributes</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Has Attributes</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHasAttributes(HasAttributes object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Section</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Section</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSection(Section object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T defaultCase(EObject object) {
		return null;
	}

} //IntentDocumentSwitch
