/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.hyperlinks;

import java.util.Iterator;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IRegion;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditor;
import org.eclipse.mylyn.docs.intent.client.ui.editor.hyperlinks.AbstractIntentHyperLink;
import org.eclipse.mylyn.docs.intent.client.ui.editor.renderers.IEditorRendererExtension;
import org.eclipse.mylyn.docs.intent.client.ui.internal.renderers.IEditorRendererExtensionRegistry;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.mylyn.docs.intent.collab.common.query.TraceabilityInformationsQuery;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ExternalContentReference;
import org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ResourceDeclaration;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenWorkingCopyResourceHyperLink
extends AbstractIntentHyperLink {
    private URI workingCopyResourceURI;
    private ExternalContentReference externalContentReference;

    public OpenWorkingCopyResourceHyperLink(IntentEditor textEditor, IRegion hyperlinkRegion, RepositoryAdapter repositoryAdapter, EObject element) {
        super(textEditor, hyperlinkRegion);
        this.workingCopyResourceURI = OpenWorkingCopyResourceHyperLink.getWorkingCopyResourceURI(repositoryAdapter, element);
        if (element instanceof ExternalContentReference) {
            this.externalContentReference = (ExternalContentReference)element;
        }
    }

    public static boolean canApply(RepositoryAdapter repositoryAdapter, EObject element) {
        return OpenWorkingCopyResourceHyperLink.getWorkingCopyResourceURI(repositoryAdapter, element) != null;
    }

    private static URI getWorkingCopyResourceURI(RepositoryAdapter repositoryAdapter, EObject element) {
        TraceabilityInformationsQuery traceabilityInformationsQuery;
        InstanciationInstruction correspondingInstanciationInstruction;
        URI workingCopyResourceURI = null;
        if (element instanceof ResourceDeclaration) {
            workingCopyResourceURI = URI.createURI((String)((ResourceDeclaration)element).getUri().toString().replace("\"", "").trim()).trimFragment();
        } else if (element instanceof ModelingUnitInstruction && (correspondingInstanciationInstruction = (traceabilityInformationsQuery = new TraceabilityInformationsQuery(repositoryAdapter)).getInstanciationInstruction((ModelingUnitInstruction)element)) != null) {
            workingCopyResourceURI = traceabilityInformationsQuery.getWorkingCopyResourceURI((ModelingUnitInstruction)correspondingInstanciationInstruction, true);
        }
        return workingCopyResourceURI;
    }

    public String getHyperlinkText() {
        return "Open Working copy Element";
    }

    public void open() {
        boolean editorIsOpened = false;
        if (this.externalContentReference != null) {
            Iterator<IEditorRendererExtension> rendererExtensions = IEditorRendererExtensionRegistry.getEditorRendererExtensions(this.externalContentReference).iterator();
            while (rendererExtensions.hasNext() && !editorIsOpened) {
                editorIsOpened = rendererExtensions.next().openEditor(this.externalContentReference);
            }
        }
        if (!editorIsOpened) {
            this.defaultOpen();
        }
    }

    protected void defaultOpen() {
        String fileExtension = this.workingCopyResourceURI.fileExtension();
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(this.workingCopyResourceURI.lastSegment());
        if (desc != null) {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new URIEditorInput(this.workingCopyResourceURI), desc.getId());
            }
            catch (PartInitException e) {
                IntentUiLogger.logError(e);
            }
        } else {
            IntentUiLogger.logError("Could not find editor for extension '" + fileExtension + "' (" + this.workingCopyResourceURI + ")", new RuntimeException());
        }
    }
}

