/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.compiler.externalcontent;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mylyn.docs.intent.client.compiler.generator.modelgeneration.ModelingUnitGenerator;
import org.eclipse.mylyn.docs.intent.collab.common.uri.IntentResourceFactory;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationMessageType;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatusSeverity;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilerFactory;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.document.UnitInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ExternalContentReference;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ResourceDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExternalContentReferenceGenerator {
    private ExternalContentReferenceGenerator() {
    }

    public static List<Object> generate(ExternalContentReference object, ModelingUnitGenerator modelingUnitGenerator) {
        Iterator previousCcompilationIssues = Iterables.filter((Iterable)Sets.newLinkedHashSet((Iterable)object.getCompilationStatus()), (Predicate)new Predicate<CompilationStatus>(){

            public boolean apply(CompilationStatus status) {
                return CompilationStatusSeverity.ERROR.equals((Object)status.getSeverity());
            }
        }).iterator();
        while (previousCcompilationIssues.hasNext()) {
            object.getCompilationStatus().remove(previousCcompilationIssues.next());
        }
        if (object.getExternalContent() == null || object.getExternalContent().eIsProxy() || object.isMarkedAsMerged()) {
            URI externalContentResourceURI = URI.createURI((String)object.getUri().toString().replace("\"", ""));
            if (IntentResourceFactory.getIntentFactoryScheme().equals(externalContentResourceURI.scheme())) {
                externalContentResourceURI = URI.createURI((String)(String.valueOf(externalContentResourceURI.toString()) + IntentResourceFactory.getCreateResourceIfNeededTag()));
            }
            try {
                object.setMarkedAsMerged(false);
                Resource externalContentResource = object.eResource().getResourceSet().getResource(externalContentResourceURI.trimFragment(), true);
                try {
                    EObject content = null;
                    EcoreUtil.Copier copier = new EcoreUtil.Copier(false, true);
                    content = externalContentResourceURI.hasFragment() ? copier.copy(externalContentResource.getEObject(externalContentResourceURI.fragment())) : EcoreUtil.copy((EObject)((EObject)externalContentResource.getContents().iterator().next()));
                    copier.copyReferences();
                    object.setExternalContent(content);
                }
                finally {
                    externalContentResource.unload();
                    externalContentResource.getResourceSet().getResources().remove((Object)externalContentResource);
                }
            }
            catch (Exception exception) {
                object.setExternalContent(null);
                CompilationStatus status = CompilerFactory.eINSTANCE.createCompilationStatus();
                status.setMessage("Could not find resource " + externalContentResourceURI);
                status.setTarget((IntentGenericElement)object);
                status.setSeverity(CompilationStatusSeverity.ERROR);
                status.setType(CompilationMessageType.RESOLVE_ERROR);
                object.getCompilationStatus().add((Object)status);
            }
        }
        modelingUnitGenerator.getInformationHolder().addResource((ResourceDeclaration)object);
        if (object.getExternalContent() != null) {
            modelingUnitGenerator.getInformationHolder().addResourceToGeneratedElementMapping((ResourceDeclaration)object, object.getExternalContent());
            modelingUnitGenerator.getInformationHolder().addCreatedElementsToCurrentList((UnitInstruction)object, object.getExternalContent());
        }
        return Lists.newArrayList();
    }
}

