/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.external.parser.internal;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.query.IntentDocumentQuery;
import org.eclipse.mylyn.docs.intent.collab.handlers.RepositoryObjectHandler;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.IntentCommand;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.SaveException;
import org.eclipse.mylyn.docs.intent.core.document.IntentSection;
import org.eclipse.mylyn.docs.intent.core.document.UnitInstruction;
import org.eclipse.mylyn.docs.intent.core.document.descriptionunit.DescriptionBloc;
import org.eclipse.mylyn.docs.intent.core.document.descriptionunit.DescriptionUnit;
import org.eclipse.mylyn.docs.intent.external.parser.contribution.IExternalParser;
import org.eclipse.mylyn.docs.intent.markup.markup.BlockContent;
import org.eclipse.mylyn.docs.intent.markup.markup.Paragraph;
import org.eclipse.mylyn.docs.intent.markup.markup.StructureElement;
import org.eclipse.mylyn.docs.intent.markup.markup.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalParserJob
extends Job {
    public static final String EXTERNAL_PARSE_JOB_NAME = "Parsing Intent Document with contibuted external parsers";
    private RepositoryObjectHandler repositoryObjectHandler;
    private Collection<IExternalParser> externalParserContributions;

    public ExternalParserJob(RepositoryObjectHandler repositoryObjectHandler, Collection<IExternalParser> externalParserContributions) {
        super(EXTERNAL_PARSE_JOB_NAME);
        this.repositoryObjectHandler = repositoryObjectHandler;
        this.externalParserContributions = externalParserContributions;
    }

    protected IStatus run(final IProgressMonitor monitor) {
        final RepositoryAdapter repositoryAdapter = this.repositoryObjectHandler.getRepositoryAdapter();
        if (repositoryAdapter != null) {
            repositoryAdapter.execute(new IntentCommand(){

                public void execute() {
                    ExternalParserJob.this.parse(monitor, repositoryAdapter);
                }
            });
        }
        IntentLogger.getInstance().log(IIntentLogger.LogType.LIFECYCLE, "[External Parsers] External parsers called");
        return Status.OK_STATUS;
    }

    private void parse(IProgressMonitor monitor, RepositoryAdapter repositoryAdapter) {
        try {
            repositoryAdapter.openSaveContext();
            for (IExternalParser externalParserContribution : this.externalParserContributions) {
                externalParserContribution.init();
            }
            IntentDocumentQuery query = new IntentDocumentQuery(repositoryAdapter);
            for (DescriptionUnit descriptionUnit : query.getAllDescriptionUnits()) {
                IntentSection intentSection = null;
                DescriptionUnit container = descriptionUnit;
                while (container != null && !(container instanceof IntentSection)) {
                    container = container.eContainer();
                }
                if (container instanceof IntentSection) {
                    intentSection = (IntentSection)container;
                }
                for (UnitInstruction instruction : descriptionUnit.getInstructions()) {
                    if (!(instruction instanceof DescriptionBloc)) continue;
                    DescriptionBloc bloc = (DescriptionBloc)instruction;
                    for (StructureElement blocElement : bloc.getDescriptionBloc().getContent()) {
                        if (!(blocElement instanceof Paragraph)) continue;
                        this.parseParagraph(monitor, repositoryAdapter, intentSection, (Paragraph)blocElement);
                    }
                }
            }
            for (IExternalParser externalParserContribution : this.externalParserContributions) {
                externalParserContribution.parsePostOperations(repositoryAdapter);
            }
            repositoryAdapter.save();
            repositoryAdapter.closeContext();
        }
        catch (ReadOnlyException e) {
            IntentLogger.getInstance().logError((Throwable)e);
        }
        catch (SaveException e) {
            IntentLogger.getInstance().logError((Throwable)e);
        }
    }

    private void parseParagraph(IProgressMonitor monitor, RepositoryAdapter repositoryAdapter, IntentSection intentSection, Paragraph paragraph) {
        StringBuffer text = new StringBuffer();
        boolean isVariable = false;
        for (BlockContent element : paragraph.getContent()) {
            if (!(element instanceof Text)) continue;
            String data = ((Text)element).getData();
            if ("#8249".equals(data)) {
                text.append("'");
                isVariable = true;
                continue;
            }
            if ("#8250".equals(data)) {
                text.append("'");
                isVariable = false;
                continue;
            }
            if (data.endsWith("$") || isVariable) {
                text.append(data);
                isVariable = false;
                continue;
            }
            text.append(String.valueOf(data) + "\n");
            isVariable = false;
        }
        for (IExternalParser externalParserContribution : this.externalParserContributions) {
            externalParserContribution.parse(intentSection, text.toString());
        }
    }
}

