/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.bridge.java.util;

import org.eclipse.mylyn.docs.intent.bridge.java.AbstractCapableElement;
import org.eclipse.mylyn.docs.intent.bridge.java.Classifier;
import org.eclipse.mylyn.docs.intent.bridge.java.ClassifierKind;
import org.eclipse.mylyn.docs.intent.bridge.java.Field;
import org.eclipse.mylyn.docs.intent.bridge.java.Javadoc;
import org.eclipse.mylyn.docs.intent.bridge.java.Method;
import org.eclipse.mylyn.docs.intent.bridge.java.VisibilityKind;
import org.eclipse.mylyn.docs.intent.bridge.java.VisibleElement;
import org.eclipse.mylyn.docs.intent.bridge.java.util.JavaSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBridgeSerializer
extends JavaSwitch<String> {
    private static final String NEW_LINE = "\n";
    private static final String SPACE = " ";

    @Override
    public String caseClassifier(Classifier object) {
        String result = this.caseAbstractCapableElement(object);
        result = ClassifierKind.ENUM == object.getKind() ? String.valueOf(result) + "enum " : (ClassifierKind.INTERFACE == object.getKind() ? String.valueOf(result) + "interface " : String.valueOf(result) + "class ");
        result = object.getName().contains(".") ? String.valueOf(result) + object.getName().substring(object.getName().lastIndexOf(".") + 1) : String.valueOf(result) + object.getName();
        if (object.getExtends() != null) {
            result = String.valueOf(result) + " extends " + object.getExtends();
        }
        if (!object.getImplements().isEmpty()) {
            result = String.valueOf(result) + " implements ";
            for (String implementedInterface : object.getImplements()) {
                result = String.valueOf(result) + implementedInterface + ",";
            }
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }

    @Override
    public String caseMethod(Method object) {
        String result = this.caseAbstractCapableElement(object);
        result = String.valueOf(result) + object.getReturnType() + SPACE + object.getName();
        return result;
    }

    @Override
    public String caseField(Field object) {
        return String.valueOf(this.caseVisibleElement(object)) + object.getType() + SPACE + object.getName();
    }

    @Override
    public String caseVisibleElement(VisibleElement object) {
        String result = "";
        if (object.getJavadoc() != null) {
            result = String.valueOf(result) + this.caseJavadoc(object.getJavadoc()) + NEW_LINE;
        }
        if (VisibilityKind.PUBLIC == object.getVisibility()) {
            result = String.valueOf(result) + "public ";
        } else if (VisibilityKind.PRIVATE == object.getVisibility()) {
            result = String.valueOf(result) + "private ";
        } else if (VisibilityKind.PROTECTED == object.getVisibility()) {
            result = String.valueOf(result) + "protected ";
        }
        if (object.isStatic()) {
            result = String.valueOf(result) + "static ";
        }
        if (object.isFinal()) {
            result = String.valueOf(result) + "final ";
        }
        return String.valueOf(result) + SPACE;
    }

    @Override
    public String caseAbstractCapableElement(AbstractCapableElement object) {
        String result = this.caseVisibleElement(object);
        if (object.isAbstract()) {
            result = String.valueOf(result) + "abstract ";
        }
        return result;
    }

    @Override
    public String caseJavadoc(Javadoc object) {
        String result = "";
        String[] stringArray = object.getContent().replace("\t", "").split(NEW_LINE);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String javadocLine = stringArray[n2];
            result = String.valueOf(result) + javadocLine.replace("* ", "").trim() + NEW_LINE;
            ++n2;
        }
        return result.trim();
    }
}

