/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.kafka.producer;

import io.quarkus.runtime.annotations.RegisterForReflection;
import io.vertx.kafka.client.serialization.BufferSerializer;
import java.util.Map;
import org.apache.kafka.common.serialization.StringSerializer;
import org.eclipse.hono.client.kafka.CommonKafkaClientOptions;
import org.eclipse.hono.client.kafka.producer.KafkaProducerConfigProperties;
import org.eclipse.hono.client.kafka.producer.KafkaProducerOptions;

@RegisterForReflection(targets={BufferSerializer.class})
public class MessagingKafkaProducerConfigProperties
extends KafkaProducerConfigProperties {
    public static final String DEFAULT_DELIVERY_TIMEOUT_MS = "2500";
    public static final String DEFAULT_REQUEST_TIMEOUT_MS = "750";
    public static final String DEFAULT_MAX_BLOCK_MS = "500";

    public MessagingKafkaProducerConfigProperties() {
        super(StringSerializer.class, BufferSerializer.class);
    }

    public MessagingKafkaProducerConfigProperties(CommonKafkaClientOptions commonOptions, KafkaProducerOptions options) {
        super(StringSerializer.class, BufferSerializer.class, commonOptions, options);
    }

    @Override
    protected final void adaptConfiguration(Map<String, String> config) {
        this.overrideConfigProperty(config, "enable.idempotence", "true");
        config.putIfAbsent("delivery.timeout.ms", DEFAULT_DELIVERY_TIMEOUT_MS);
        config.putIfAbsent("request.timeout.ms", DEFAULT_REQUEST_TIMEOUT_MS);
        config.putIfAbsent("max.block.ms", DEFAULT_MAX_BLOCK_MS);
    }
}

