/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command.amqp;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.proton.ProtonHelper;
import java.util.Map;
import java.util.Objects;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.amqp.AbstractServiceClient;
import org.eclipse.hono.client.amqp.DownstreamAmqpMessageFactory;
import org.eclipse.hono.client.amqp.GenericSenderLink;
import org.eclipse.hono.client.amqp.config.AddressHelper;
import org.eclipse.hono.client.amqp.connection.AmqpUtils;
import org.eclipse.hono.client.amqp.connection.HonoConnection;
import org.eclipse.hono.client.amqp.connection.SendMessageSampler;
import org.eclipse.hono.client.command.CommandResponse;
import org.eclipse.hono.client.command.CommandResponseSender;
import org.eclipse.hono.client.util.DownstreamMessageProperties;
import org.eclipse.hono.client.util.StatusCodeMapper;
import org.eclipse.hono.util.RegistrationAssertion;
import org.eclipse.hono.util.TenantObject;

public class ProtonBasedCommandResponseSender
extends AbstractServiceClient
implements CommandResponseSender {
    private final boolean jmsVendorPropsEnabled;

    public ProtonBasedCommandResponseSender(HonoConnection connection, SendMessageSampler.Factory samplerFactory, boolean jmsVendorPropsEnabled) {
        super(connection, samplerFactory);
        this.jmsVendorPropsEnabled = jmsVendorPropsEnabled;
    }

    private Future<GenericSenderLink> createSender(String tenantId, String replyId) {
        return this.connection.executeOnContext(result -> GenericSenderLink.create(this.connection, "command_response", tenantId, replyId, this.samplerFactory.create("command_response"), onRemoteClose -> {}).onComplete((Handler<AsyncResult<GenericSenderLink>>)result));
    }

    private Message createDownstreamMessage(CommandResponse response, TenantObject tenant, RegistrationAssertion device, Map<String, Object> properties) {
        Map<String, Object> props = new DownstreamMessageProperties("command_response", tenant.getDefaults().getMap(), device.getDefaults(), properties, tenant.getResourceLimits()).asMap();
        Message msg = ProtonHelper.message();
        DownstreamAmqpMessageFactory.addDefaults(msg, props);
        AmqpUtils.setCreationTime(msg);
        msg.setCorrelationId(response.getCorrelationId());
        AmqpUtils.setPayload(msg, response.getContentType(), response.getPayload());
        AmqpUtils.addStatus(msg, response.getStatus());
        msg.setAddress(AddressHelper.getTargetAddress("command_response", response.getTenantId(), response.getReplyToId(), null));
        AmqpUtils.addTenantId(msg, response.getTenantId());
        AmqpUtils.addDeviceId(msg, response.getDeviceId());
        if (this.jmsVendorPropsEnabled) {
            DownstreamAmqpMessageFactory.addJmsVendorProperties(msg);
        }
        return msg;
    }

    @Override
    public Future<Void> sendCommandResponse(TenantObject tenant, RegistrationAssertion device, CommandResponse response, SpanContext context) {
        Objects.requireNonNull(tenant);
        Objects.requireNonNull(device);
        Objects.requireNonNull(response);
        Future<GenericSenderLink> sender = this.createSender(response.getTenantId(), response.getReplyToId());
        return sender.recover(thr -> Future.failedFuture(StatusCodeMapper.toServerError(thr))).compose(s -> {
            Message msg = this.createDownstreamMessage(response, tenant, device, response.getAdditionalProperties());
            Span span = this.newChildSpan(context, "forward Command response");
            if (response.getMessagingType() != this.getMessagingType()) {
                span.log(String.format("using messaging type %s instead of type %s used for the original command", new Object[]{this.getMessagingType(), response.getMessagingType()}));
            }
            return s.sendAndWaitForOutcome(msg, span);
        }).onSuccess(delivery -> ((GenericSenderLink)sender.result()).close()).mapEmpty();
    }
}

