/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.ConfigValueConfigSource;
import io.smallrye.config.ConfigValueConfigSourceWrapper;
import io.smallrye.config.SmallRyeConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class SmallRyeConfigSources
implements ConfigSourceInterceptor {
    private static final long serialVersionUID = 7560201715403486552L;
    private final List<ConfigValueConfigSource> configSources;

    SmallRyeConfigSources(List<SmallRyeConfig.ConfigSourceWithPriority> configSourcesWithPriorities) {
        ArrayList<ConfigValueConfigSource> configSources = new ArrayList<ConfigValueConfigSource>();
        for (SmallRyeConfig.ConfigSourceWithPriority configSource : configSourcesWithPriorities) {
            configSources.add(ConfigValueConfigSourceWrapper.wrap(configSource.getSource()));
        }
        this.configSources = configSources;
    }

    @Override
    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        int configSourcesSize = this.configSources.size();
        for (int i = 0; i < configSourcesSize; ++i) {
            ConfigValueConfigSource configSource = this.configSources.get(i);
            ConfigValue configValue = configSource.getConfigValue(name);
            if (configValue == null) continue;
            return configValue.from().withConfigSourcePosition(i).build();
        }
        return null;
    }

    @Override
    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
        HashSet<String> names = new HashSet<String>();
        for (ConfigValueConfigSource configSource : this.configSources) {
            Set<String> propertyNames = configSource.getPropertyNames();
            if (propertyNames == null) continue;
            names.addAll(propertyNames);
        }
        return names.iterator();
    }

    @Override
    public Iterator<ConfigValue> iterateValues(ConfigSourceInterceptorContext context) {
        HashSet<ConfigValue> values = new HashSet<ConfigValue>();
        for (ConfigValueConfigSource configSource : this.configSources) {
            Map<String, ConfigValue> configValueProperties = configSource.getConfigValueProperties();
            if (configValueProperties == null) continue;
            values.addAll(configValueProperties.values());
        }
        return values.iterator();
    }
}

