/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.impl.IReconcileStrategy;
import org.eclipse.handly.model.impl.IWorkingCopyCallback;
import org.eclipse.handly.model.impl.IWorkingCopyInfo;

final class WorkingCopyInfo
implements IWorkingCopyInfo {
    private final IBuffer buffer;
    private final IContext context;
    private final IReconcileStrategy reconcileStrategy;
    final IWorkingCopyCallback callback;
    final InitTask initTask = new InitTask();
    volatile boolean created;
    int refCount;

    WorkingCopyInfo(IBuffer buffer, IContext context, IReconcileStrategy reconcileStrategy, IWorkingCopyCallback callback) {
        this.buffer = buffer;
        if (this.buffer == null) {
            throw new IllegalArgumentException();
        }
        this.context = context;
        if (this.context == null) {
            throw new IllegalArgumentException();
        }
        this.reconcileStrategy = reconcileStrategy;
        if (this.reconcileStrategy == null) {
            throw new IllegalArgumentException();
        }
        this.callback = callback;
        if (this.callback == null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public IBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public IContext getContext() {
        return this.context;
    }

    @Override
    public IReconcileStrategy getReconcileStrategy() {
        return this.reconcileStrategy;
    }

    void dispose() {
        if (this.refCount > 0) {
            throw new IllegalStateException();
        }
        if (this.refCount < 0) {
            return;
        }
        this.refCount = -1;
        if (this.initTask.isDone()) {
            this.callback.onDispose();
        }
    }

    boolean isDisposed() {
        return this.refCount < 0;
    }

    boolean isInitialized() {
        try {
            return this.initTask.wasSuccessful(0L, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    class InitTask {
        private IProgressMonitor monitor;
        private final FutureTask<?> futureTask = new FutureTask<Object>(new Callable<Object>(){

            @Override
            public Object call() throws CoreException {
                InitTask.this.run();
                return null;
            }
        });

        InitTask() {
        }

        void execute(IProgressMonitor monitor) throws CoreException {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            this.monitor = monitor;
            this.futureTask.run();
            this.monitor = null;
            try {
                this.futureTask.get();
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof CoreException) {
                    throw (CoreException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new AssertionError((Object)cause);
            }
        }

        boolean isDone() {
            return this.futureTask.isDone();
        }

        boolean wasSuccessful(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
            try {
                this.futureTask.get(timeout, unit);
                return true;
            }
            catch (ExecutionException e) {
                return false;
            }
        }

        private void run() throws CoreException {
            WorkingCopyInfo.this.callback.onInit(WorkingCopyInfo.this);
            WorkingCopyInfo.this.callback.reconcile(Contexts.of(Elements.FORCE_RECONCILING, Boolean.valueOf(true)), this.monitor);
            if (!WorkingCopyInfo.this.created) {
                throw new AssertionError((Object)("Working copy creation was not completed. Ill-behaved " + WorkingCopyInfo.this.callback.getClass().getName() + "#reconcile?"));
            }
        }
    }
}

