/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import org.eclipse.handly.model.IElementChangeListener;

public final class ElementChangeListenerList {
    private static final Entry[] EMPTY_ARRAY = new Entry[0];
    private volatile Entry[] entries = EMPTY_ARRAY;

    public synchronized void add(IElementChangeListener listener, int eventMask) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (eventMask == 0) {
            this.remove(listener);
            return;
        }
        Entry entry = new Entry(listener, eventMask);
        int oldSize = this.entries.length;
        int i = 0;
        while (i < oldSize) {
            if (this.entries[i].listener == listener) {
                this.entries[i] = entry;
                return;
            }
            ++i;
        }
        Entry[] newEntries = new Entry[oldSize + 1];
        System.arraycopy(this.entries, 0, newEntries, 0, oldSize);
        newEntries[oldSize] = entry;
        this.entries = newEntries;
    }

    public synchronized void remove(IElementChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.entries.length;
        int i = 0;
        while (i < oldSize) {
            if (this.entries[i].listener == listener) {
                if (oldSize == 1) {
                    this.entries = EMPTY_ARRAY;
                } else {
                    Entry[] newEntries = new Entry[oldSize - 1];
                    System.arraycopy(this.entries, 0, newEntries, 0, i);
                    System.arraycopy(this.entries, i + 1, newEntries, i, oldSize - i - 1);
                    this.entries = newEntries;
                }
                return;
            }
            ++i;
        }
    }

    public Entry[] getEntries() {
        return this.entries;
    }

    public boolean isEmpty() {
        return this.entries.length == 0;
    }

    public synchronized void clear() {
        this.entries = EMPTY_ARRAY;
    }

    public static class Entry {
        private final IElementChangeListener listener;
        private final int eventMask;

        private Entry(IElementChangeListener listener, int eventMask) {
            this.listener = listener;
            this.eventMask = eventMask;
        }

        public IElementChangeListener getListener() {
            return this.listener;
        }

        public int getEventMask() {
            return this.eventMask;
        }
    }
}

