/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.search;

import java.text.MessageFormat;
import org.eclipse.handly.ui.DefaultEditorUtility;
import org.eclipse.handly.ui.search.ISearchContentProvider;
import org.eclipse.handly.ui.search.Messages;
import org.eclipse.handly.ui.search.OpenSearchPreferencesAction;
import org.eclipse.handly.ui.search.SearchEditorOpener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchFilter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPageSite;

public abstract class AbstractSearchResultPage
extends AbstractTextSearchViewPage {
    private static final String NULL = "null";
    private static final int DEFAULT_ELEMENT_LIMIT = 1000;
    private static final String KEY_ELEMENT_LIMIT = "org.eclipse.handly.search.resultpage.limit";
    private SearchEditorOpener editorOpener;

    public AbstractSearchResultPage(int supportedLayouts) {
        super(supportedLayouts);
        this.setElementLimit(1000);
    }

    public AbstractSearchResultPage() {
        this(3);
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        this.editorOpener = this.createEditorOpener();
        IMenuManager menuManager = pageSite.getActionBars().getMenuManager();
        IAction searchPreferencesAction = this.createSearchPreferencesAction();
        if (searchPreferencesAction != null) {
            menuManager.appendToGroup("group.properties", searchPreferencesAction);
        }
    }

    public void restoreState(IMemento memento) {
        String value;
        super.restoreState(memento);
        if (memento != null && (value = memento.getString(KEY_ELEMENT_LIMIT)) != null) {
            if (NULL.equals(value)) {
                this.setElementLimit(null);
            } else {
                int limit = 0;
                try {
                    limit = Integer.valueOf(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (limit > 0 || limit == -1) {
                    this.setElementLimit(limit);
                }
            }
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString(KEY_ELEMENT_LIMIT, String.valueOf(this.getElementLimit()));
    }

    public String getLabel() {
        MatchFilter[] filters;
        String label = super.getLabel();
        AbstractTextSearchResult result = this.getInput();
        if (result != null && (filters = result.getActiveMatchFilters()) != null && filters.length > 0) {
            if (NewSearchUI.isQueryRunning((ISearchQuery)result.getQuery())) {
                return MessageFormat.format(Messages.AbstractSearchResultPage_Label__0__filtered, label);
            }
            return MessageFormat.format(Messages.AbstractSearchResultPage_Label__0__filtered_with_count__1, label, result.getMatchCount() - this.getDisplayedMatchCount());
        }
        return label;
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        Object element = match.getElement();
        if (currentOffset >= 0 && currentLength >= 0) {
            IEditorPart editor = this.editorOpener.open(element, activate, false);
            if (editor != null) {
                this.editorOpener.getEditorUtility().revealTextRange(editor, currentOffset, currentLength, null);
            }
        } else {
            this.editorOpener.open(element, activate, true);
        }
    }

    protected void elementsChanged(Object[] objects) {
        IStructuredContentProvider contentProvider = this.getContentProvider();
        if (contentProvider instanceof ISearchContentProvider) {
            ((ISearchContentProvider)contentProvider).elementsChanged(objects);
        }
    }

    protected void clear() {
        IStructuredContentProvider contentProvider = this.getContentProvider();
        if (contentProvider instanceof ISearchContentProvider) {
            ((ISearchContentProvider)contentProvider).clear();
        }
    }

    protected StructuredViewer getViewer() {
        return super.getViewer();
    }

    protected final IStructuredContentProvider getContentProvider() {
        StructuredViewer viewer = this.getViewer();
        if (viewer == null) {
            return null;
        }
        return (IStructuredContentProvider)viewer.getContentProvider();
    }

    protected final SearchEditorOpener getEditorOpener() {
        return this.editorOpener;
    }

    protected SearchEditorOpener createEditorOpener() {
        return new SearchEditorOpener(this.getSite().getPage(), DefaultEditorUtility.INSTANCE);
    }

    protected IAction createSearchPreferencesAction() {
        return new OpenSearchPreferencesAction();
    }

    protected int getDisplayedMatchCount() {
        StructuredViewer viewer = this.getViewer();
        if (viewer == null) {
            return 0;
        }
        IStructuredContentProvider contentProvider = (IStructuredContentProvider)viewer.getContentProvider();
        if (contentProvider == null) {
            return 0;
        }
        ITreeContentProvider treeContentProvider = null;
        if (contentProvider instanceof ITreeContentProvider) {
            treeContentProvider = (ITreeContentProvider)contentProvider;
        }
        Object[] elements = contentProvider.getElements(viewer.getInput());
        int count = 0;
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            count = treeContentProvider != null ? (count += this.getDisplayedMatchCountWithChildren(element, treeContentProvider)) : (count += this.getDisplayedMatchCount(element));
            ++n2;
        }
        return count;
    }

    private int getDisplayedMatchCountWithChildren(Object element, ITreeContentProvider treeContentProvider) {
        Object[] children;
        int count = this.getDisplayedMatchCount(element);
        Object[] objectArray = children = treeContentProvider.getChildren(element);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            count += this.getDisplayedMatchCountWithChildren(child, treeContentProvider);
            ++n2;
        }
        return count;
    }
}

