/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.utils;

import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.glsp.ide.editor.di.IdeActionDispatcher;
import org.eclipse.glsp.ide.editor.utils.UIUtil;
import org.eclipse.glsp.server.actions.MessageAction;
import org.eclipse.glsp.server.types.Severity;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;

public final class IdeMessageUtil {
    private IdeMessageUtil() {
    }

    public static void log(MessageAction action, String clientId) {
        Optional<IStatus> status = IdeMessageUtil.toStatus(action);
        if (status.isEmpty()) {
            return;
        }
        Platform.getLog(IdeMessageUtil.class).log(status.get());
        if (status.get().getSeverity() >= 4) {
            UIUtil.asyncExec(() -> UIUtil.findShell(clientId).ifPresent(shell -> {
                int n = ErrorDialog.openError((Shell)shell, (String)"GLSP Server Error", (String)action.getMessage(), (IStatus)((IStatus)status.get()));
            }));
        }
    }

    public static Optional<IStatus> toStatus(MessageAction action) {
        int severity = IdeMessageUtil.toSeverity(action.getSeverity());
        Object message = action.getMessage();
        if (message == null || ((String)message).isEmpty()) {
            message = action.getDetails().orElse("");
        } else if (action.getDetails() != null && !action.getDetails().isEmpty()) {
            message = (String)message + "\n" + String.valueOf(action.getDetails());
        }
        if (message != null && !((String)message).isEmpty()) {
            return Optional.of(new Status(severity, IdeActionDispatcher.class, (String)message));
        }
        return Optional.empty();
    }

    public static int toSeverity(String glspSeverity) {
        switch (Severity.valueOf((String)glspSeverity)) {
            case NONE: {
                return 0;
            }
            case OK: {
                return 0;
            }
            case INFO: {
                return 1;
            }
            case WARNING: {
                return 2;
            }
            case ERROR: {
                return 4;
            }
            case FATAL: {
                return 8;
            }
        }
        return 0;
    }
}

