/*******************************************************************************
 * Copyright (c) 2011 protos software gmbh (http://www.protos.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * CONTRIBUTORS:
 * 		Henrik Rentz-Reichert (initial contribution)
 * 		Thomas Schuetz (changed for C code generator)
 * 
 *******************************************************************************/

package org.eclipse.etrice.generator.c.gen

import com.google.inject.Inject
import com.google.inject.Singleton
import org.eclipse.etrice.core.genmodel.etricegen.Root
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance
import org.eclipse.etrice.generator.generic.RoomExtensions
import org.eclipse.etrice.core.etmap.util.ETMapUtil
import org.eclipse.etrice.generator.c.Main
import org.eclipse.etrice.generator.c.setup.GeneratorOptionsHelper
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO

import static org.eclipse.etrice.generator.base.AbstractGeneratorOptions.MAIN_NAME
import org.eclipse.etrice.generator.base.logging.ILogger

@Singleton
class NodeRunnerGen {

	@Inject extension IGeneratorFileIO fileIO
	@Inject extension CExtensions
	@Inject extension RoomExtensions
	@Inject protected extension GeneratorOptionsHelper
	@Inject ILogger logger

	def doGenerate(Root root) {
		var first = true
		for (nr : ETMapUtil::getNodeRefs()) {
			for (instpath : ETMapUtil::getSubSystemInstancePaths(nr)) {
				val ssi = root.getInstance(instpath) as SubSystemInstance
				if (ssi !== null) {
					val clsname = nr.name + "_" + ssi.name
					val path = ssi.subSystemClass.getPath
					val file = clsname + "_Runner" + sourceExtension
					fileIO.generateFile("generating Node runner file", path + file, root.generateSourceFile(ssi, first))
					first = false
				}
			}
		}
	}

	def generateSourceFile(Root root, SubSystemInstance ssi, boolean first) {
		val nr = ETMapUtil::getNodeRef(ssi)
		val clsname = nr.name + "_" + ssi.name
		val mainName = {
			if(Main.getSettings.mainMethodName != MAIN_NAME.defaultValue) {
				logger.logWarning('''The MAIN_NAME.name option is deprecated, use ET_MAIN_FUNCTION_NAME in etRuntimeConfig.h instead''')
				Main.getSettings.mainMethodName
			} else {
				'ET_MAIN_FUNCTION_NAME'
			}
		}
		'''
			/**
			 * @author generated by eTrice
			 *
			 * this class contains the main function running Node nr.name with SubSystem ssi.name
			 * it instantiates Node nr.name with SubSystem ssi.name and starts and ends the lifecycle
			 */
			
			#include <string.h>
			
			#include "nr.getCHeaderFileName(ssi)"
			
			#include "debugging/etLogger.h"
			#include "debugging/etMSCLogger.h"
			#include "debugging/etDataLogger.h"
			
			#include "osal/etPlatformLifecycle.h"
			
			#ifndef ET_MAIN_FUNCTION_NAME
				#define ET_MAIN_FUNCTION_NAME 	main
			#endif
			
			/**
			 * eTrice main function
			 * creates components and starts and stops the lifecycle
			 */
			
			int mainName (
			#ifdef ET_DO_NOT_USE_ARGC_ARGV
				void
			#else
				int argc, char** argv
			#endif
			) {
			
			#ifdef ET_DO_NOT_USE_ARGC_ARGV
				int argc = 0;
				char** argv = NULL;
			#endif		
			
				etUserEntry(); /* platform specific */
				
				etLogger_logInfo("***   T H E   B E G I N   ***");
				ET_MSC_LOGGER_OPEN("main");
				ET_DATA_LOGGER_OPEN("main");
			
				/* startup sequence  of lifecycle */
				clsname_init(); 		/* lifecycle init */
				clsname_start(); 	/* lifecycle start */
			
				etUserPreRun(); /* platform specific */
			
				/* run Scheduler */
				int returnCode = clsname_run(argc, argv);
			
				etUserPostRun(); /* platform specific */
			
				/* shutdown sequence of lifecycle */
				clsname_stop(); 		/* lifecycle stop */
				clsname_destroy(); 	/* lifecycle destroy */
			
				ET_MSC_LOGGER_CLOSE
				ET_DATA_LOGGER_CLOSE
				etLogger_logInfo("***   T H E   E N D   ***");
			
				etUserExit(); /* platform specific */
			
				return returnCode;
			}
			
		'''
	}
}
