/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.etrice.core.common.base.Import;
import org.eclipse.etrice.core.common.ui.labeling.BaseLabelProvider;
import org.eclipse.etrice.core.config.ActorClassConfig;
import org.eclipse.etrice.core.config.ActorInstanceConfig;
import org.eclipse.etrice.core.config.AttrClassConfig;
import org.eclipse.etrice.core.config.AttrInstanceConfig;
import org.eclipse.etrice.core.config.ConfigModel;
import org.eclipse.etrice.core.config.DynamicConfig;
import org.eclipse.etrice.core.config.PortClassConfig;
import org.eclipse.etrice.core.config.PortInstanceConfig;
import org.eclipse.etrice.core.config.ProtocolClassConfig;
import org.eclipse.etrice.core.config.RefPath;
import org.eclipse.etrice.core.config.SubSystemConfig;
import org.eclipse.etrice.core.config.util.ConfigUtil;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.SubSystemClass;

public class ConfigLabelProvider
extends BaseLabelProvider {
    @Inject
    private ConfigUtil configUtil;

    @Inject
    public ConfigLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    String image(ConfigModel mdl) {
        return "Config_ConfigModel.png";
    }

    public String image(Import mdl) {
        return "Config_Import.png";
    }

    String image(ActorClassConfig mdl) {
        return "Config_ActorClassConfig.png";
    }

    String image(ActorInstanceConfig mdl) {
        return "Config_ActorInstanceConfig.png";
    }

    String image(AttrClassConfig mdl) {
        return "Config_AttrClassConfig.png";
    }

    String image(AttrInstanceConfig mdl) {
        return "Config_AttrInstanceConfig.png";
    }

    String image(DynamicConfig mdl) {
        return "Config_DynamicConfig.png";
    }

    String image(PortClassConfig mdl) {
        return "Config_PortClassConfig.png";
    }

    String image(PortInstanceConfig mdl) {
        return "Config_PortInstanceConfig.png";
    }

    String image(ProtocolClassConfig mdl) {
        return "Config_ProtocolClassConfig.png";
    }

    String image(SubSystemConfig mdl) {
        return "Config_SubSystemConfig.png";
    }

    String text(ConfigModel mdl) {
        return "ConfigModel " + mdl.getName();
    }

    String text(ActorClassConfig mdl) {
        return "Config of ActorClass " + mdl.getActor().getName();
    }

    String text(ActorInstanceConfig mdl) {
        SubSystemClass root = mdl.getSubSystem().getType();
        RefPath path = mdl.getPath();
        ActorRef ref = this.configUtil.getLastActorRef((ActorContainerClass)root, path);
        return "Config of ActorInstance " + this.configUtil.getPath(mdl) + " (" + ref.getType().getName() + ")";
    }

    String text(AttrClassConfig mdl) {
        return "Config of Attribute " + mdl.getAttribute().getName();
    }

    String text(AttrInstanceConfig mdl) {
        return "Config of Attribute " + mdl.getAttribute().getName();
    }

    String text(DynamicConfig mdl) {
        return "Dynamic Config";
    }

    String text(PortClassConfig mdl) {
        ProtocolClassConfig pcc = (ProtocolClassConfig)mdl.eContainer();
        String kind = mdl == pcc.getRegular() ? "regular" : "conjugated";
        return "Config of " + kind + " PortClass " + pcc.getProtocol().getName();
    }

    String text(PortInstanceConfig mdl) {
        return "Config of Port Instance " + mdl.getItem().getName();
    }

    String text(ProtocolClassConfig mdl) {
        return "Config of Protocol Class " + mdl.getProtocol().getName();
    }

    String text(SubSystemConfig mdl) {
        return "Config of SubSystem " + mdl.getSubSystem().getName();
    }
}

