/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.typecheck.symbols;

import org.eclipse.escet.chi.metamodel.chi.Declaration;
import org.eclipse.escet.chi.metamodel.chi.EnumDeclaration;
import org.eclipse.escet.chi.metamodel.chi.Type;
import org.eclipse.escet.chi.metamodel.chi.TypeDeclaration;
import org.eclipse.escet.chi.metamodel.java.ChiConstructors;
import org.eclipse.escet.chi.typecheck.CheckContext;
import org.eclipse.escet.chi.typecheck.CheckType;
import org.eclipse.escet.chi.typecheck.Message;
import org.eclipse.escet.chi.typecheck.symbols.SymbolEntry;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class TypeSymbolEntry
extends SymbolEntry {
    private Declaration origType;
    private Declaration newType;

    public TypeSymbolEntry(Declaration type, CheckContext ctxt) {
        super(true, ctxt);
        this.origType = type;
        if (this.origType instanceof EnumDeclaration) {
            this.newType = type;
            this.checkState = SymbolEntry.TypeCheckState.FULL_CHECK_DONE;
        } else {
            this.newType = null;
        }
    }

    @Override
    public String getName() {
        return this.origType.getName();
    }

    @Override
    public Position getPosition() {
        return this.origType.getPosition();
    }

    @Override
    public void typeCheckForUse() {
        if (this.checkState == SymbolEntry.TypeCheckState.NOT_STARTED) {
            this.checkState = SymbolEntry.TypeCheckState.USE_CHECK_DONE;
        }
        this.fullTypeCheck();
    }

    @Override
    public void fullTypeCheck() {
        if (this.checkState == SymbolEntry.TypeCheckState.FULL_CHECK_DONE) {
            return;
        }
        if (this.origType instanceof TypeDeclaration) {
            this.declareBusy();
            try {
                TypeDeclaration otd = (TypeDeclaration)this.origType;
                this.newType = TypeSymbolEntry.transTypeDeclaration(otd, this.ctxt);
            }
            finally {
                this.declareFinished();
            }
            return;
        }
        if (this.origType instanceof EnumDeclaration) {
            this.checkState = SymbolEntry.TypeCheckState.FULL_CHECK_DONE;
            return;
        }
        Assert.fail((Object)"Unknown type of symbol");
    }

    private static Declaration transTypeDeclaration(TypeDeclaration decl, CheckContext ctxt) {
        Type newType = CheckType.transNonvoidType(decl.getType(), ctxt);
        return ChiConstructors.newTypeDeclaration((String)decl.getName(), (Position)PositionUtils.copyPosition((PositionObject)decl), (Type)newType);
    }

    @Override
    public void checkUsage(CheckContext ctxt) {
        if (this.isUsed) {
            return;
        }
        ctxt.addWarning(Message.UNUSED_TYPE, this.getPosition(), this.getName());
    }

    public TypeDeclaration getTypeDeclaration() {
        Assert.check((this.checkState == SymbolEntry.TypeCheckState.FULL_CHECK_DONE ? 1 : 0) != 0);
        if (!(this.origType instanceof TypeDeclaration)) {
            return null;
        }
        if (this.newType == null) {
            throw new SemanticException();
        }
        return (TypeDeclaration)this.newType;
    }

    public EnumDeclaration getEnumTypeDeclaration() {
        Assert.check((this.checkState == SymbolEntry.TypeCheckState.FULL_CHECK_DONE ? 1 : 0) != 0);
        if (!(this.origType instanceof EnumDeclaration)) {
            return null;
        }
        Assert.notNull((Object)this.newType);
        return (EnumDeclaration)this.newType;
    }
}

