/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.jdi.internal.JDIMessages;
import org.eclipse.jdi.internal.MethodImpl;
import org.eclipse.jdi.internal.MirrorImpl;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.osgi.util.NLS;

public class LocationImpl
extends MirrorImpl
implements Location {
    public static final int LINE_NR_NOT_AVAILABLE = -1;
    MethodImpl fMethod;
    long fIndex;

    public LocationImpl(VirtualMachineImpl vmImpl, MethodImpl method, long index) {
        super("Location", vmImpl);
        this.fMethod = method;
        this.fIndex = index;
    }

    @Override
    public long codeIndex() {
        return this.fIndex;
    }

    @Override
    public ReferenceType declaringType() {
        return this.fMethod.declaringType();
    }

    @Override
    public int hashCode() {
        return this.fMethod.hashCode() + (int)this.fIndex;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            LocationImpl loc = (LocationImpl)object;
            return this.fMethod.equals(loc.fMethod) && this.fIndex == loc.fIndex;
        }
        return false;
    }

    @Override
    public int compareTo(Location locatable) {
        if (locatable == null || !locatable.getClass().equals(this.getClass())) {
            throw new ClassCastException(JDIMessages.LocationImpl_Can__t_compare_location_to_given_object_1);
        }
        LocationImpl location2 = (LocationImpl)locatable;
        if (!this.method().equals(location2.method())) {
            return this.method().compareTo(location2.method());
        }
        if (this.codeIndex() < 0L || location2.codeIndex() < 0L) {
            throw new InternalError(JDIMessages.LocationImpl_Code_indexes_are_assumed_to_be_always_positive_2);
        }
        if (this.codeIndex() < location2.codeIndex()) {
            return -1;
        }
        if (this.codeIndex() > location2.codeIndex()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int lineNumber() {
        return this.lineNumber(this.virtualMachine().getDefaultStratum());
    }

    @Override
    public Method method() {
        return this.fMethod;
    }

    @Override
    public String sourceName() throws AbsentInformationException {
        return this.sourceName(this.virtualMachine().getDefaultStratum());
    }

    @Override
    public String toString() {
        try {
            return NLS.bind((String)JDIMessages.LocationImpl_sourcename___0___line___1__3, (Object[])new String[]{this.sourceName(), Integer.toString(this.lineNumber()), this.method().toString()});
        }
        catch (Exception e) {
            return this.fDescription;
        }
    }

    public void write(MirrorImpl target, DataOutputStream out) throws IOException {
        this.fMethod.writeWithReferenceTypeWithTag(target, out);
        target.writeLong(this.fIndex, "index", out);
    }

    public static LocationImpl read(MirrorImpl target, DataInputStream in) throws IOException {
        VirtualMachineImpl vmImpl = target.virtualMachineImpl();
        MethodImpl method = MethodImpl.readWithReferenceTypeWithTag(target, in);
        long index = target.readLong("index", in);
        if (method == null) {
            return null;
        }
        return new LocationImpl(vmImpl, method, index);
    }

    @Override
    public int lineNumber(String stratum) {
        return this.fMethod.referenceTypeImpl().lineNumber(this.fIndex, this.fMethod, stratum);
    }

    @Override
    public String sourceName(String stratum) throws AbsentInformationException {
        return this.fMethod.referenceTypeImpl().sourceName(this.fIndex, this.fMethod, stratum);
    }

    @Override
    public String sourcePath(String stratum) throws AbsentInformationException {
        return this.fMethod.referenceTypeImpl().sourcePath(this.fIndex, this.fMethod, stratum);
    }

    @Override
    public String sourcePath() throws AbsentInformationException {
        return this.sourcePath(this.virtualMachine().getDefaultStratum());
    }
}

