/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime.data.random;

import org.eclipse.escet.chi.runtime.ChiCoordinator;
import org.eclipse.escet.chi.runtime.ChiSimulatorException;
import org.eclipse.escet.chi.runtime.data.random.BernoulliDistribution;
import org.eclipse.escet.chi.runtime.data.random.IntegerDistribution;
import org.eclipse.escet.chi.runtime.data.random.RandomGenerator;
import org.eclipse.escet.common.java.Strings;

public class BinomialDistribution
extends IntegerDistribution {
    private RandomGenerator randGen;
    private int numberExperiments;
    private double chance;

    public BinomialDistribution(ChiCoordinator chiCoordinator, int numberExperiments, double chance) {
        super(chiCoordinator);
        if (numberExperiments <= 0) {
            String msg = Strings.fmt((String)"The Binomial distribution expects a non-zero positive number of experiments, found value %d instead.", (Object[])new Object[]{numberExperiments});
            throw new ChiSimulatorException(msg);
        }
        if (chance < 0.0 || chance > 1.0) {
            String msg = Strings.fmt((String)"The Binomial distribution expects a chance parameter in the range [0.0..1.0], found chance %s instead.", (Object[])new Object[]{chance});
            throw new ChiSimulatorException(msg);
        }
        this.numberExperiments = numberExperiments;
        this.chance = chance;
        this.randGen = chiCoordinator.getFreshGenerator();
    }

    @Override
    public int sample() {
        return BinomialDistribution.drawBinomial(this.randGen, this.numberExperiments, this.chance);
    }

    public static int drawBinomial(RandomGenerator randGen, int numberExperiments, double chance) {
        int count = 0;
        int experiment = 0;
        while (experiment < numberExperiments) {
            if (BernoulliDistribution.drawBernoulli(randGen, chance)) {
                ++count;
            }
            ++experiment;
        }
        return count;
    }
}

