/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifLocationUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class AutomatonSimpleCodeGenerator {
    private AutomatonSimpleCodeGenerator() {
    }

    public static void gencodeAutomaton(Automaton aut, CifCompilerContext ctxt) {
        String className = ctxt.getAutClassName(aut);
        JavaCodeFile file = ctxt.addCodeFile(className);
        String absName = CifTextUtils.getAbsName((PositionObject)aut);
        CodeBox h = file.header;
        h.add("/** Automaton \"%s\". */", new Object[]{absName});
        h.add("public final class %s extends RuntimeSimpleAutomaton<State> {", new Object[]{className});
        CodeBox c = file.body;
        String absClassName = CifCompilerContext.getClassName(className);
        c.add("public %s() {", new Object[]{className});
        c.indent();
        c.add("super(getMonitorData(), Spec.MONITOR_EDGE, %s, SPEC.resourceClassLoader);", new Object[]{Strings.stringToJava((String)absClassName)});
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public String getName() {");
        c.indent();
        c.add("return \"%s\";", new Object[]{absName});
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public String getCurLocName(State state) {");
        c.indent();
        c.add("return getLocName(state.%s.%s);", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut)});
        c.dedent();
        c.add("}");
        Set<Event> monitors = ctxt.getMonitors(aut);
        c.add();
        c.add("public static boolean[] getMonitorData() {");
        c.indent();
        int runtimeEventCount = ctxt.getRuntimeEventCount();
        List monitorValues = Lists.listc((int)runtimeEventCount);
        int i = 0;
        while (i < runtimeEventCount) {
            monitorValues.add(false);
            ++i;
        }
        for (Event monitorEvent : monitors) {
            monitorValues.set(ctxt.getRuntimeEventIdx(monitorEvent), true);
        }
        c.add("return new boolean[] {%s};", new Object[]{monitorValues.stream().map(String::valueOf).collect(Collectors.joining(", "))});
        c.dedent();
        c.add("}");
        List<Event> events = ctxt.getEvents();
        Set<Event> alphabet = ctxt.getAlphabet(aut);
        for (Event event : events) {
            if (!alphabet.contains(event)) continue;
            List<Automaton> auts = ctxt.getSyncAuts(event);
            int autIdx = auts.indexOf(aut);
            int runtimeEventIdx = ctxt.getRuntimeEventIdx(event);
            c.add();
            c.add("public static boolean fillSyncData_%d(State state) {", new Object[]{runtimeEventIdx});
            c.indent();
            c.add("List<RuntimeEdge<State>> rslt = SPEC.syncData.get(%d).get(%d);", new Object[]{runtimeEventIdx, autIdx});
            c.add("rslt.clear();");
            c.add("RuntimeSimpleAutomaton<State> aut = (RuntimeSimpleAutomaton<State>)SPEC.automata.get(%d);", new Object[]{ctxt.getAutomata().indexOf(aut)});
            c.add("fillSyncData(aut, %d, rslt, state.%s.%s);", new Object[]{runtimeEventIdx, ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut)});
            c.add("return !rslt.isEmpty();");
            c.dedent();
            c.add("}");
        }
        c.add();
        c.add("public static void fillTauData(State state) {");
        c.indent();
        c.add("// Simple automaton: no tau.");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("protected void updateLocPointerValue(State target, int value) {");
        c.indent();
        c.add("target.%s = target.%s.copy();", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getAutSubStateFieldName(aut)});
        c.add("target.%s.%s = value;", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut)});
        c.dedent();
        c.add("}");
        AutomatonSimpleCodeGenerator.gencodeLocNamesResource(aut, ctxt);
        AutomatonSimpleCodeGenerator.gencodeEdgeDataResource(aut, ctxt);
    }

    private static void gencodeLocNamesResource(Automaton aut, CifCompilerContext ctxt) {
        String className = ctxt.getAutClassName(aut);
        String absClassName = CifCompilerContext.getClassName(className);
        String resPath = CifCompilerContext.getLocNamesResourcePath(absClassName);
        ByteArrayOutputStream stream = ctxt.addResourceFile(resPath);
        DataOutputStream data = new DataOutputStream(stream);
        EList locs = aut.getLocations();
        try {
            data.writeInt(locs.size());
            int i = 0;
            while (i < locs.size()) {
                Location loc = (Location)locs.get(i);
                String name = CifLocationUtils.getName((Location)loc);
                data.writeInt(name.length());
                data.writeChars(name);
                ++i;
            }
            data.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void gencodeEdgeDataResource(Automaton aut, CifCompilerContext ctxt) {
        EList locs = aut.getLocations();
        int[][][] edgesData = new int[locs.size()][][];
        int i = 0;
        while (i < locs.size()) {
            int[][] locData;
            Location loc = (Location)locs.get(i);
            EList edges = loc.getEdges();
            int edgeCount = 0;
            for (Edge edge : edges) {
                edgeCount += edge.getEvents().size();
            }
            edgesData[i] = locData = new int[edgeCount][2];
            int edgeIdx = 0;
            for (Edge edge : edges) {
                for (EdgeEvent edgeEvent : edge.getEvents()) {
                    Event evt = ((EventExpression)edgeEvent.getEvent()).getEvent();
                    Location target = edge.getTarget();
                    int targetIdx = target == null ? i : locs.indexOf(target);
                    locData[edgeIdx][0] = ctxt.getRuntimeEventIdx(evt);
                    locData[edgeIdx][1] = targetIdx;
                    ++edgeIdx;
                }
            }
            ++i;
        }
        String className = ctxt.getAutClassName(aut);
        String absClassName = CifCompilerContext.getClassName(className);
        String resPath = CifCompilerContext.getEdgeDataResourcePath(absClassName);
        ByteArrayOutputStream stream = ctxt.addResourceFile(resPath);
        DataOutputStream data = new DataOutputStream(stream);
        try {
            data.writeInt(edgesData.length);
            int i2 = 0;
            while (i2 < edgesData.length) {
                int[][] locData = edgesData[i2];
                data.writeInt(locData.length);
                int j = 0;
                while (j < locData.length) {
                    int[] edgeData = locData[j];
                    data.writeInt(edgeData[0]);
                    data.writeInt(edgeData[1]);
                    ++j;
                }
                ++i2;
            }
            data.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

