/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import org.sat4j.core.ASolverFactory;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.core.LearnedConstraintsDeletionStrategy;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.core.VarActivityListener;
import org.sat4j.minisat.learning.ClauseOnlyLearning;
import org.sat4j.minisat.learning.MiniSATLearning;
import org.sat4j.minisat.learning.NoLearningButHeuristics;
import org.sat4j.minisat.orders.PhaseInLastLearnedClauseSelectionStrategy;
import org.sat4j.minisat.orders.RSATPhaseSelectionStrategy;
import org.sat4j.minisat.orders.UserFixedPhaseSelectionStrategy;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.minisat.restarts.ArminRestarts;
import org.sat4j.minisat.restarts.Glucose21Restarts;
import org.sat4j.minisat.restarts.LubyRestarts;
import org.sat4j.minisat.restarts.MiniSATRestarts;
import org.sat4j.minisat.restarts.NoRestarts;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.OPBStringSolver;
import org.sat4j.pb.OptToPBSATAdapter;
import org.sat4j.pb.PBTimeoutIsolator;
import org.sat4j.pb.PseudoOptDecorator;
import org.sat4j.pb.constraints.AbstractPBDataStructureFactory;
import org.sat4j.pb.constraints.CompetMinHTmixedClauseCardConstrDataStructureFactory;
import org.sat4j.pb.constraints.CompetResolutionMinPBLongMixedWLClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.CompetResolutionPBLongMixedHTClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.CompetResolutionPBLongMixedWLClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.CompetResolutionPBMixedHTClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.CompetResolutionPBMixedWLClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.PBLongMaxClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.PBLongMinClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.PBMaxClauseAtLeastConstrDataStructure;
import org.sat4j.pb.constraints.PBMaxClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.PBMaxDataStructure;
import org.sat4j.pb.constraints.PBMinClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.PBMinDataStructure;
import org.sat4j.pb.constraints.PuebloPBMinClauseAtLeastConstrDataStructure;
import org.sat4j.pb.constraints.PuebloPBMinClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.PuebloPBMinDataStructure;
import org.sat4j.pb.constraints.pb.ConflictMapDivideByPivot;
import org.sat4j.pb.constraints.pb.SkipStrategy;
import org.sat4j.pb.core.PBDataStructureFactory;
import org.sat4j.pb.core.PBSolver;
import org.sat4j.pb.core.PBSolverCP;
import org.sat4j.pb.core.PBSolverCPCardLearning;
import org.sat4j.pb.core.PBSolverCPClauseLearning;
import org.sat4j.pb.core.PBSolverCPLong;
import org.sat4j.pb.core.PBSolverCPLongDivideBy2;
import org.sat4j.pb.core.PBSolverCPLongDivideByGCD;
import org.sat4j.pb.core.PBSolverCPLongReduceToCard;
import org.sat4j.pb.core.PBSolverCPLongRounding;
import org.sat4j.pb.core.PBSolverCPReduceByGCD;
import org.sat4j.pb.core.PBSolverCPReduceByPowersOf2;
import org.sat4j.pb.core.PBSolverCautious;
import org.sat4j.pb.core.PBSolverClause;
import org.sat4j.pb.core.PBSolverResCP;
import org.sat4j.pb.core.PBSolverResolution;
import org.sat4j.pb.core.PBSolverWithImpliedClause;
import org.sat4j.pb.lcds.PBGlucoseLCDS;
import org.sat4j.pb.orders.Bumper;
import org.sat4j.pb.orders.BumperEffective;
import org.sat4j.pb.orders.VarOrderHeapObjective;
import org.sat4j.pb.restarts.GrowingCoefficientRestarts;
import org.sat4j.pb.tools.InprocCardConstrLearningSolver;
import org.sat4j.pb.tools.ManyCorePB;
import org.sat4j.pb.tools.PreprocCardConstrLearningSolver;

public final class SolverFactory
extends ASolverFactory<IPBSolver> {
    private static final long serialVersionUID = 1L;
    private static SolverFactory instance;

    private SolverFactory() {
    }

    private static synchronized void createInstance() {
        if (instance == null) {
            instance = new SolverFactory();
        }
    }

    public static SolverFactory instance() {
        if (instance == null) {
            SolverFactory.createInstance();
        }
        return instance;
    }

    public static PBSolverResolution newPBResAllPB() {
        return SolverFactory.newPBRes(new PBMaxDataStructure());
    }

    public static PBSolverCP newPBCPAllPB() {
        return SolverFactory.newPBCP(new PBMaxDataStructure());
    }

    public static IPBSolver newOPBStringSolver() {
        return new OPBStringSolver();
    }

    public static PBSolverCP newPBCPMixedConstraints() {
        return SolverFactory.newPBCP(new PBMaxClauseCardConstrDataStructure());
    }

    public static PBSolverCP newPBCPMixedConstraintsObjective() {
        return SolverFactory.newPBCP(new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
    }

    public static PBSolverCP newCompetPBCPMixedConstraintsObjective() {
        return SolverFactory.newPBCP(new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
    }

    public static PBSolverCP newCompetPBCPMixedConstraintsMinObjective() {
        return SolverFactory.newPBCP(new PBMinClauseCardConstrDataStructure(), new VarOrderHeapObjective());
    }

    public static PBSolverCP newCompetPBCPMixedConstraintsLongMaxObjective() {
        PBSolverCP s = SolverFactory.newPBCP(new PBLongMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
        return s;
    }

    public static PBSolverCP newCompetPBCPRemoveSatisfiedMixedConstraintsLongMaxObjective() {
        PBSolverCP s = SolverFactory.newPBCP(new PBLongMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(), false, SkipStrategy.NO_SKIP);
        return s;
    }

    public static PBSolverCP newCompetPBCPMixedConstraintsLongMinObjective() {
        return SolverFactory.newPBCP(new PBLongMinClauseCardConstrDataStructure(), new VarOrderHeapObjective());
    }

    public static PBSolverCP newPBCPMixedConstraintsObjectiveLearnJustClauses() {
        ClauseOnlyLearning learning = new ClauseOnlyLearning();
        PBSolverCP solver = new PBSolverCP((LearningStrategy<PBDataStructureFactory>)learning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
        return solver;
    }

    public static PBSolverCP newCompetPBCPMixedConstraintsObjectiveLearnJustClauses() {
        ClauseOnlyLearning learning = new ClauseOnlyLearning();
        PBSolverCP solver = new PBSolverCP((LearningStrategy<PBDataStructureFactory>)learning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
        return solver;
    }

    private static PBSolverCP newPBKiller(IPhaseSelectionStrategy phase) {
        ClauseOnlyLearning learning = new ClauseOnlyLearning();
        PBSolverCP solver = new PBSolverCP((LearningStrategy<PBDataStructureFactory>)learning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(phase));
        return solver;
    }

    public static PBSolverCP newPBKillerRSAT() {
        return SolverFactory.newPBKiller((IPhaseSelectionStrategy)new RSATPhaseSelectionStrategy());
    }

    public static PBSolverCP newPBKillerClassic() {
        return SolverFactory.newPBKiller((IPhaseSelectionStrategy)new PhaseInLastLearnedClauseSelectionStrategy());
    }

    public static PBSolverCP newPBKillerFixed() {
        return SolverFactory.newPBKiller((IPhaseSelectionStrategy)new UserFixedPhaseSelectionStrategy());
    }

    private static PBSolverCP newCompetPBKiller(IPhaseSelectionStrategy phase) {
        ClauseOnlyLearning learning = new ClauseOnlyLearning();
        PBSolverCP solver = new PBSolverCP((LearningStrategy<PBDataStructureFactory>)learning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(phase));
        return solver;
    }

    public static PBSolverCP newCompetPBKillerRSAT() {
        return SolverFactory.newCompetPBKiller((IPhaseSelectionStrategy)new RSATPhaseSelectionStrategy());
    }

    public static PBSolverCP newCompetPBKillerClassic() {
        return SolverFactory.newCompetPBKiller((IPhaseSelectionStrategy)new PhaseInLastLearnedClauseSelectionStrategy());
    }

    public static PBSolverCP newCompetPBKillerFixed() {
        return SolverFactory.newCompetPBKiller((IPhaseSelectionStrategy)new UserFixedPhaseSelectionStrategy());
    }

    public static PBSolverCP newMiniLearningOPBClauseCardConstrMaxSpecificOrderIncrementalReductionToClause() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverClause solver = new PBSolverClause((LearningStrategy<PBDataStructureFactory>)learning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        return solver;
    }

    public static PBSolverCP newPBCPMixedConstraintsObjectiveNoLearning() {
        NoLearningButHeuristics learning = new NoLearningButHeuristics();
        PBSolverCP solver = new PBSolverCP((LearningStrategy<PBDataStructureFactory>)learning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
        learning.setVarActivityListener((VarActivityListener)solver);
        return solver;
    }

    public static PBSolverResolution newPBResMixedConstraintsObjective() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverResolution solver = new PBSolverResolution((LearningStrategy<PBDataStructureFactory>)learning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(), (RestartStrategy)new MiniSATRestarts());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        return solver;
    }

    public static PBSolverResolution newCompetPBResWLMixedConstraintsObjectiveExpSimp() {
        return SolverFactory.newCompetPBResMixedConstraintsObjectiveExpSimp(new CompetResolutionPBMixedWLClauseCardConstrDataStructure());
    }

    public static PBSolverResolution newCompetPBResHTMixedConstraintsObjectiveExpSimp() {
        return SolverFactory.newCompetPBResMixedConstraintsObjectiveExpSimp(new CompetResolutionPBMixedHTClauseCardConstrDataStructure());
    }

    public static PBSolverResolution newCompetPBResLongHTMixedConstraintsObjectiveExpSimp() {
        return SolverFactory.newCompetPBResMixedConstraintsObjectiveExpSimp(new CompetResolutionPBLongMixedHTClauseCardConstrDataStructure());
    }

    public static PBSolverResolution newCompetPBResLongWLMixedConstraintsObjectiveExpSimp() {
        return SolverFactory.newCompetPBResMixedConstraintsObjectiveExpSimp(new CompetResolutionPBLongMixedWLClauseCardConstrDataStructure());
    }

    public static PBSolverResolution newCompetMinPBResLongWLMixedConstraintsObjectiveExpSimp() {
        return SolverFactory.newCompetPBResMixedConstraintsObjectiveExpSimp(new CompetResolutionMinPBLongMixedWLClauseCardConstrDataStructure());
    }

    public static PBSolverResolution newCompetPBResMixedConstraintsObjectiveExpSimp(PBDataStructureFactory dsf) {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverResolution solver = new PBSolverResolution((LearningStrategy<PBDataStructureFactory>)learning, dsf, new VarOrderHeapObjective((IPhaseSelectionStrategy)new RSATPhaseSelectionStrategy()), (RestartStrategy)new ArminRestarts());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        solver.setSimplifier(solver.EXPENSIVE_SIMPLIFICATION);
        return solver;
    }

    public static PBSolverResolution newPBResHTMixedConstraintsObjective() {
        MiniSATLearning learning = new MiniSATLearning();
        CompetResolutionPBMixedHTClauseCardConstrDataStructure ds = new CompetResolutionPBMixedHTClauseCardConstrDataStructure();
        ds.setNormalizer(AbstractPBDataStructureFactory.NO_COMPETITION);
        PBSolverResolution solver = new PBSolverResolution((LearningStrategy<PBDataStructureFactory>)learning, ds, new VarOrderHeapObjective(), (RestartStrategy)new MiniSATRestarts());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        return solver;
    }

    public static PBSolverResolution newCompetPBResMinHTMixedConstraintsObjective() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverResolution solver = new PBSolverResolution((LearningStrategy<PBDataStructureFactory>)learning, new CompetMinHTmixedClauseCardConstrDataStructureFactory(), new VarOrderHeapObjective(), (RestartStrategy)new MiniSATRestarts());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        return solver;
    }

    public static PBSolverResolution newPBResMinHTMixedConstraintsObjective() {
        MiniSATLearning learning = new MiniSATLearning();
        CompetMinHTmixedClauseCardConstrDataStructureFactory ds = new CompetMinHTmixedClauseCardConstrDataStructureFactory();
        ds.setNormalizer(AbstractPBDataStructureFactory.NO_COMPETITION);
        PBSolverResolution solver = new PBSolverResolution((LearningStrategy<PBDataStructureFactory>)learning, ds, new VarOrderHeapObjective(), (RestartStrategy)new MiniSATRestarts());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        return solver;
    }

    public static PBSolverResolution newCompetPBResMixedConstraintsObjectiveExpSimp() {
        PBSolverResolution solver = SolverFactory.newPBResMixedConstraintsObjective();
        solver.setSimplifier(solver.EXPENSIVE_SIMPLIFICATION);
        return solver;
    }

    public static PBSolverResolution newPBResHTMixedConstraintsObjectiveExpSimp() {
        PBSolverResolution solver = SolverFactory.newPBResHTMixedConstraintsObjective();
        solver.setSimplifier(solver.EXPENSIVE_SIMPLIFICATION);
        return solver;
    }

    public static PBSolverResolution newCompetPBResMinHTMixedConstraintsObjectiveExpSimp() {
        PBSolverResolution solver = SolverFactory.newCompetPBResMinHTMixedConstraintsObjective();
        solver.setSimplifier(solver.EXPENSIVE_SIMPLIFICATION);
        return solver;
    }

    public static PBSolverClause newPBCPMixedConstraintsReduceToClause() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverClause solver = new PBSolverClause((LearningStrategy<PBDataStructureFactory>)learning, new PBMaxClauseCardConstrDataStructure(), (IOrder)new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        return solver;
    }

    public static PBSolverCautious newPBCPMixedConstraintsCautious(int bound) {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverCautious solver = new PBSolverCautious((LearningStrategy<PBDataStructureFactory>)learning, (PBDataStructureFactory)new PBMaxClauseCardConstrDataStructure(), (IOrder)new VarOrderHeapObjective(), bound);
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        return solver;
    }

    public static PBSolverCautious newPBCPMixedConstraintsCautious() {
        return SolverFactory.newPBCPMixedConstraintsCautious(10);
    }

    public static PBSolverResCP newPBCPMixedConstraintsResCP(long bound) {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverResCP solver = new PBSolverResCP((LearningStrategy<PBDataStructureFactory>)learning, (PBDataStructureFactory)new PBMaxClauseCardConstrDataStructure(), (IOrder)new VarOrderHeapObjective(), bound);
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        solver.setSimplifier(solver.EXPENSIVE_SIMPLIFICATION);
        return solver;
    }

    public static PBSolverResCP newPBCPMixedConstraintsResCP() {
        return SolverFactory.newPBCPMixedConstraintsResCP(100000L);
    }

    public static PBSolverWithImpliedClause newPBCPMixedConstrainsImplied() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverWithImpliedClause solver = new PBSolverWithImpliedClause((LearningStrategy<PBDataStructureFactory>)learning, new PBMaxClauseCardConstrDataStructure(), (IOrder)new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        return solver;
    }

    public static PBSolverCP newMiniOPBClauseAtLeastConstrMax() {
        return SolverFactory.newPBCP(new PBMaxClauseAtLeastConstrDataStructure());
    }

    public static PBSolverResolution newPBResAllPBWL() {
        return SolverFactory.newPBRes(new PBMinDataStructure());
    }

    public static PBSolverCP newPBCPAllPBWL() {
        return SolverFactory.newPBCP(new PBMinDataStructure());
    }

    public static PBSolverResolution newPBResAllPBWLPueblo() {
        return SolverFactory.newPBRes(new PuebloPBMinDataStructure());
    }

    private static PBSolverResolution newPBRes(PBDataStructureFactory dsf) {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverResolution solver = new PBSolverResolution((LearningStrategy<PBDataStructureFactory>)learning, dsf, (IOrder)new VarOrderHeap(), (RestartStrategy)new MiniSATRestarts());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        return solver;
    }

    public static PBSolverCP newPBCPAllPBWLPueblo() {
        return SolverFactory.newPBCP(new PuebloPBMinDataStructure());
    }

    public static PBSolverCP newMiniOPBClauseCardMinPueblo() {
        return SolverFactory.newPBCP(new PuebloPBMinClauseCardConstrDataStructure());
    }

    public static PBSolverCP newMiniOPBClauseCardMin() {
        return SolverFactory.newPBCP(new PBMinClauseCardConstrDataStructure());
    }

    public static PBSolverCP newMiniOPBClauseAtLeastMinPueblo() {
        return SolverFactory.newPBCP(new PuebloPBMinClauseAtLeastConstrDataStructure());
    }

    private static PBSolverCP newPBCP(PBDataStructureFactory dsf, IOrder order, boolean noRemove, SkipStrategy skipAllow) {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverCP solver = new PBSolverCP((LearningStrategy<PBDataStructureFactory>)learning, dsf, order, noRemove, skipAllow);
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        solver.setRestartStrategy((RestartStrategy)new ArminRestarts());
        solver.setLearnedConstraintsDeletionStrategy(solver.activity_based);
        return solver;
    }

    private static PBSolverCP newPBCPReduceByPowersOf2(PBDataStructureFactory dsf, IOrder order, boolean noRemove, SkipStrategy skipAllow) {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverCPReduceByPowersOf2 solver = new PBSolverCPReduceByPowersOf2((LearningStrategy<PBDataStructureFactory>)learning, dsf, order, noRemove, skipAllow);
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        solver.setRestartStrategy((RestartStrategy)new ArminRestarts());
        solver.setLearnedConstraintsDeletionStrategy(solver.activity_based);
        return solver;
    }

    private static PBSolverCP newPBCPReduceByGCD(PBDataStructureFactory dsf, IOrder order, boolean noRemove, SkipStrategy skipAllow) {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverCPReduceByGCD solver = new PBSolverCPReduceByGCD((LearningStrategy<PBDataStructureFactory>)learning, dsf, order, noRemove, skipAllow);
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        solver.setRestartStrategy((RestartStrategy)new ArminRestarts());
        solver.setLearnedConstraintsDeletionStrategy(solver.activity_based);
        return solver;
    }

    private static PBSolverCP newPBCPStar(PBDataStructureFactory dsf, IOrder order, boolean noRemove, SkipStrategy skipAllow) {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverCPLong solver = new PBSolverCPLong((LearningStrategy<PBDataStructureFactory>)learning, dsf, order, noRemove, skipAllow);
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        solver.setRestartStrategy((RestartStrategy)new ArminRestarts());
        solver.setLearnedConstraintsDeletionStrategy(solver.activity_based);
        return solver;
    }

    private static PBSolverCP newPBCPStarClauseLearning(PBDataStructureFactory dsf, IOrder order, boolean noRemove, SkipStrategy skipAllow) {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverCPClauseLearning solver = new PBSolverCPClauseLearning((LearningStrategy<PBDataStructureFactory>)learning, dsf, order, noRemove, skipAllow);
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        solver.setRestartStrategy((RestartStrategy)new ArminRestarts());
        solver.setLearnedConstraintsDeletionStrategy(solver.activity_based);
        return solver;
    }

    private static PBSolverCP newPBCPStarCardLearning(PBDataStructureFactory dsf, IOrder order, boolean noRemove, SkipStrategy skipAllow) {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverCPCardLearning solver = new PBSolverCPCardLearning((LearningStrategy<PBDataStructureFactory>)learning, dsf, order, noRemove, skipAllow);
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        solver.setRestartStrategy((RestartStrategy)new ArminRestarts());
        solver.setLearnedConstraintsDeletionStrategy(solver.activity_based);
        return solver;
    }

    private static PBSolverCP newPBCPStarDivideBy2(PBDataStructureFactory dsf, IOrder order, boolean noRemove, SkipStrategy skipAllow) {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverCPLongDivideBy2 solver = new PBSolverCPLongDivideBy2((LearningStrategy<PBDataStructureFactory>)learning, dsf, order, noRemove, skipAllow);
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        solver.setRestartStrategy((RestartStrategy)new ArminRestarts());
        solver.setLearnedConstraintsDeletionStrategy(solver.activity_based);
        return solver;
    }

    private static PBSolverCP newPBCPStarDivideByGCD(PBDataStructureFactory dsf, IOrder order, boolean noRemove, SkipStrategy skipAllow) {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverCPLongDivideByGCD solver = new PBSolverCPLongDivideByGCD((LearningStrategy<PBDataStructureFactory>)learning, dsf, order, noRemove, skipAllow);
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        solver.setRestartStrategy((RestartStrategy)new ArminRestarts());
        solver.setLearnedConstraintsDeletionStrategy(solver.activity_based);
        return solver;
    }

    private static PBSolverCP newPBCPStarRounding(PBDataStructureFactory dsf, IOrder order, boolean noRemove, SkipStrategy skipAllow) {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverCPLongRounding solver = new PBSolverCPLongRounding((LearningStrategy<PBDataStructureFactory>)learning, dsf, order, noRemove, skipAllow);
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        solver.setRestartStrategy((RestartStrategy)new ArminRestarts());
        solver.setLearnedConstraintsDeletionStrategy(solver.activity_based);
        return solver;
    }

    private static PBSolverCP newPBCPStarReduceToCard(PBDataStructureFactory dsf, IOrder order, boolean noRemove, SkipStrategy skipAllow) {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverCPLongReduceToCard solver = new PBSolverCPLongReduceToCard((LearningStrategy<PBDataStructureFactory>)learning, dsf, order, noRemove, skipAllow);
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        solver.setRestartStrategy((RestartStrategy)new ArminRestarts());
        solver.setLearnedConstraintsDeletionStrategy(solver.activity_based);
        return solver;
    }

    public static PBSolverCP newPBCP(PBDataStructureFactory dsf, IOrder order) {
        return SolverFactory.newPBCP(dsf, order, true, SkipStrategy.NO_SKIP);
    }

    private static PBSolverCP newPBCP(PBDataStructureFactory dsf) {
        return SolverFactory.newPBCP(dsf, (IOrder)new VarOrderHeap());
    }

    public static PBSolverCP newCuttingPlanes() {
        return SolverFactory.newCompetPBCPMixedConstraintsObjective();
    }

    public static IPBSolver newCuttingPlanesWatched() {
        return SolverFactory.newCompetPBCPMixedConstraintsMinObjective();
    }

    public static PBSolverCP newCuttingPlanesReduceByPowersOf2() {
        return SolverFactory.newPBCPReduceByPowersOf2(new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(), true, SkipStrategy.NO_SKIP);
    }

    public static PBSolverCP newCuttingPlanesReduceByGCD() {
        return SolverFactory.newPBCPReduceByGCD(new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(), true, SkipStrategy.NO_SKIP);
    }

    public static PBSolverCP newCuttingPlanesStar() {
        return SolverFactory.newPBCPStar(new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(), true, SkipStrategy.NO_SKIP);
    }

    public static PBSolverCP newCuttingPlanesStarRounding() {
        return SolverFactory.newPBCPStarRounding(new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(), true, SkipStrategy.NO_SKIP);
    }

    public static PBSolverCP newCuttingPlanesStarReduceToCard() {
        return SolverFactory.newPBCPStarReduceToCard(new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(), true, SkipStrategy.NO_SKIP);
    }

    public static PBSolverCP newCuttingPlanesStarClauseLearning() {
        return SolverFactory.newPBCPStarClauseLearning(new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(), true, SkipStrategy.NO_SKIP);
    }

    public static PBSolverCP newCuttingPlanesStarCardLearning() {
        return SolverFactory.newPBCPStarCardLearning(new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(), true, SkipStrategy.NO_SKIP);
    }

    public static PBSolverCP newCuttingPlanesStarDivideBy2() {
        return SolverFactory.newPBCPStarDivideBy2(new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(), true, SkipStrategy.NO_SKIP);
    }

    public static PBSolverCP newCuttingPlanesStarDivideByGCD() {
        return SolverFactory.newPBCPStarDivideByGCD(new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(), true, SkipStrategy.NO_SKIP);
    }

    public static IPBSolver newCuttingPlanesReduceByPowersOf2Skip() {
        return SolverFactory.newPBCPReduceByPowersOf2(new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(), true, SkipStrategy.SKIP);
    }

    public static IPBSolver newCuttingPlanesReduceByGCDSkip() {
        return SolverFactory.newPBCPReduceByGCD(new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(), true, SkipStrategy.SKIP);
    }

    public static IPBSolver newCuttingPlanesStarSkip() {
        return SolverFactory.newPBCPStar(new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(), true, SkipStrategy.SKIP);
    }

    public static IPBSolver newCuttingPlanesStarRoundingSkip() {
        return SolverFactory.newPBCPStarRounding(new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(), true, SkipStrategy.SKIP);
    }

    public static IPBSolver newCuttingPlanesStarReduceToCardSkip() {
        return SolverFactory.newPBCPStarReduceToCard(new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(), true, SkipStrategy.SKIP);
    }

    public static IPBSolver newCuttingPlanesStarClauseLearningSkip() {
        return SolverFactory.newPBCPStarClauseLearning(new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(), true, SkipStrategy.SKIP);
    }

    public static IPBSolver newCuttingPlanesStarCardLearningSkip() {
        return SolverFactory.newPBCPStarCardLearning(new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(), true, SkipStrategy.SKIP);
    }

    public static IPBSolver newCuttingPlanesStarDivideBy2Skip() {
        return SolverFactory.newPBCPStarDivideBy2(new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(), true, SkipStrategy.SKIP);
    }

    public static IPBSolver newCuttingPlanesStarDivideByGCDSkip() {
        return SolverFactory.newPBCPStarDivideByGCD(new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(), true, SkipStrategy.SKIP);
    }

    public static IPBSolver newCuttingPlanesAggressiveCleanup() {
        PBSolverCP solver = SolverFactory.newCompetPBCPMixedConstraintsObjective();
        solver.setLearnedConstraintsDeletionStrategy(solver.fixedSize(100));
        return solver;
    }

    public static IPBSolver newResolution() {
        return SolverFactory.newResolutionGlucoseExpSimp();
    }

    public static IPBSolver newResolutionWL() {
        PBSolverResolution solver = SolverFactory.newCompetPBResMixedConstraintsObjectiveExpSimp(new PuebloPBMinDataStructure());
        solver.setSimplifier(Solver.NO_SIMPLIFICATION);
        solver.setRestartStrategy((RestartStrategy)new Glucose21Restarts());
        solver.setLearnedConstraintsDeletionStrategy(solver.lbd_based);
        solver.setSimplifier(solver.EXPENSIVE_SIMPLIFICATION);
        return solver;
    }

    public static IPBSolver newBoth() {
        return new ManyCorePB(new IPBSolver[]{SolverFactory.newResolution(), SolverFactory.newCuttingPlanes()});
    }

    public static IPBSolver newSoberBoth() {
        PBSolverCP cp = SolverFactory.newCuttingPlanes();
        cp.setTimeout(60);
        return new ManyCorePB(new IPBSolver[]{SolverFactory.newResolution(), new PBTimeoutIsolator(cp)});
    }

    public static IPBSolver newBothStar() {
        return new ManyCorePB(new IPBSolver[]{SolverFactory.newResolution(), SolverFactory.newCuttingPlanesStar()});
    }

    public static IPBSolver newSATUNSAT() {
        return new ManyCorePB(new IPBSolver[]{SolverFactory.newSAT(), SolverFactory.newUNSAT()});
    }

    public static PBSolverResolution newSAT() {
        PBSolverResolution solver = SolverFactory.newResolutionGlucose();
        solver.setRestartStrategy((RestartStrategy)new LubyRestarts(100));
        solver.setLearnedConstraintsDeletionStrategy(solver.activity_based_low_memory);
        return solver;
    }

    public static PBSolverResolution newUNSAT() {
        PBSolverResolution solver = SolverFactory.newResolutionGlucose();
        solver.setRestartStrategy((RestartStrategy)new NoRestarts());
        solver.setSimplifier(solver.SIMPLE_SIMPLIFICATION);
        return solver;
    }

    public static PBSolverResolution newResolutionGlucose() {
        PBSolverResolution solver = SolverFactory.newCompetPBResLongWLMixedConstraintsObjectiveExpSimp();
        solver.setSimplifier(Solver.NO_SIMPLIFICATION);
        solver.setRestartStrategy((RestartStrategy)new Glucose21Restarts());
        solver.setLearnedConstraintsDeletionStrategy(solver.lbd_based);
        return solver;
    }

    public static PBSolverResolution newResolutionGlucose21() {
        PBSolverResolution solver = SolverFactory.newResolutionGlucose();
        solver.setRestartStrategy((RestartStrategy)new Glucose21Restarts());
        return solver;
    }

    public static PBSolverResolution newResolutionGlucoseSimpleSimp() {
        PBSolverResolution solver = SolverFactory.newResolutionGlucose();
        solver.setSimplifier(solver.SIMPLE_SIMPLIFICATION);
        return solver;
    }

    public static PBSolverResolution newResolutionGlucoseExpSimp() {
        PBSolverResolution solver = SolverFactory.newResolutionGlucose();
        solver.setSimplifier(solver.EXPENSIVE_SIMPLIFICATION);
        return solver;
    }

    public static IPBSolver newSimpleSimplification() {
        PBSolverResolution solver = SolverFactory.newCompetPBResWLMixedConstraintsObjectiveExpSimp();
        solver.setLearnedConstraintsDeletionStrategy(solver.lbd_based);
        solver.setSimplifier(solver.SIMPLE_SIMPLIFICATION);
        return solver;
    }

    public static IPBSolver newResolutionSimpleRestarts() {
        PBSolverResolution solver = SolverFactory.newCompetPBResLongWLMixedConstraintsObjectiveExpSimp();
        solver.setLearnedConstraintsDeletionStrategy(solver.lbd_based);
        solver.setRestartStrategy((RestartStrategy)new MiniSATRestarts());
        return solver;
    }

    public static IPBSolver newResolutionMaxMemory() {
        PBSolverResolution solver = SolverFactory.newCompetPBResLongWLMixedConstraintsObjectiveExpSimp();
        solver.setLearnedConstraintsDeletionStrategy(solver.activity_based_low_memory);
        return solver;
    }

    public static PBSolver newDefault() {
        return SolverFactory.newResolutionGlucose21();
    }

    public static IPBSolver newDefaultNonNormalized() {
        PBSolver solver = SolverFactory.newDefault();
        CompetResolutionPBLongMixedWLClauseCardConstrDataStructure ds = new CompetResolutionPBLongMixedWLClauseCardConstrDataStructure();
        ds.setNormalizer(AbstractPBDataStructureFactory.NO_COMPETITION);
        solver.setDataStructureFactory(ds);
        return solver;
    }

    public PBSolver defaultSolver() {
        return SolverFactory.newDefault();
    }

    public static IPBSolver newDefaultOptimizer() {
        return new OptToPBSATAdapter(new PseudoOptDecorator(SolverFactory.newDefault()));
    }

    public static IPBSolver newLight() {
        return SolverFactory.newCompetPBResMixedConstraintsObjectiveExpSimp();
    }

    public IPBSolver lightSolver() {
        return SolverFactory.newLight();
    }

    public static IPBSolver newEclipseP2() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverResolution solver = new PBSolverResolution((LearningStrategy<PBDataStructureFactory>)learning, new CompetResolutionPBMixedHTClauseCardConstrDataStructure(), new VarOrderHeapObjective((IPhaseSelectionStrategy)new RSATPhaseSelectionStrategy()), (RestartStrategy)new ArminRestarts());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        solver.setTimeoutOnConflicts(300);
        solver.setVerbose(false);
        solver.setLearnedConstraintsDeletionStrategy(solver.activity_based_low_memory);
        return new OptToPBSATAdapter(new PseudoOptDecorator(solver));
    }

    public static PreprocCardConstrLearningSolver<IPBSolver> newDetectCards() {
        return new PreprocCardConstrLearningSolver<IPBSolver>(SolverFactory.newCuttingPlanes());
    }

    public static PreprocCardConstrLearningSolver<IPBSolver> newDetectCardsAndExit() {
        return new PreprocCardConstrLearningSolver<IPBSolver>(SolverFactory.newDefault(), true);
    }

    public static IPBSolver newInprocDetectCards() {
        InprocCardConstrLearningSolver solver = (InprocCardConstrLearningSolver)SolverFactory.newLazyInprocDetectCards();
        solver.setDetectCardFromAllConstraintsInCflAnalysis(true);
        return solver;
    }

    public static IPBSolver newInprocDetectCardsSkip() {
        InprocCardConstrLearningSolver solver = (InprocCardConstrLearningSolver)SolverFactory.newLazyInprocDetectCardsSkip();
        solver.setDetectCardFromAllConstraintsInCflAnalysis(true);
        return solver;
    }

    public static IPBSolver newLazyInprocDetectCards() {
        return new InprocCardConstrLearningSolver((LearningStrategy<PBDataStructureFactory>)new MiniSATLearning(), (PBDataStructureFactory)new PBMaxClauseCardConstrDataStructure(), (IOrder)new VarOrderHeap(), true, SkipStrategy.NO_SKIP);
    }

    public static IPBSolver newLazyInprocDetectCardsSkip() {
        return new InprocCardConstrLearningSolver((LearningStrategy<PBDataStructureFactory>)new MiniSATLearning(), (PBDataStructureFactory)new PBMaxClauseCardConstrDataStructure(), (IOrder)new VarOrderHeap(), true, SkipStrategy.SKIP);
    }

    public static IPBSolver newPartialRoundingSat() {
        PBSolverCP solver = SolverFactory.newCuttingPlanes();
        solver.setConflictFactory(ConflictMapDivideByPivot.partialWeakeningOnBothFactory());
        return solver;
    }

    public static IPBSolver newRoundingSat() {
        PBSolverCP solver = SolverFactory.newCuttingPlanes();
        solver.setConflictFactory(ConflictMapDivideByPivot.fullWeakeningOnBothFactory());
        return solver;
    }

    public static IPBSolver newCuttingPlanesPOS2020() {
        PBSolverCP solver = SolverFactory.newCuttingPlanes();
        solver.setBumper(new BumperEffective());
        LearnedConstraintsDeletionStrategy lcds = PBGlucoseLCDS.newUnassignedSame(solver, solver.lbd_based.getTimer());
        solver.setLearnedConstraintsDeletionStrategy(lcds);
        solver.setRestartStrategy(new GrowingCoefficientRestarts());
        return solver;
    }

    public static IPBSolver newPartialRoundingSatPOS2020() {
        PBSolverCP solver = (PBSolverCP)SolverFactory.newPartialRoundingSat();
        solver.setBumper(Bumper.ASSIGNED);
        LearnedConstraintsDeletionStrategy lcds = PBGlucoseLCDS.newDegreeSize(solver, solver.lbd_based.getTimer());
        solver.setLearnedConstraintsDeletionStrategy(lcds);
        return solver;
    }

    public static IPBSolver newRoundingSatPOS2020() {
        PBSolverCP solver = (PBSolverCP)SolverFactory.newRoundingSat();
        solver.setBumper(Bumper.ASSIGNED);
        LearnedConstraintsDeletionStrategy lcds = PBGlucoseLCDS.newSlack(solver, solver.lbd_based.getTimer());
        solver.setLearnedConstraintsDeletionStrategy(lcds);
        return solver;
    }

    public static IPBSolver newCuttingPlanesPOS2020WL() {
        PBSolverCP solver = (PBSolverCP)SolverFactory.newCuttingPlanesPOS2020();
        solver.setDataStructureFactory(new PuebloPBMinDataStructure());
        return solver;
    }

    public static IPBSolver newPartialRoundingSatPOS2020WL() {
        PBSolverCP solver = (PBSolverCP)SolverFactory.newPartialRoundingSatPOS2020();
        solver.setDataStructureFactory(new PuebloPBMinDataStructure());
        return solver;
    }

    public static IPBSolver newRoundingSatPOS2020WL() {
        PBSolverCP solver = (PBSolverCP)SolverFactory.newRoundingSatPOS2020();
        solver.setDataStructureFactory(new PuebloPBMinDataStructure());
        return solver;
    }

    public static IPBSolver newBothPOS2020() {
        return new ManyCorePB(new IPBSolver[]{SolverFactory.newResolution(), SolverFactory.newCuttingPlanesPOS2020()});
    }

    public static IPBSolver newBothPOS2020WL() {
        return new ManyCorePB(new IPBSolver[]{SolverFactory.newResolutionWL(), SolverFactory.newCuttingPlanesPOS2020WL()});
    }

    public static IPBSolver newBothPartialRoundingSatPOS2020WL() {
        return new ManyCorePB(new IPBSolver[]{SolverFactory.newResolutionWL(), SolverFactory.newPartialRoundingSatPOS2020WL()});
    }

    public static IPBSolver newBothPartialRoundingSatPOS2020() {
        return new ManyCorePB(new IPBSolver[]{SolverFactory.newResolution(), SolverFactory.newPartialRoundingSatPOS2020()});
    }

    public static IPBSolver newBothRoundingSatPOS2020WL() {
        return new ManyCorePB(new IPBSolver[]{SolverFactory.newResolutionWL(), SolverFactory.newRoundingSatPOS2020WL()});
    }

    public static IPBSolver newBothRoundingSatPOS2020() {
        return new ManyCorePB(new IPBSolver[]{SolverFactory.newResolution(), SolverFactory.newRoundingSatPOS2020()});
    }

    public static IPBSolver newAllPOS2020WL() {
        return new ManyCorePB(new IPBSolver[]{SolverFactory.newResolutionWL(), SolverFactory.newRoundingSatPOS2020WL(), SolverFactory.newPartialRoundingSatPOS2020WL(), SolverFactory.newCuttingPlanesPOS2020WL()});
    }

    public static IPBSolver newAllPOS2020() {
        return new ManyCorePB(new IPBSolver[]{SolverFactory.newResolution(), SolverFactory.newRoundingSatPOS2020(), SolverFactory.newPartialRoundingSatPOS2020(), SolverFactory.newCuttingPlanesPOS2020()});
    }

    public static IPBSolver newAllSAT2020() {
        return new ManyCorePB(new IPBSolver[]{SolverFactory.newResolution(), SolverFactory.newRoundingSat(), SolverFactory.newPartialRoundingSat(), SolverFactory.newCuttingPlanes()});
    }
}

