/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.util;

import java.util.AbstractList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.equinox.http.servlet.internal.registration.ListenerRegistration;

public class EventListeners {
    private final ConcurrentMap<Class<? extends EventListener>, List<ListenerRegistration>> map = new ConcurrentHashMap<Class<? extends EventListener>, List<ListenerRegistration>>();

    public void clear() {
        this.map.clear();
    }

    public <E extends EventListener> List<E> get(Class<E> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz can't be null");
        }
        List list = (List)this.map.get(clazz);
        if (list == null) {
            return Collections.emptyList();
        }
        return new ListenerList(list);
    }

    public <E extends EventListener> void put(Class<E> clazz, ListenerRegistration listenerRegistration) {
        CopyOnWriteArrayList<ListenerRegistration> newList;
        if (clazz == null) {
            throw new NullPointerException("clazz can't be null");
        }
        CopyOnWriteArrayList<ListenerRegistration> list = (CopyOnWriteArrayList<ListenerRegistration>)this.map.get(clazz);
        if (list == null && (list = (List)this.map.putIfAbsent(clazz, newList = new CopyOnWriteArrayList<ListenerRegistration>())) == null) {
            list = newList;
        }
        list.add(listenerRegistration);
    }

    public void put(List<Class<? extends EventListener>> classes, ListenerRegistration listenerRegistration) {
        for (Class<? extends EventListener> clazz : classes) {
            this.put(clazz, listenerRegistration);
        }
    }

    public <E extends EventListener> void remove(Class<E> clazz, ListenerRegistration listenerRegistration) {
        if (clazz == null) {
            throw new NullPointerException("clazz can't be null");
        }
        List list = (List)this.map.get(clazz);
        if (list == null) {
            return;
        }
        list.remove(listenerRegistration);
    }

    public void remove(List<Class<? extends EventListener>> classes, ListenerRegistration listenerRegistration) {
        for (Class<? extends EventListener> clazz : classes) {
            this.remove(clazz, listenerRegistration);
        }
    }

    class ListenerList<R extends EventListener>
    extends AbstractList<R> {
        private final List<ListenerRegistration> list;

        ListenerList(List<ListenerRegistration> list) {
            this.list = list;
        }

        @Override
        public R get(int index) {
            return (R)this.list.get(index).getT();
        }

        @Override
        public int size() {
            return this.list.size();
        }
    }
}

