/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.internal.client.ui.invocationView;

import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.eclipse.equinox.jmx.common.ContributionProxy;
import org.eclipse.equinox.jmx.common.util.MBeanUtils;
import org.eclipse.equinox.jmx.internal.client.Activator;
import org.eclipse.equinox.jmx.internal.client.MBeanServerProxy;
import org.eclipse.equinox.jmx.internal.client.ui.contributionsview.ContributionsViewPart;
import org.eclipse.equinox.jmx.internal.client.ui.mbeaninfoview.MBeanInfoViewMessages;
import org.eclipse.equinox.jmx.internal.client.ui.viewsupport.ViewUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

public class InvocationView
extends ViewPart
implements ISelectionListener {
    private Composite fInvocationComposite;
    private ManagedForm fManagedForm;
    private MBeanOperationInfo fSelectedOperation;
    private Font fItalicFont;
    protected ContributionProxy fSelectedContribution;
    private Composite parentComp;

    public void createPartControl(Composite parent) {
        this.parentComp = parent;
        FontData[] fd = parent.getFont().getFontData();
        this.fItalicFont = new Font((Device)parent.getDisplay(), fd[0].getName(), fd[0].getHeight(), 2);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    public void dispose() {
        this.fItalicFont.dispose();
        if (this.fManagedForm != null) {
            this.fManagedForm.dispose();
        }
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void setFocus() {
        if (this.fManagedForm != null) {
            this.fManagedForm.setFocus();
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        String id = part.getSite().getId();
        if (id.equals("org.eclipse.equinox.jmx.client.ui.mbeaninfoview") && obj instanceof MBeanOperationInfo) {
            MBeanOperationInfo contrib = (MBeanOperationInfo)obj;
            if (contrib == this.fSelectedOperation) {
                return;
            }
            this.fSelectedOperation = contrib;
            this.drawInvocationDetails(contrib);
        } else if (id.equals("org.eclipse.equinox.jmx.client.ui.contributionsview") && obj instanceof ContributionProxy) {
            this.fSelectedContribution = (ContributionProxy)obj;
            this.clear();
        }
    }

    public void clear() {
        this.drawInvocationDetails(null);
    }

    protected void drawInvocationDetails(MBeanOperationInfo opInfo) {
        Composite c;
        Control[] childs;
        if (this.parentComp != null && !this.parentComp.isDisposed() && (childs = this.parentComp.getChildren()).length > 0) {
            int i = 0;
            while (i < childs.length) {
                childs[i].dispose();
                ++i;
            }
        }
        if (opInfo == null) {
            return;
        }
        if (this.fManagedForm != null) {
            this.fManagedForm.dispose();
        }
        this.fManagedForm = new ManagedForm(this.parentComp);
        Composite body = this.fManagedForm.getForm().getBody();
        body.setLayout((Layout)new GridLayout());
        body.setLayoutData((Object)new GridData(1808));
        this.fInvocationComposite = ViewUtil.createSection(MBeanInfoViewMessages.InvocationView_0, null, (IManagedForm)this.fManagedForm, body, 1, true, false);
        FormToolkit toolkit = this.fManagedForm.getToolkit();
        String desc = opInfo.getDescription();
        if (desc != null && desc.length() > 0) {
            c = toolkit.createComposite(this.fInvocationComposite, 0);
            c.setLayout((Layout)new GridLayout());
            toolkit.createLabel(c, desc);
        }
        c = toolkit.createComposite(this.fInvocationComposite, 0);
        c.setLayout((Layout)new GridLayout(4, false));
        toolkit.createLabel(c, opInfo.getReturnType() != null ? opInfo.getReturnType() : "void");
        toolkit.createLabel(c, String.valueOf(opInfo.getName()) + ' ').setFont(this.fItalicFont);
        MBeanParameterInfo[] params = opInfo.getSignature();
        Text[] textParams = null;
        if (params.length > 0) {
            Composite paramsComposite = toolkit.createComposite(c, 0);
            paramsComposite.setLayout((Layout)new GridLayout(params.length + 1, false));
            textParams = new Text[params.length];
            int j = 0;
            while (j < params.length) {
                MBeanParameterInfo param = params[j];
                textParams[j] = new Text(paramsComposite, 2052);
                textParams[j].setText(String.valueOf(param.getType()) + "(" + param.getName() + ")");
                textParams[j].setLayoutData((Object)new GridData(768));
                ++j;
            }
            paramsComposite.pack();
        }
        new InvokeOperationButton(opInfo.getName(), textParams, params, c, 8);
        this.fInvocationComposite.pack();
        this.parentComp.layout();
    }

    private class InvokeOperationButton
    extends SelectionAdapter {
        private String fMethodName;
        private Text[] fTextParams;
        private MBeanParameterInfo[] fParamTypes;
        private Button fButton;

        public InvokeOperationButton(String methodName, Text[] textParams, MBeanParameterInfo[] paramTypes, Composite parent, int style) {
            this.fMethodName = methodName;
            this.fTextParams = textParams;
            this.fParamTypes = paramTypes;
            this.fButton = InvocationView.this.fManagedForm.getToolkit().createButton(parent, MBeanInfoViewMessages.button_invoke, style);
            this.fButton.addSelectionListener((SelectionListener)this);
        }

        public void widgetSelected(SelectionEvent event) {
            try {
                ContributionsViewPart contribsViewPart;
                Object[] paramList = null;
                if (this.fTextParams != null) {
                    String[] strs = new String[this.fTextParams.length];
                    int i = 0;
                    while (i < strs.length) {
                        strs[i] = this.fTextParams[i].getText();
                        ++i;
                    }
                    paramList = MBeanUtils.getParameters((String[])strs, (MBeanParameterInfo[])this.fParamTypes);
                }
                if ((contribsViewPart = ViewUtil.getContributionsView()) != null) {
                    Object result;
                    MBeanServerProxy serverProxy = contribsViewPart.getMBeanServerProxy();
                    if (paramList != null) {
                        String[] paramSig = new String[this.fParamTypes.length];
                        int i = 0;
                        while (i < paramSig.length) {
                            paramSig[i] = this.fParamTypes[i].getType();
                            ++i;
                        }
                        result = serverProxy.invokeContributionOperation(InvocationView.this.fSelectedContribution, this.fMethodName, paramList, paramSig);
                    } else {
                        result = serverProxy.invokeContributionOperation(InvocationView.this.fSelectedContribution, this.fMethodName, new Object[0], new String[0]);
                    }
                    if (result != null) {
                        String message = result.toString();
                        MessageDialog.openInformation((Shell)InvocationView.this.fManagedForm.getForm().getShell(), (String)MBeanInfoViewMessages.invoke_result, (String)message);
                    }
                }
            }
            catch (Exception e) {
                Activator.logError(e);
                MessageDialog.openError(null, (String)MBeanInfoViewMessages.error, (String)e.getMessage());
            }
        }
    }
}

