/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.internal.client.ui.contributionsview;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import org.eclipse.equinox.jmx.common.ContributionProxy;
import org.eclipse.equinox.jmx.common.ContributionProxyMBean;
import org.eclipse.equinox.jmx.common.util.ByteArrayHolder;
import org.eclipse.equinox.jmx.internal.client.Activator;
import org.eclipse.equinox.jmx.internal.client.ui.contributionsview.BundleStatusLabelDecorator;
import org.eclipse.equinox.jmx.internal.client.ui.contributionsview.ContributionViewMessages;
import org.eclipse.equinox.jmx.internal.client.ui.util.ByteImageRegistry;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class ContributionLabelProvider
implements ILabelProvider {
    private ArrayList labelDecorators;
    private BundleStatusLabelDecorator bundleStatusDecorator = new BundleStatusLabelDecorator();
    private ByteImageRegistry imageRegistry = new ByteImageRegistry();

    public ContributionLabelProvider() {
        this.addLabelDecorator(this.bundleStatusDecorator);
    }

    public void addLabelDecorator(ILabelDecorator decorator) {
        if (this.labelDecorators == null) {
            this.labelDecorators = new ArrayList(2);
        }
        this.labelDecorators.add(decorator);
    }

    public Image getImage(Object element) {
        ByteArrayHolder holder;
        if (element instanceof ContributionProxy && (holder = ((ContributionProxy)element).getImageData()) != null) {
            byte[] imageData = holder.value;
            if (holder.value != null) {
                try {
                    return this.decorateImage(this.imageRegistry.getImage(imageData), element);
                }
                catch (IOException e) {
                    Activator.log(e);
                }
            }
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof ContributionProxyMBean) {
            return this.decorateText(((ContributionProxyMBean)element).getName(), element);
        }
        if (element instanceof MBeanInfo) {
            return this.decorateText(ContributionViewMessages.operations, element);
        }
        if (element instanceof MBeanOperationInfo) {
            return ((MBeanOperationInfo)element).getName();
        }
        return this.decorateText(element.toString(), element);
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.imageRegistry.dispose();
        this.labelDecorators.clear();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    protected String decorateText(String text, Object element) {
        if (this.labelDecorators != null && text.length() > 0) {
            Iterator iter = ((AbstractList)this.labelDecorators).iterator();
            while (iter.hasNext()) {
                ILabelDecorator decorator = (ILabelDecorator)iter.next();
                text = decorator.decorateText(text, element);
            }
        }
        return text;
    }

    protected Image decorateImage(Image image, Object element) {
        if (this.labelDecorators != null && image != null) {
            Iterator iter = ((AbstractList)this.labelDecorators).iterator();
            while (iter.hasNext()) {
                ILabelDecorator decorator = (ILabelDecorator)iter.next();
                image = decorator.decorateImage(image, element);
            }
        }
        return image;
    }
}

