/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.equinox.metatype.AttributeDefinitionImpl;
import org.eclipse.equinox.metatype.FragmentUtils;
import org.eclipse.equinox.metatype.Icon;
import org.eclipse.equinox.metatype.LocalizationElement;
import org.eclipse.equinox.metatype.MetaTypeProviderImpl;
import org.osgi.framework.Bundle;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

public class ObjectClassDefinitionImpl
extends LocalizationElement
implements ObjectClassDefinition,
Cloneable {
    public static final char LOCALE_SEP = '_';
    String _name;
    String _id;
    String _description;
    int _type;
    Vector<AttributeDefinitionImpl> _required = new Vector(7);
    Vector<AttributeDefinitionImpl> _optional = new Vector(7);
    Icon _icon;

    public ObjectClassDefinitionImpl(String name, String description, String id, String localization) {
        this._name = name;
        this._description = description;
        this._id = id;
        this._localization = localization;
    }

    public ObjectClassDefinitionImpl(String name, String description, String id, int type, String localization) {
        this._name = name;
        this._id = id;
        this._description = description;
        this._type = type;
        this._localization = localization;
    }

    public synchronized Object clone() {
        AttributeDefinitionImpl ad;
        ObjectClassDefinitionImpl ocd = new ObjectClassDefinitionImpl(this._name, this._description, this._id, this._type, this._localization);
        int i = 0;
        while (i < this._required.size()) {
            ad = this._required.elementAt(i);
            ocd.addAttributeDefinition((AttributeDefinitionImpl)ad.clone(), true);
            ++i;
        }
        i = 0;
        while (i < this._optional.size()) {
            ad = this._optional.elementAt(i);
            ocd.addAttributeDefinition((AttributeDefinitionImpl)ad.clone(), false);
            ++i;
        }
        if (this._icon != null) {
            ocd.setIcon((Icon)this._icon.clone());
        }
        return ocd;
    }

    public String getName() {
        return this.getLocalized(this._name);
    }

    void setName(String name) {
        this._name = name;
    }

    public String getID() {
        return this._id;
    }

    public String getDescription() {
        return this.getLocalized(this._description);
    }

    void setDescription(String description) {
        this._description = description;
    }

    public AttributeDefinition[] getAttributeDefinitions(int filter) {
        switch (filter) {
            case 1: {
                AttributeDefinition[] atts = new AttributeDefinition[this._required.size()];
                this._required.toArray(atts);
                return atts;
            }
            case 2: {
                AttributeDefinition[] atts = new AttributeDefinition[this._optional.size()];
                this._optional.toArray(atts);
                return atts;
            }
        }
        AttributeDefinition[] atts = new AttributeDefinition[this._required.size() + this._optional.size()];
        Enumeration<AttributeDefinitionImpl> e = this._required.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            atts[i] = e.nextElement();
            ++i;
        }
        e = this._optional.elements();
        while (e.hasMoreElements()) {
            atts[i] = e.nextElement();
            ++i;
        }
        return atts;
    }

    void addAttributeDefinition(AttributeDefinitionImpl ad, boolean isRequired) {
        if (isRequired) {
            this._required.addElement(ad);
        } else {
            this._optional.addElement(ad);
        }
    }

    public InputStream getIcon(int sizeHint) throws IOException {
        if (this._icon == null) {
            return null;
        }
        Bundle b = this._icon.getIconBundle();
        URL[] urls = FragmentUtils.findEntries(b, this.getLocalized(this._icon.getIconName()));
        if (urls != null && urls.length > 0) {
            return urls[0].openStream();
        }
        return null;
    }

    void setIcon(Icon icon) {
        this._icon = icon;
    }

    void setResourceBundle(String assignedLocale, Bundle bundle) {
        this._rb = this.getResourceBundle(assignedLocale, bundle);
        Enumeration<AttributeDefinitionImpl> allADReqs = this._required.elements();
        while (allADReqs.hasMoreElements()) {
            AttributeDefinitionImpl ad = allADReqs.nextElement();
            ad.setResourceBundle(this._rb);
        }
        Enumeration<AttributeDefinitionImpl> allADOpts = this._optional.elements();
        while (allADOpts.hasMoreElements()) {
            AttributeDefinitionImpl ad = allADOpts.nextElement();
            ad.setResourceBundle(this._rb);
        }
    }

    private ResourceBundle getResourceBundle(String locale, Bundle bundle) {
        int idx2_first;
        String defaultLocale;
        int idx2_second;
        String resourceBase = this._localization != null ? this._localization : MetaTypeProviderImpl.getBundleLocalization(bundle);
        String[] searchCandidates = new String[7];
        if (locale != null && locale.length() > 0) {
            int idx1_first = locale.indexOf(95);
            if (idx1_first == -1) {
                searchCandidates[2] = "_" + locale;
            } else {
                searchCandidates[2] = "_" + locale.substring(0, idx1_first);
                int idx1_second = locale.indexOf(95, idx1_first + 1);
                if (idx1_second == -1) {
                    searchCandidates[1] = "_" + locale;
                } else {
                    searchCandidates[1] = "_" + locale.substring(0, idx1_second);
                    searchCandidates[0] = "_" + locale;
                }
            }
        }
        if ((idx2_second = (defaultLocale = Locale.getDefault().toString()).indexOf(95, (idx2_first = defaultLocale.indexOf(95)) + 1)) != -1) {
            searchCandidates[3] = "_" + defaultLocale;
            if (searchCandidates[3].equalsIgnoreCase(searchCandidates[0])) {
                searchCandidates[3] = null;
            }
        }
        if (idx2_first != -1 && idx2_second != idx2_first + 1) {
            searchCandidates[4] = "_" + (idx2_second == -1 ? defaultLocale : defaultLocale.substring(0, idx2_second));
            if (searchCandidates[4].equalsIgnoreCase(searchCandidates[1])) {
                searchCandidates[4] = null;
            }
        }
        if (idx2_first == -1 && defaultLocale.length() > 0) {
            searchCandidates[5] = "_" + defaultLocale;
        } else if (idx2_first > 0) {
            searchCandidates[5] = "_" + defaultLocale.substring(0, idx2_first);
        }
        if (searchCandidates[5] != null && searchCandidates[5].equalsIgnoreCase(searchCandidates[2])) {
            searchCandidates[5] = null;
        }
        searchCandidates[6] = "";
        URL resourceUrl = null;
        URL[] urls = null;
        int idx = 0;
        while (idx < searchCandidates.length && resourceUrl == null) {
            URL[] uRLArray = urls = searchCandidates[idx] == null ? null : FragmentUtils.findEntries(bundle, String.valueOf(resourceBase) + searchCandidates[idx] + ".properties");
            if (urls != null && urls.length > 0) {
                resourceUrl = urls[0];
            }
            ++idx;
        }
        if (resourceUrl != null) {
            try {
                return new PropertyResourceBundle(resourceUrl.openStream());
            }
            catch (IOException iOException) {}
        }
        return null;
    }
}

