/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.equinox.metatype.DataParser;
import org.eclipse.equinox.metatype.Designate;
import org.eclipse.equinox.metatype.MetaTypeMsg;
import org.eclipse.equinox.metatype.ObjectClassDefinitionImpl;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;

public class MetaTypeProviderImpl
implements MetaTypeProvider {
    public static final String METADATA_NOT_FOUND = "METADATA_NOT_FOUND";
    public static final String OCD_ID_NOT_FOUND = "OCD_ID_NOT_FOUND";
    public static final String ASK_INVALID_LOCALE = "ASK_INVALID_LOCALE";
    public static final String META_FILE_EXT = ".XML";
    public static final String RESOURCE_FILE_CONN = "_";
    public static final String RESOURCE_FILE_EXT = ".properties";
    public static final char DIRECTORY_SEP = '/';
    Bundle _bundle;
    Hashtable<String, ObjectClassDefinitionImpl> _allPidOCDs = new Hashtable(7);
    Hashtable<String, ObjectClassDefinitionImpl> _allFPidOCDs = new Hashtable(7);
    String[] _locales;
    boolean _isThereMeta = false;
    protected final LogService logger;
    static /* synthetic */ Class class$0;

    MetaTypeProviderImpl(Bundle bundle, SAXParserFactory parserFactory, LogService logger) throws IOException {
        this._bundle = bundle;
        this.logger = logger;
        this._isThereMeta = this.readMetaFiles(bundle, parserFactory);
        if (!this._isThereMeta) {
            logger.log(4, NLS.bind((String)MetaTypeMsg.METADATA_NOT_FOUND, (Object)new Long(bundle.getBundleId()), (Object)bundle.getSymbolicName()));
        }
    }

    private boolean readMetaFiles(Bundle bundle, SAXParserFactory parserFactory) throws IOException {
        BundleWiring wiring;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.framework.wiring.BundleWiring");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((wiring = (BundleWiring)bundle.adapt((Class)clazz)) == null) {
            return false;
        }
        List entries = wiring.findEntries("OSGI-INF/metatype", "*", 0);
        if (entries == null) {
            return false;
        }
        boolean result = false;
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            URL entry = (URL)iterator.next();
            DataParser parser = new DataParser(bundle, entry, parserFactory, this.logger);
            try {
                Collection<Designate> designates = parser.doParse();
                if (!designates.isEmpty()) {
                    result = true;
                }
                Iterator<Designate> iterator2 = designates.iterator();
                while (iterator2.hasNext()) {
                    Designate designate = iterator2.next();
                    if (designate.isFactory()) {
                        this._allFPidOCDs.put(designate.getFactoryPid(), designate.getObjectClassDefinition());
                        continue;
                    }
                    this._allPidOCDs.put(designate.getPid(), designate.getObjectClassDefinition());
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public ObjectClassDefinition getObjectClassDefinition(String pid, String locale) {
        if (this.isInvalidLocale(locale)) {
            throw new IllegalArgumentException(NLS.bind((String)MetaTypeMsg.ASK_INVALID_LOCALE, (Object)pid, (Object)locale));
        }
        if (this._allPidOCDs.containsKey(pid)) {
            ObjectClassDefinitionImpl ocd = (ObjectClassDefinitionImpl)this._allPidOCDs.get(pid).clone();
            ocd.setResourceBundle(locale, this._bundle);
            return ocd;
        }
        if (this._allFPidOCDs.containsKey(pid)) {
            ObjectClassDefinitionImpl ocd = (ObjectClassDefinitionImpl)this._allFPidOCDs.get(pid).clone();
            ocd.setResourceBundle(locale, this._bundle);
            return ocd;
        }
        throw new IllegalArgumentException(NLS.bind((String)MetaTypeMsg.OCD_ID_NOT_FOUND, (Object)pid));
    }

    public boolean isInvalidLocale(String locale) {
        if (locale == null || locale.length() == 0) {
            return false;
        }
        int idx_first = locale.indexOf(95);
        int idx_second = locale.lastIndexOf(95);
        if (idx_first == -1 && locale.length() == 2) {
            return false;
        }
        return idx_first != 2 || idx_second != 5 && idx_second != 2;
    }

    public synchronized String[] getLocales() {
        ObjectClassDefinitionImpl ocd;
        BundleWiring wiring;
        if (this._locales != null) {
            return this.checkForDefault(this._locales);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.framework.wiring.BundleWiring");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((wiring = (BundleWiring)this._bundle.adapt((Class)clazz)) == null) {
            return null;
        }
        Vector<String> localizationFiles = new Vector<String>(7);
        Enumeration<ObjectClassDefinitionImpl> ocds = this._allPidOCDs.elements();
        while (ocds.hasMoreElements()) {
            ocd = ocds.nextElement();
            if (ocd._localization == null || localizationFiles.contains(ocd._localization)) continue;
            localizationFiles.add(ocd._localization);
        }
        ocds = this._allFPidOCDs.elements();
        while (ocds.hasMoreElements()) {
            ocd = ocds.nextElement();
            if (ocd._localization == null || localizationFiles.contains(ocd._localization)) continue;
            localizationFiles.add(ocd._localization);
        }
        if (localizationFiles.size() == 0) {
            localizationFiles.add(MetaTypeProviderImpl.getBundleLocalization(this._bundle));
        }
        Vector<String> locales = new Vector<String>(7);
        Enumeration eLocalizationFiles = localizationFiles.elements();
        while (eLocalizationFiles.hasMoreElements()) {
            String localizationFile = (String)eLocalizationFiles.nextElement();
            int iSlash = localizationFile.lastIndexOf(47);
            String baseDir = iSlash < 0 ? "" : localizationFile.substring(0, iSlash);
            String baseFileName = String.valueOf('/') + localizationFile + RESOURCE_FILE_CONN;
            List entries = wiring.findEntries(baseDir, "*.properties", 0);
            if (entries == null) continue;
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                URL entry = (URL)iterator.next();
                String resource = entry.getPath();
                if (!resource.startsWith(baseFileName) || !resource.toLowerCase().endsWith(RESOURCE_FILE_EXT)) continue;
                locales.add(resource.substring(baseFileName.length(), resource.length() - RESOURCE_FILE_EXT.length()));
            }
        }
        this._locales = locales.toArray(new String[locales.size()]);
        return this.checkForDefault(this._locales);
    }

    static String getBundleLocalization(Bundle bundle) {
        String baseName = (String)bundle.getHeaders("").get("Bundle-Localization");
        if (baseName == null) {
            baseName = "OSGI-INF/l10n/bundle";
        }
        return baseName;
    }

    private String[] checkForDefault(String[] locales) {
        if (locales == null || locales.length == 0 || locales.length == 1 && Locale.getDefault().toString().equals(locales[0])) {
            return null;
        }
        return locales;
    }
}

