/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.hooks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.service.weaving.ISupplementerRegistry;
import org.eclipse.equinox.service.weaving.Supplementer;
import org.eclipse.equinox.weaving.hooks.AbstractWeavingHook;
import org.eclipse.equinox.weaving.hooks.IAdaptorProvider;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupplementerRegistry
implements ISupplementerRegistry {
    public static final String SUPPLEMENT_BUNDLE = "Eclipse-SupplementBundle";
    public static final String SUPPLEMENT_EXPORTER = "Eclipse-SupplementExporter";
    public static final String SUPPLEMENT_IMPORTER = "Eclipse-SupplementImporter";
    private final IAdaptorProvider adaptorProvider;
    private BundleContext context;
    private final Set<String> dontWeaveTheseBundles;
    private PackageAdmin packageAdmin;
    private final Map<String, Supplementer> supplementers;
    private final Map<Long, Supplementer[]> supplementersByBundle;

    public SupplementerRegistry(IAdaptorProvider adaptorProvider) {
        this.adaptorProvider = adaptorProvider;
        this.supplementers = new HashMap<String, Supplementer>();
        this.supplementersByBundle = new HashMap<Long, Supplementer[]>();
        this.dontWeaveTheseBundles = new HashSet<String>();
        this.dontWeaveTheseBundles.add("org.eclipse.osgi");
        this.dontWeaveTheseBundles.add("org.eclipse.update.configurator");
        this.dontWeaveTheseBundles.add("org.eclipse.core.runtime");
        this.dontWeaveTheseBundles.add("org.eclipse.equinox.common");
        this.dontWeaveTheseBundles.add("org.eclipse.equinox.weaving.hook");
        this.dontWeaveTheseBundles.add("org.eclipse.equinox.weaving.aspectj");
        this.dontWeaveTheseBundles.add("org.eclipse.equinox.weaving.caching");
        this.dontWeaveTheseBundles.add("org.eclipse.equinox.weaving.caching.j9");
        this.dontWeaveTheseBundles.add("org.aspectj.runtime");
        this.dontWeaveTheseBundles.add("org.aspectj.weaver");
        this.dontWeaveTheseBundles.add("org.eclipse.equinox.simpleconfigurator");
    }

    @Override
    public void addBundle(Bundle bundle) {
        this.addSupplementedBundle(bundle);
        this.addSupplementer(bundle, true);
    }

    @Override
    public void addSupplementedBundle(Bundle bundle) {
        try {
            Dictionary manifest = bundle.getHeaders();
            ManifestElement[] imports = ManifestElement.parseHeader((String)"Import-Package", (String)((String)manifest.get("Import-Package")));
            ManifestElement[] exports = ManifestElement.parseHeader((String)"Export-Package", (String)((String)manifest.get("Export-Package")));
            List<Supplementer> supplementers = this.getMatchingSupplementers(bundle.getSymbolicName(), imports, exports);
            if (supplementers.size() > 0) {
                this.addSupplementedBundle(bundle, supplementers);
            }
            this.supplementersByBundle.put(bundle.getBundleId(), supplementers.toArray(new Supplementer[supplementers.size()]));
        }
        catch (BundleException bundleException) {}
    }

    @Override
    public void addSupplementer(Bundle bundle, boolean updateBundles) {
        try {
            Dictionary manifest = bundle.getHeaders();
            ManifestElement[] supplementBundle = ManifestElement.parseHeader((String)SUPPLEMENT_BUNDLE, (String)((String)manifest.get(SUPPLEMENT_BUNDLE)));
            ManifestElement[] supplementImporter = ManifestElement.parseHeader((String)SUPPLEMENT_IMPORTER, (String)((String)manifest.get(SUPPLEMENT_IMPORTER)));
            ManifestElement[] supplementExporter = ManifestElement.parseHeader((String)SUPPLEMENT_EXPORTER, (String)((String)manifest.get(SUPPLEMENT_EXPORTER)));
            if (supplementBundle != null || supplementImporter != null || supplementExporter != null) {
                Bundle[] hosts = this.packageAdmin.getHosts(bundle);
                Bundle host = hosts != null && hosts.length == 1 ? hosts[0] : null;
                Supplementer newSupplementer = new Supplementer(bundle, host, supplementBundle, supplementImporter, supplementExporter);
                this.supplementers.put(bundle.getSymbolicName(), newSupplementer);
                if (updateBundles) {
                    this.resupplementInstalledBundles(newSupplementer);
                }
            }
        }
        catch (BundleException bundleException) {}
    }

    @Override
    public List<Supplementer> getMatchingSupplementers(String symbolicName, ManifestElement[] imports, ManifestElement[] exports) {
        List<Supplementer> result = Collections.emptyList();
        if (this.supplementers.size() > 0 && !this.dontWeaveTheseBundles.contains(symbolicName)) {
            result = new LinkedList<Supplementer>();
            for (Supplementer supplementer : this.supplementers.values()) {
                if (!this.isSupplementerMatching(symbolicName, imports, exports, supplementer)) continue;
                result.add(supplementer);
            }
        }
        return result;
    }

    @Override
    public PackageAdmin getPackageAdmin() {
        return this.packageAdmin;
    }

    @Override
    public Supplementer[] getSupplementers(Bundle bundle) {
        return this.getSupplementers(bundle.getBundleId());
    }

    @Override
    public Supplementer[] getSupplementers(long bundleID) {
        if (this.supplementersByBundle.containsKey(bundleID)) {
            return this.supplementersByBundle.get(bundleID);
        }
        return new Supplementer[0];
    }

    @Override
    public void refreshBundles(Bundle[] bundles) {
        if (this.packageAdmin != null) {
            if (AbstractWeavingHook.verbose) {
                int i = 0;
                while (i < bundles.length) {
                    System.out.println("refresh bundle: " + bundles[i].getSymbolicName());
                    ++i;
                }
            }
            this.packageAdmin.refreshPackages(bundles);
        }
    }

    @Override
    public void removeBundle(Bundle bundle) {
        this.removeSupplementedBundle(bundle);
        this.supplementersByBundle.remove(bundle.getBundleId());
        this.adaptorProvider.resetAdaptor(bundle.getBundleId());
        if (this.supplementers.containsKey(bundle.getSymbolicName())) {
            Bundle[] supplementedBundles;
            Supplementer supplementer = this.supplementers.get(bundle.getSymbolicName());
            this.supplementers.remove(bundle.getSymbolicName());
            if (AbstractWeavingHook.verbose) {
                System.err.println("[org.eclipse.equinox.weaving.hook] info removing supplementer " + bundle.getSymbolicName());
            }
            if ((supplementedBundles = supplementer.getSupplementedBundles()) != null && supplementedBundles.length > 0) {
                ArrayList<Bundle> bundlesToRefresh = new ArrayList<Bundle>(supplementedBundles.length);
                Bundle[] bundleArray = supplementedBundles;
                int n = supplementedBundles.length;
                int n2 = 0;
                while (n2 < n) {
                    Bundle bundleToRefresh = bundleArray[n2];
                    if (this.adaptorProvider.getAdaptor(bundleToRefresh.getBundleId()) != null) {
                        bundlesToRefresh.add(bundleToRefresh);
                    }
                    ++n2;
                }
                if (bundlesToRefresh.size() > 0) {
                    this.refreshBundles(bundlesToRefresh.toArray(new Bundle[bundlesToRefresh.size()]));
                }
            }
            int i = 0;
            while (i < supplementedBundles.length) {
                long bundleId = supplementedBundles[i].getBundleId();
                ArrayList<Supplementer> supplementerList = new ArrayList<Supplementer>(Arrays.asList(this.supplementersByBundle.get(bundleId)));
                supplementerList.remove(supplementer);
                this.supplementersByBundle.put(bundleId, supplementerList.toArray(new Supplementer[0]));
                ++i;
            }
        }
    }

    @Override
    public void setBundleContext(BundleContext context) {
        this.context = context;
    }

    @Override
    public void setPackageAdmin(PackageAdmin packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    private void addSupplementedBundle(Bundle supplementedBundle, List<Supplementer> supplementers) {
        for (Supplementer supplementer : supplementers) {
            supplementer.addSupplementedBundle(supplementedBundle);
        }
    }

    private boolean isSupplementerMatching(String symbolicName, ManifestElement[] imports, ManifestElement[] exports, Supplementer supplementer) {
        String supplementerName = supplementer.getSymbolicName();
        return !supplementerName.equals(symbolicName) && (supplementer.matchSupplementer(symbolicName) || imports != null && supplementer.matchesSupplementImporter(imports) || exports != null && supplementer.matchesSupplementExporter(exports));
    }

    private void removeSupplementedBundle(Bundle bundle) {
        for (Supplementer supplementer : this.supplementers.values()) {
            supplementer.removeSupplementedBundle(bundle);
        }
    }

    private void resupplementInstalledBundles(Supplementer supplementer) {
        Bundle[] installedBundles = this.context.getBundles();
        ArrayList<Bundle> bundlesToRefresh = new ArrayList<Bundle>();
        int i = 0;
        while (i < installedBundles.length) {
            try {
                Bundle bundle = installedBundles[i];
                if (!bundle.getSymbolicName().equals(supplementer.getSymbolicName()) && !this.dontWeaveTheseBundles.contains(bundle.getSymbolicName())) {
                    Dictionary manifest = bundle.getHeaders();
                    ManifestElement[] imports = ManifestElement.parseHeader((String)"Import-Package", (String)((String)manifest.get("Import-Package")));
                    ManifestElement[] exports = ManifestElement.parseHeader((String)"Export-Package", (String)((String)manifest.get("Export-Package")));
                    if (this.isSupplementerMatching(bundle.getSymbolicName(), imports, exports, supplementer)) {
                        if (this.adaptorProvider.getAdaptor(bundle.getBundleId()) != null) {
                            bundlesToRefresh.add(bundle);
                        } else {
                            supplementer.addSupplementedBundle(bundle);
                            Supplementer[] existingSupplementers = this.supplementersByBundle.get(bundle.getBundleId());
                            ArrayList<Object> enhancedSupplementerList = null;
                            enhancedSupplementerList = existingSupplementers != null ? new ArrayList<Supplementer>(Arrays.asList(existingSupplementers)) : new ArrayList();
                            if (!enhancedSupplementerList.contains(supplementer)) {
                                enhancedSupplementerList.add(supplementer);
                            }
                            this.supplementersByBundle.put(bundle.getBundleId(), enhancedSupplementerList.toArray(new Supplementer[0]));
                        }
                    }
                }
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
            ++i;
        }
        if (bundlesToRefresh.size() > 0) {
            Bundle[] bundles = bundlesToRefresh.toArray(new Bundle[bundlesToRefresh.size()]);
            this.refreshBundles(bundles);
        }
    }
}

