/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.util.manager;

import org.eclipse.epsilon.emc.simulink.model.IGenericSimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.SimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.TypeHelper;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkBlock;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkLine;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkPort;
import org.eclipse.epsilon.emc.simulink.model.element.StateflowBlock;
import org.eclipse.epsilon.emc.simulink.util.manager.AbstractManager;
import org.eclipse.epsilon.emc.simulink.util.manager.SimulinkBlockManager;
import org.eclipse.epsilon.emc.simulink.util.manager.SimulinkLineManager;
import org.eclipse.epsilon.emc.simulink.util.manager.SimulinkPortManager;
import org.eclipse.epsilon.emc.simulink.util.manager.StateflowBlockManager;

public class SimulinkElementManager
extends AbstractManager<ISimulinkModelElement, Object> {
    public SimulinkElementManager(SimulinkModel model) {
        super((IGenericSimulinkModel)model);
    }

    public ISimulinkModelElement construct(Object id) {
        TypeHelper.Kind kind = TypeHelper.getKind(this.getModel(), id);
        switch (kind) {
            case BLOCK: {
                return new SimulinkBlockManager(this.getModel()).construct((Double)id);
            }
            case LINE: {
                return new SimulinkLineManager(this.getModel()).construct((Double)id);
            }
            case PORT: {
                return new SimulinkPortManager(this.getModel()).construct((Double)id);
            }
            case STATEFLOW: {
                return new StateflowBlockManager(this.getModel()).construct((Double)id);
            }
        }
        return null;
    }

    public Object getId(ISimulinkModelElement from) {
        if (from instanceof StateflowBlock) {
            return new StateflowBlockManager(this.getModel()).getId((StateflowBlock)from);
        }
        if (from instanceof SimulinkLine) {
            return new SimulinkLineManager(this.getModel()).getId((SimulinkLine)from);
        }
        if (from instanceof SimulinkPort) {
            return new SimulinkPortManager(this.getModel()).getId((SimulinkPort)from);
        }
        if (from instanceof SimulinkBlock) {
            return new SimulinkBlockManager(this.getModel()).getId((SimulinkBlock)from);
        }
        return null;
    }

    public SimulinkModel getModel() {
        return (SimulinkModel)this.model;
    }
}

