/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor.mecontrols.multiattributecontrol;

import org.eclipse.emf.ecp.editor.mecontrols.multiattributecontrol.AttributeControl;
import org.eclipse.emf.ecp.editor.mecontrols.multiattributecontrol.IntegerMultiAttributeControl;
import org.eclipse.emf.ecp.editor.mecontrols.multiattributecontrol.MultiAttributeControl;
import org.eclipse.emf.ecp.editor.mecontrols.multiattributecontrol.MultiAttributeController;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IntegerAttributeControl
extends AttributeControl {
    private static final int SIZE_LIMIT = 10000000;
    private MultiAttributeController<Integer> dataManipulator;
    private Spinner widget;
    private Integer value;

    IntegerAttributeControl(MultiAttributeControl parentItem, MultiAttributeController<Integer> dataManipulator, int value) {
        this.setParentItem(parentItem);
        this.dataManipulator = dataManipulator;
        this.value = value;
        this.setIndex(parentItem.getControlList().size());
        parentItem.getControlList().add(this);
        this.createCompositeLayout();
        this.setWidget(new Spinner(this.getFieldComposite(), parentItem.getStyle() | 4));
        this.getWidget().setValues(value, -10000000, 10000000, 0, 1, 1);
        this.getWidget().addModifyListener((ModifyListener)this);
        this.createDeleteButton();
        this.createUpDownButtons();
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).applyTo((Control)this.getWidget());
    }

    IntegerAttributeControl(MultiAttributeControl parentItem, MultiAttributeController<Integer> dataManipulator) {
        this.setParentItem(parentItem);
        this.dataManipulator = dataManipulator;
        this.value = IntegerMultiAttributeControl.getEmptyValue();
        this.createCompositeLayout();
        this.setWidget(new Spinner(this.getFieldComposite(), parentItem.getStyle() | 4));
        this.getWidget().setValues(this.value.intValue(), -10000000, 10000000, 0, 1, 1);
        this.getWidget().addModifyListener((ModifyListener)this);
        this.getWidget().setForeground(new Color((Device)this.getWidget().getDisplay(), 100, 100, 100));
        this.createAddButton();
        this.createInvisibleUpDownButtons();
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).applyTo((Control)this.getWidget());
    }

    private IntegerAttributeControl() {
    }

    @Override
    protected boolean swapThisControlWith(int index) {
        if (index >= this.getParentItem().getControlList().size() || index < 0) {
            return false;
        }
        int random = 0;
        while (this.dataManipulator.contains(random)) {
            random = (int)(Math.random() * 10000.0);
        }
        int thisValue = this.value;
        int otherValue = ((IntegerAttributeControl)this.getParentItem().getControlList().get((int)index)).value;
        this.getWidget().setSelection(random);
        ((IntegerAttributeControl)this.getParentItem().getControlList().get(index)).getWidget().setSelection(thisValue);
        this.getWidget().setSelection(otherValue);
        return true;
    }

    @Override
    public void modifyText(ModifyEvent e) {
        if (e.getSource().equals(this.getWidget())) {
            if (this.getIndex() == -1) {
                this.getWidget().setForeground(new Color((Device)this.getWidget().getDisplay(), 0, 0, 0));
                this.getButton().dispose();
                this.createDeleteButton();
                this.createUpDownButtons();
            }
            int newValue = this.getWidget().getSelection();
            if (!this.getParentItem().isAllowDuplicates() && this.dataManipulator.contains(newValue)) {
                if (newValue > this.value) {
                    this.getWidget().setSelection(newValue + 1);
                } else {
                    this.getWidget().setSelection(newValue - 1);
                }
                return;
            }
            if (this.getIndex() != -1) {
                this.dataManipulator.replaceElementAt(this.getIndex(), newValue);
                this.value = newValue;
            } else {
                this.setIndex(this.getParentItem().getControlList().size());
                this.getParentItem().getControlList().add(this);
                this.dataManipulator.add(newValue);
                this.value = newValue;
                this.getButton().setVisible(true);
                if (!this.getParentItem().isFull()) {
                    this.getParentItem().createSingleField();
                }
                this.getFieldComposite().layout();
            }
            this.getParentItem().refreshWidget();
        }
    }

    @Override
    protected void addButtonFunctionality() {
        if (!this.getParentItem().isAllowDuplicates()) {
            while (this.dataManipulator.contains(this.value)) {
                this.value = this.value + 1;
            }
        }
        this.getWidget().setSelection(this.value.intValue());
        this.getWidget().setForeground(new Color((Device)this.getWidget().getDisplay(), 0, 0, 0));
        this.getButton().dispose();
        this.createDeleteButton();
        this.createUpDownButtons();
    }

    @Override
    protected boolean removeElementAt(int i) {
        return this.dataManipulator.removeElementAt(i);
    }

    public void setWidget(Spinner widget) {
        this.widget = widget;
    }

    public Spinner getWidget() {
        return this.widget;
    }
}

