/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.common.model.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.emfstore.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.common.model.ModelElementId;
import org.eclipse.emf.emfstore.common.model.ModelFactory;
import org.eclipse.emf.emfstore.common.model.impl.IdEObjectCollectionCopier;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IdEObjectCollectionImpl
extends EObjectImpl
implements IdEObjectCollection {
    private Map<EObject, String> eObjectToIdCache = new HashMap<EObject, String>();
    private Map<String, EObject> idToEObjectCache = new HashMap<String, EObject>();
    private boolean cachesInitialized;
    private Map<EObject, ModelElementId> deletedEObjectToIdMap = new HashMap<EObject, ModelElementId>();
    private Map<ModelElementId, EObject> deletedIdMapToEObject = new HashMap<ModelElementId, EObject>();
    private Map<EObject, ModelElementId> newEObjectToIdMap = new HashMap<EObject, ModelElementId>();
    private HashMap<ModelElementId, EObject> newIdMapToEObject = new HashMap();

    public IdEObjectCollectionImpl() {
    }

    public IdEObjectCollectionImpl(XMIResource xmiResource) throws IOException {
        this();
        boolean resourceHasIds = false;
        try {
            if (!xmiResource.isLoaded()) {
                xmiResource.load(null);
            }
        }
        catch (IOException e) {
            ModelUtil.logException(String.format("XMIResource %s could not be loaded.", xmiResource.getURI()), e);
            throw e;
        }
        TreeIterator it = xmiResource.getAllContents();
        while (it.hasNext()) {
            EObject eObject = (EObject)it.next();
            if (ModelUtil.isIgnoredDatatype(eObject)) continue;
            String id = xmiResource.getID(eObject);
            ModelElementId eObjectId = ModelFactory.eINSTANCE.createModelElementId();
            if (id != null) {
                eObjectId.setId(id);
                resourceHasIds = true;
            } else {
                xmiResource.setID(eObject, eObjectId.getId());
            }
            this.putIntoCaches(eObject, eObjectId.getId());
        }
        if (resourceHasIds) {
            this.cachesInitialized = true;
        }
        EList contents = xmiResource.getContents();
        this.setModelElements((EList<EObject>)contents);
        if (!resourceHasIds) {
            xmiResource.save(null);
        }
    }

    @Override
    public abstract Collection<EObject> getModelElements();

    protected abstract void setModelElements(EList<EObject> var1);

    @Override
    public void addModelElement(EObject eObject) {
        this.getModelElements().add(eObject);
    }

    @Override
    public void addModelElement(EObject newModelElement, Map<EObject, ModelElementId> map) {
        this.preAssignModelElementIds(map);
        this.getModelElements().add(newModelElement);
    }

    @Override
    public boolean containsInstance(EObject modelElement) {
        return this.getEObjectsCache().contains(modelElement);
    }

    public ModelElementId getDeletedModelElementId(EObject deletedModelElement) {
        ModelElementId id = this.deletedEObjectToIdMap.get(deletedModelElement);
        return id != null ? ModelUtil.clone(id) : ModelUtil.getSingletonModelElementId(deletedModelElement);
    }

    public EObject getDeletedModelElement(ModelElementId modelElementId) {
        if (modelElementId == null) {
            return null;
        }
        EObject eObject = this.deletedIdMapToEObject.get(modelElementId.getId());
        return eObject != null ? eObject : ModelUtil.getSingleton(modelElementId);
    }

    @Override
    public ModelElementId getModelElementId(EObject eObject) {
        if (!this.eObjectToIdCache.containsKey(eObject) && !this.isCacheInitialized()) {
            Resource resource;
            block5: {
                try {
                    resource = eObject.eResource();
                    if (resource instanceof XMIResource) break block5;
                    return null;
                }
                catch (IOException e) {
                    throw new RuntimeException("Couldn't load resource for model element " + eObject);
                }
            }
            XMIResource xmiResource = (XMIResource)resource;
            xmiResource.load(null);
            ModelElementId modelElementId = ModelFactory.eINSTANCE.createModelElementId();
            String id = xmiResource.getID(eObject);
            if (id != null) {
                modelElementId.setId(id);
            }
            this.eObjectToIdCache.put(eObject, modelElementId.getId());
            return modelElementId;
        }
        String id = this.eObjectToIdCache.get(eObject);
        ModelElementId modelElementId = ModelFactory.eINSTANCE.createModelElementId();
        modelElementId.setId(id);
        return id != null ? modelElementId : ModelUtil.getSingletonModelElementId(eObject);
    }

    @Override
    public EObject getModelElement(ModelElementId modelElementId) {
        EObject eObject;
        if (modelElementId == null) {
            return null;
        }
        if (!this.isCacheInitialized()) {
            this.initCaches();
        }
        return (eObject = this.getIdToEObjectCache().get(modelElementId.getId())) != null ? eObject : ModelUtil.getSingleton(modelElementId);
    }

    @Override
    public void deleteModelElement(EObject modelElement) {
        if (!this.containsInstance(modelElement)) {
            throw new IllegalArgumentException("Cannot delete a model element that is not contained in this project.");
        }
        ModelUtil.deleteOutgoingCrossReferences(this, modelElement);
        Collection crossReferences = EcoreUtil.UsageCrossReferencer.find((EObject)modelElement, (EObject)this);
        ModelUtil.deleteIncomingCrossReferencesFromParent(crossReferences, modelElement);
        EObject containerModelElement = ModelUtil.getContainerModelElement(modelElement);
        if (containerModelElement == null) {
            this.getModelElements().remove(modelElement);
        } else {
            EReference containmentFeature = modelElement.eContainmentFeature();
            if (containmentFeature.isMany()) {
                EList containmentList = (EList)containerModelElement.eGet((EStructuralFeature)containmentFeature);
                containmentList.remove((Object)modelElement);
            } else {
                containerModelElement.eSet((EStructuralFeature)containmentFeature, null);
            }
            this.removeModelElementAndChildrenFromResource(modelElement);
        }
    }

    public void removeModelElementAndChildrenFromResource(EObject eObject) {
        Set<EObject> children = ModelUtil.getAllContainedModelElements(eObject, false);
        for (EObject child : children) {
            this.removeModelElementFromResource(child);
        }
        this.removeModelElementFromResource(eObject);
    }

    private void removeModelElementFromResource(EObject eObject) {
        if (!(eObject.eResource() instanceof XMIResource)) {
            return;
        }
        XMIResource xmiResource = (XMIResource)eObject.eResource();
        if (xmiResource.getURI() == null) {
            return;
        }
        xmiResource.setID(eObject, null);
        try {
            xmiResource.save(null);
        }
        catch (IOException e) {
            throw new RuntimeException("XMI Resource for model element " + eObject + " could not be saved. " + "Reason: " + e.getMessage());
        }
    }

    private ModelElementId getIdForModelElement(EObject modelElement) {
        Resource resource = modelElement.eResource();
        if (resource != null && resource instanceof XMIResource) {
            XMIResource xmiResource = (XMIResource)resource;
            try {
                xmiResource.load(null);
            }
            catch (IOException e) {
                throw new RuntimeException("Resource of model element " + modelElement + " couldn't be loaded");
            }
            String id = xmiResource.getID(modelElement);
            if (id != null) {
                ModelElementId objId = ModelFactory.eINSTANCE.createModelElementId();
                objId.setId(id);
                return objId;
            }
        }
        return ModelFactory.eINSTANCE.createModelElementId();
    }

    @Override
    public Set<EObject> getAllModelElements() {
        if (!this.isCacheInitialized()) {
            this.initCaches();
        }
        return this.eObjectToIdCache.keySet();
    }

    @Override
    public <T extends EObject> EList<T> getAllModelElementsbyClass(EClass modelElementClass, EList<T> list) {
        return this.getAllModelElementsbyClass(modelElementClass, list, true);
    }

    @Override
    public <T extends EObject> EList<T> getModelElementsByClass(EClass modelElementClass, EList<T> list) {
        for (EObject modelElement : this.getModelElements()) {
            if (!modelElementClass.isInstance((Object)modelElement)) continue;
            list.add((Object)modelElement);
        }
        return list;
    }

    @Override
    public <T extends EObject> EList<T> getAllModelElementsbyClass(EClass modelElementClass, EList<T> list, Boolean subclasses) {
        if (subclasses.booleanValue()) {
            for (EObject modelElement : this.getAllModelElements()) {
                if (!modelElementClass.isInstance((Object)modelElement)) continue;
                list.add((Object)modelElement);
            }
        } else {
            for (EObject modelElement : this.getAllModelElements()) {
                if (modelElement.eClass() != modelElementClass) continue;
                list.add((Object)modelElement);
            }
        }
        return list;
    }

    protected boolean isCacheInitialized() {
        return this.cachesInitialized;
    }

    @Override
    public boolean contains(ModelElementId id) {
        if (!this.isCacheInitialized()) {
            this.initCaches();
        }
        return this.getIdToEObjectCache().containsKey(id);
    }

    protected Map<String, EObject> getIdToEObjectCache() {
        if (!this.isCacheInitialized()) {
            this.initCaches();
        }
        return this.idToEObjectCache;
    }

    protected Set<EObject> getEObjectsCache() {
        if (!this.isCacheInitialized()) {
            this.initCaches();
        }
        return this.eObjectToIdCache.keySet();
    }

    @Override
    public void initCaches() {
        if (this.isCacheInitialized()) {
            return;
        }
        for (EObject modelElement : this.getModelElements()) {
            ModelElementId modelElementId = this.getIdForModelElement(modelElement);
            this.putIntoCaches(modelElement, modelElementId.getId());
            TreeIterator it = modelElement.eAllContents();
            while (it.hasNext()) {
                EObject obj = (EObject)it.next();
                ModelElementId id = this.getIdForModelElement(obj);
                this.putIntoCaches(obj, id.getId());
            }
        }
        this.cachesInitialized = true;
    }

    protected void addModelElementAndChildrenToCache(EObject modelElement) {
        EObject eObject;
        HashSet<ModelElementId> removableIds = new HashSet<ModelElementId>();
        ModelElementId id = this.newEObjectToIdMap.get(modelElement);
        if (id == null) {
            id = ModelFactory.eINSTANCE.createModelElementId();
        } else {
            removableIds.add(id);
        }
        if (this.isCacheInitialized()) {
            this.putIntoCaches(modelElement, id.getId());
        }
        for (EObject child : ModelUtil.getAllContainedModelElements(modelElement, false)) {
            ModelElementId childId = this.newEObjectToIdMap.get(child);
            if (childId == null) {
                childId = ModelFactory.eINSTANCE.createModelElementId();
            } else {
                removableIds.add(childId);
            }
            if (!this.isCacheInitialized()) continue;
            this.putIntoCaches(child, childId.getId());
        }
        for (ModelElementId modelElementId : removableIds) {
            eObject = this.newIdMapToEObject.get(modelElementId);
            this.newEObjectToIdMap.remove(eObject);
        }
        this.newIdMapToEObject.keySet().removeAll(removableIds);
        for (ModelElementId modelElementId : removableIds) {
            eObject = this.deletedIdMapToEObject.get(modelElementId);
            this.deletedEObjectToIdMap.remove(eObject);
        }
        this.deletedIdMapToEObject.keySet().removeAll(removableIds);
    }

    @Override
    public void initCaches(Map<EObject, String> eObjectToIdMap, Map<String, EObject> idToEObjectMap) {
        this.cachesInitialized = true;
        this.eObjectToIdCache = eObjectToIdMap;
        this.idToEObjectCache = idToEObjectMap;
    }

    protected void putIntoCaches(EObject modelElement, String modelElementId) {
        this.eObjectToIdCache.put(modelElement, modelElementId);
        this.idToEObjectCache.put(modelElementId, modelElement);
    }

    public <T extends IdEObjectCollection> T copy() {
        IdEObjectCollectionCopier copier = new IdEObjectCollectionCopier();
        IdEObjectCollection result = (IdEObjectCollection)copier.copy(this);
        ((IdEObjectCollectionImpl)result).cachesInitialized = true;
        copier.copyReferences();
        return (T)result;
    }

    @Override
    public void dispose() {
        this.eObjectToIdCache.clear();
        this.idToEObjectCache.clear();
        this.clearVolatileCaches();
        this.cachesInitialized = false;
    }

    protected void removeModelElementAndChildrenFromCache(EObject modelElement) {
        if (this.deletedEObjectToIdMap.containsKey(modelElement)) {
            return;
        }
        this.removeFromCaches(modelElement);
        for (EObject child : ModelUtil.getAllContainedModelElements(modelElement, false)) {
            this.removeFromCaches(child);
        }
    }

    private void removeFromCaches(EObject modelElement) {
        if (this.isCacheInitialized()) {
            ModelElementId id = this.getModelElementId(modelElement);
            this.deletedEObjectToIdMap.put(modelElement, id);
            this.deletedIdMapToEObject.put(id, modelElement);
            this.newEObjectToIdMap.put(modelElement, id);
            this.newIdMapToEObject.put(id, modelElement);
            this.getEObjectsCache().remove(modelElement);
            this.getIdToEObjectCache().remove(id.getId());
        }
    }

    @Override
    public void preAssignModelElementIds(Map<EObject, ModelElementId> eObjectToIdMap) {
        for (Map.Entry<EObject, ModelElementId> entry : eObjectToIdMap.entrySet()) {
            EObject modelElement = entry.getKey();
            ModelElementId modelElementId = entry.getValue();
            Boolean isAlreadyContained = this.getModelElement(modelElementId) != null;
            if (isAlreadyContained.booleanValue()) {
                this.eObjectToIdCache.put(modelElement, modelElementId.getId());
                this.idToEObjectCache.put(modelElementId.getId(), modelElement);
            }
            this.newEObjectToIdMap.put(modelElement, modelElementId);
            this.newIdMapToEObject.put(modelElementId, modelElement);
        }
    }

    public void clearVolatileCaches() {
        this.deletedEObjectToIdMap.clear();
        this.deletedIdMapToEObject.clear();
        this.newEObjectToIdMap.clear();
        this.newIdMapToEObject.clear();
    }

    public Map<String, EObject> getIdToEObjectMap() {
        return new HashMap<String, EObject>(this.idToEObjectCache);
    }

    public Map<EObject, String> getEObjectToIdMap() {
        return new HashMap<EObject, String>(this.eObjectToIdCache);
    }
}

