/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.model.url.impl;

import java.net.MalformedURLException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.emfstore.common.model.ModelElementId;
import org.eclipse.emf.emfstore.server.model.ModelFactory;
import org.eclipse.emf.emfstore.server.model.ProjectId;
import org.eclipse.emf.emfstore.server.model.url.ModelElementUrl;
import org.eclipse.emf.emfstore.server.model.url.ModelElementUrlFragment;
import org.eclipse.emf.emfstore.server.model.url.ProjectUrlFragment;
import org.eclipse.emf.emfstore.server.model.url.ServerUrl;
import org.eclipse.emf.emfstore.server.model.url.UrlFactory;
import org.eclipse.emf.emfstore.server.model.url.UrlPackage;
import org.eclipse.emf.emfstore.server.model.url.impl.ModelElementUrlFragmentImpl;
import org.eclipse.emf.emfstore.server.model.url.impl.ModelElementUrlImpl;
import org.eclipse.emf.emfstore.server.model.url.impl.ProjectUrlFragmentImpl;
import org.eclipse.emf.emfstore.server.model.url.impl.ServerUrlImpl;

public class UrlFactoryImpl
extends EFactoryImpl
implements UrlFactory {
    public static final String PREFIX = "emfstore://";
    private static final String EXCEPTION_MESSAGE = "Invalid EMFStore URL!";

    public static UrlFactory init() {
        try {
            UrlFactory theUrlFactory = (UrlFactory)EPackage.Registry.INSTANCE.getEFactory("http://eclipse.org/emf/emfstore/server/model/url");
            if (theUrlFactory != null) {
                return theUrlFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new UrlFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createServerUrl();
            }
            case 1: {
                return this.createProjectUrlFragment();
            }
            case 2: {
                return this.createModelElementUrlFragment();
            }
            case 3: {
                return this.createModelElementUrl();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public ServerUrl createServerUrl() {
        ServerUrlImpl serverUrl = new ServerUrlImpl();
        return serverUrl;
    }

    public ProjectUrlFragment createProjectUrlFragment() {
        ProjectUrlFragmentImpl projectUrlFragment = new ProjectUrlFragmentImpl();
        return projectUrlFragment;
    }

    public ModelElementUrlFragment createModelElementUrlFragment() {
        ModelElementUrlFragmentImpl modelElementUrlFragment = new ModelElementUrlFragmentImpl();
        return modelElementUrlFragment;
    }

    public ModelElementUrl createModelElementUrl(String url) throws MalformedURLException {
        ModelElementUrl modelURL = this.createModelElementUrl();
        ModelElementUrlFragment modelFragment = this.createModelElementUrlFragment();
        ProjectUrlFragment projectFragment = this.createProjectUrlFragment();
        ServerUrl serverFragment = this.createServerUrl();
        modelURL.setModelElementUrlFragment(modelFragment);
        modelURL.setProjectUrlFragment(projectFragment);
        modelURL.setServerUrl(serverFragment);
        if (url.startsWith(PREFIX)) {
            String text;
            String[] elements;
            int trail = 0;
            if (url.endsWith("/")) {
                trail = 1;
            }
            if ((elements = (text = url.substring(PREFIX.length(), url.length() - trail)).split("/")).length >= 3) {
                String[] server = elements[0].split(":");
                if (server.length != 2) {
                    throw new MalformedURLException(EXCEPTION_MESSAGE);
                }
                serverFragment.setHostName(server[0]);
                try {
                    serverFragment.setPort(Integer.parseInt(server[1]));
                }
                catch (NumberFormatException e) {
                    throw new MalformedURLException(EXCEPTION_MESSAGE);
                }
                String[] project = elements[1].split("%");
                if (project.length != 2) {
                    throw new MalformedURLException(EXCEPTION_MESSAGE);
                }
                projectFragment.setName(project[0]);
                ProjectId projectId = ModelFactory.eINSTANCE.createProjectId();
                projectId.setId(project[1]);
                projectFragment.setProjectId(projectId);
                StringBuilder model = new StringBuilder();
                int i = 2;
                while (i < elements.length) {
                    model.append(elements[i]);
                    ++i;
                }
                String string = model.toString();
                int p = string.lastIndexOf("%");
                if (p == -1) {
                    throw new MalformedURLException(EXCEPTION_MESSAGE);
                }
                modelFragment.setName(string.substring(0, p));
                ModelElementId modelElementId = org.eclipse.emf.emfstore.common.model.ModelFactory.eINSTANCE.createModelElementId();
                modelElementId.setId(string.substring(p + 1));
                modelFragment.setModelElementId(modelElementId);
            }
        }
        return modelURL;
    }

    public ModelElementUrl createModelElementUrl() {
        ModelElementUrlImpl modelElementUrl = new ModelElementUrlImpl();
        return modelElementUrl;
    }

    public UrlPackage getUrlPackage() {
        return (UrlPackage)this.getEPackage();
    }

    @Deprecated
    public static UrlPackage getPackage() {
        return UrlPackage.eINSTANCE;
    }
}

