/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.common.extensionpoint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.emfstore.common.Activator;
import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionPointException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionPoint {
    private List<ExtensionElement> elements;
    private final String id;
    private boolean exceptionInsteadOfNull;
    private Comparator<ExtensionElement> comparator;

    public ExtensionPoint(String id) {
        this(id, false);
    }

    public ExtensionPoint(String id, boolean throwException) {
        this.id = id;
        this.exceptionInsteadOfNull = throwException;
        this.comparator = this.getDefaultComparator();
        this.reload();
    }

    public void reload() {
        this.elements = new ArrayList<ExtensionElement>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(this.id);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            this.elements.add(new ExtensionElement(element, this.exceptionInsteadOfNull));
            ++n2;
        }
        Collections.sort(this.elements, this.comparator);
    }

    protected Comparator<ExtensionElement> getDefaultComparator() {
        return new Comparator<ExtensionElement>(){

            @Override
            public int compare(ExtensionElement o1, ExtensionElement o2) {
                return 0;
            }
        };
    }

    public <T> T getClass(String class_id, Class<T> returnType) {
        ExtensionElement first = this.getElementWithHighestPriority();
        if (first != null) {
            return first.getClass(class_id, returnType);
        }
        return (T)ExtensionPoint.handleErrorOrNull(this.exceptionInsteadOfNull, null);
    }

    public Boolean getBoolean(String name) {
        ExtensionElement element = this.getElementWithHighestPriority();
        if (element != null) {
            return element.getBoolean(name);
        }
        return (Boolean)ExtensionPoint.handleErrorOrNull(this.exceptionInsteadOfNull, null);
    }

    public Integer getInteger(String name) {
        ExtensionElement element = this.getElementWithHighestPriority();
        if (element != null) {
            return element.getInteger(name);
        }
        return (Integer)ExtensionPoint.handleErrorOrNull(this.exceptionInsteadOfNull, null);
    }

    public String getAttribute(String name) {
        ExtensionElement element = this.getElementWithHighestPriority();
        if (element != null) {
            return element.getAttribute(name);
        }
        return (String)ExtensionPoint.handleErrorOrNull(this.exceptionInsteadOfNull, null);
    }

    public ExtensionElement getElementWithHighestPriority() {
        return this.getFirst();
    }

    public void setComparator(Comparator<ExtensionElement> comparator) {
        this.comparator = comparator;
    }

    public ExtensionElement getFirst() {
        if (this.elements.size() > 0) {
            return this.elements.get(0);
        }
        return (ExtensionElement)ExtensionPoint.handleErrorOrNull(this.exceptionInsteadOfNull, null);
    }

    public List<ExtensionElement> getExtensionElements() {
        return Collections.unmodifiableList(this.elements);
    }

    public ExtensionPoint setThrowException(boolean b) {
        this.exceptionInsteadOfNull = b;
        return this;
    }

    protected static Object handleErrorOrNull(boolean useException, Exception expOrNull) {
        if (useException) {
            if (expOrNull == null) {
                throw new ExtensionPointException("Value not found.");
            }
            ExtensionPoint.logException(expOrNull);
            throw new ExtensionPointException(expOrNull);
        }
        return null;
    }

    protected static void logException(Exception e) {
        Activator.getDefault().logException("An exception occurred while using an ExtensionPoint", e);
    }

    public int size() {
        return this.elements.size();
    }
}

