/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.impl;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.emfstore.client.model.AdminBroker;
import org.eclipse.emf.emfstore.client.model.Configuration;
import org.eclipse.emf.emfstore.client.model.ModelFactory;
import org.eclipse.emf.emfstore.client.model.ModelPackage;
import org.eclipse.emf.emfstore.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.client.model.ServerInfo;
import org.eclipse.emf.emfstore.client.model.Usersession;
import org.eclipse.emf.emfstore.client.model.Workspace;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.client.model.connectionmanager.ConnectionManager;
import org.eclipse.emf.emfstore.client.model.connectionmanager.ServerCall;
import org.eclipse.emf.emfstore.client.model.exceptions.ProjectUrlResolutionException;
import org.eclipse.emf.emfstore.client.model.exceptions.ServerUrlResolutionException;
import org.eclipse.emf.emfstore.client.model.exceptions.UnkownProjectException;
import org.eclipse.emf.emfstore.client.model.impl.AdminBrokerImpl;
import org.eclipse.emf.emfstore.client.model.impl.ProjectSpaceBase;
import org.eclipse.emf.emfstore.client.model.importexport.impl.ExportProjectSpaceController;
import org.eclipse.emf.emfstore.client.model.importexport.impl.ExportWorkspaceController;
import org.eclipse.emf.emfstore.client.model.observers.CheckoutObserver;
import org.eclipse.emf.emfstore.client.model.observers.DeleteProjectSpaceObserver;
import org.eclipse.emf.emfstore.client.model.util.ResourceHelper;
import org.eclipse.emf.emfstore.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.common.model.Project;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.common.observer.IObserver;
import org.eclipse.emf.emfstore.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.exceptions.InvalidVersionSpecException;
import org.eclipse.emf.emfstore.server.model.ProjectId;
import org.eclipse.emf.emfstore.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.server.model.url.ProjectUrlFragment;
import org.eclipse.emf.emfstore.server.model.url.ServerUrl;
import org.eclipse.emf.emfstore.server.model.versioning.DateVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.server.model.versioning.HistoryQuery;
import org.eclipse.emf.emfstore.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.VersioningFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceImpl
extends EObjectImpl
implements Workspace {
    private ConnectionManager connectionManager;
    protected EList<ProjectSpace> projectSpaces;
    private Map<Project, ProjectSpace> projectToProjectSpaceMap;
    protected EList<ServerInfo> serverInfos;
    protected EList<Usersession> usersessions;
    private ResourceSet workspaceResourceSet;

    protected WorkspaceImpl() {
    }

    public void addProjectSpace(ProjectSpace projectSpace) {
        this.getProjectSpaces().add((Object)projectSpace);
        this.projectToProjectSpaceMap.put(projectSpace.getProject(), projectSpace);
    }

    @Override
    public ProjectSpace checkout(Usersession usersession, ProjectInfo projectInfo) throws EmfStoreException {
        PrimaryVersionSpec targetSpec = this.connectionManager.resolveVersionSpec(usersession.getSessionId(), projectInfo.getProjectId(), VersionSpec.HEAD_VERSION);
        return this.checkout(usersession, projectInfo, targetSpec);
    }

    @Override
    public ProjectSpace checkout(Usersession usersession, ProjectInfo projectInfo, PrimaryVersionSpec targetSpec) throws EmfStoreException {
        ProjectInfo projectInfoCopy = (ProjectInfo)ModelUtil.clone((EObject)projectInfo);
        projectInfoCopy.setVersion(targetSpec);
        Project project = this.connectionManager.getProject(usersession.getSessionId(), projectInfo.getProjectId(), (VersionSpec)projectInfoCopy.getVersion());
        if (project == null) {
            throw new EmfStoreException("Server returned a null project!");
        }
        PrimaryVersionSpec primaryVersionSpec = projectInfoCopy.getVersion();
        ProjectSpace projectSpace = ModelFactory.eINSTANCE.createProjectSpace();
        projectSpace.setProjectId(projectInfo.getProjectId());
        projectSpace.setProjectName(projectInfo.getName());
        projectSpace.setProjectDescription(projectInfo.getDescription());
        projectSpace.setBaseVersion(primaryVersionSpec);
        projectSpace.setLastUpdated(new Date());
        projectSpace.setUsersession(usersession);
        WorkspaceManager.getObserverBus().register((IObserver)((ProjectSpaceBase)projectSpace));
        projectSpace.setProject(project);
        projectSpace.setResourceCount(0);
        projectSpace.setLocalOperations(ModelFactory.eINSTANCE.createOperationComposite());
        projectSpace.initResources(this.workspaceResourceSet);
        try {
            DateVersionSpec dateVersionSpec = VersioningFactory.eINSTANCE.createDateVersionSpec();
            Calendar calendar = Calendar.getInstance();
            calendar.add(6, -10);
            dateVersionSpec.setDate(calendar.getTime());
            try {
                PrimaryVersionSpec sourceSpec = this.connectionManager.resolveVersionSpec(usersession.getSessionId(), projectSpace.getProjectId(), (VersionSpec)dateVersionSpec);
            }
            catch (InvalidVersionSpecException e) {
                PrimaryVersionSpec sourceSpec = VersioningFactory.eINSTANCE.createPrimaryVersionSpec();
                sourceSpec.setIdentifier(0);
            }
            projectSpace.eResource().save(null);
        }
        catch (EmfStoreException e) {
            WorkspaceUtil.logException(e.getMessage(), (Exception)((Object)e));
        }
        catch (RuntimeException e) {
            WorkspaceUtil.logException(e.getMessage(), e);
        }
        catch (IOException e) {
            WorkspaceUtil.logException(e.getMessage(), e);
        }
        this.addProjectSpace(projectSpace);
        this.save();
        ((CheckoutObserver)WorkspaceManager.getObserverBus().notify(CheckoutObserver.class)).checkoutDone(projectSpace);
        return projectSpace;
    }

    private ProjectInfo createEmptyRemoteProject(Usersession usersession, String projectName, String projectDescription) throws EmfStoreException {
        ConnectionManager connectionManager = WorkspaceManager.getInstance().getConnectionManager();
        LogMessage log = VersioningFactory.eINSTANCE.createLogMessage();
        log.setMessage("Creating project '" + projectName + "'");
        log.setAuthor(usersession.getUsername());
        log.setClientDate(new Date());
        ProjectInfo emptyProject = connectionManager.createEmptyProject(usersession.getSessionId(), projectName, projectDescription, log);
        this.updateProjectInfos(usersession);
        return emptyProject;
    }

    @Override
    public ProjectSpace createLocalProject(String projectName, String projectDescription) {
        ProjectSpace projectSpace = ModelFactory.eINSTANCE.createProjectSpace();
        projectSpace.setProject(org.eclipse.emf.emfstore.common.model.ModelFactory.eINSTANCE.createProject());
        projectSpace.setProjectName(projectName);
        projectSpace.setProjectDescription(projectDescription);
        projectSpace.setLocalOperations(ModelFactory.eINSTANCE.createOperationComposite());
        projectSpace.initResources(this.getResourceSet());
        this.addProjectSpace(projectSpace);
        this.save();
        return projectSpace;
    }

    @Override
    public ProjectInfo createRemoteProject(ServerInfo serverInfo, final String projectName, final String projectDescription) throws EmfStoreException {
        return (ProjectInfo)new ServerCall<ProjectInfo>(serverInfo){

            @Override
            protected ProjectInfo run() throws EmfStoreException {
                return WorkspaceImpl.this.createEmptyRemoteProject(this.getUsersession(), projectName, projectDescription);
            }
        }.execute();
    }

    @Override
    public ProjectInfo createRemoteProject(Usersession usersession, final String projectName, final String projectDescription) throws EmfStoreException {
        return (ProjectInfo)new ServerCall<ProjectInfo>(usersession){

            @Override
            protected ProjectInfo run() throws EmfStoreException {
                return WorkspaceImpl.this.createEmptyRemoteProject(this.getUsersession(), projectName, projectDescription);
            }
        }.execute();
    }

    @Override
    public void deleteProjectSpace(ProjectSpace projectSpace) throws IOException {
        assert (projectSpace != null);
        projectSpace.getProject().delete();
        this.getProjectSpaces().remove((Object)projectSpace);
        this.save();
        this.projectToProjectSpaceMap.remove(projectSpace.getProject());
        projectSpace.delete();
        ((DeleteProjectSpaceObserver)WorkspaceManager.getObserverBus().notify(DeleteProjectSpaceObserver.class)).projectSpaceDeleted(projectSpace);
    }

    @Override
    public void deleteRemoteProject(ServerInfo serverInfo, final ProjectId projectId, final boolean deleteFiles) throws EmfStoreException {
        new ServerCall<Void>(serverInfo){

            @Override
            protected Void run() throws EmfStoreException {
                this.getConnectionManager().deleteProject(this.getSessionId(), projectId, deleteFiles);
                WorkspaceImpl.this.updateProjectInfos(this.getUsersession());
                return null;
            }
        }.execute();
    }

    @Override
    public void deleteRemoteProject(Usersession usersession, final ProjectId projectId, final boolean deleteFiles) throws EmfStoreException {
        new ServerCall<Void>(usersession){

            @Override
            protected Void run() throws EmfStoreException {
                this.getConnectionManager().deleteProject(this.getSessionId(), projectId, deleteFiles);
                WorkspaceImpl.this.updateProjectInfos(this.getUsersession());
                return null;
            }
        }.execute();
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getProjectSpaces();
            }
            case 1: {
                return this.getServerInfos();
            }
            case 2: {
                return this.getUsersessions();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getProjectSpaces()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getProjectSpaces()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getServerInfos()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getUsersessions()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.projectSpaces != null && !this.projectSpaces.isEmpty();
            }
            case 1: {
                return this.serverInfos != null && !this.serverInfos.isEmpty();
            }
            case 2: {
                return this.usersessions != null && !this.usersessions.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getProjectSpaces().clear();
                this.getProjectSpaces().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getServerInfos().clear();
                this.getServerInfos().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getUsersessions().clear();
                this.getUsersessions().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    protected EClass eStaticClass() {
        return ModelPackage.Literals.WORKSPACE;
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getProjectSpaces().clear();
                return;
            }
            case 1: {
                this.getServerInfos().clear();
                return;
            }
            case 2: {
                this.getUsersessions().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public void exportProjectSpace(ProjectSpace projectSpace, File file) throws IOException {
        new ExportProjectSpaceController(projectSpace).execute(file, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void exportProjectSpace(ProjectSpace projectSpace, File file, IProgressMonitor progressMonitor) throws IOException {
        new ExportProjectSpaceController(projectSpace).execute(file, progressMonitor);
    }

    @Override
    public void exportWorkSpace(File file) throws IOException {
        new ExportWorkspaceController().execute(file, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void exportWorkSpace(File file, IProgressMonitor progressMonitor) throws IOException {
        new ExportWorkspaceController().execute(file, progressMonitor);
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    public AdminBroker getAdminBroker(final ServerInfo serverInfo) throws EmfStoreException, AccessControlException {
        return (AdminBroker)new ServerCall<AdminBroker>(serverInfo){

            @Override
            protected AdminBroker run() throws EmfStoreException {
                return new AdminBrokerImpl(serverInfo, this.getSessionId());
            }
        }.execute();
    }

    @Override
    public AdminBroker getAdminBroker(final Usersession usersession) throws EmfStoreException, AccessControlException {
        return (AdminBroker)new ServerCall<AdminBroker>(usersession){

            @Override
            protected AdminBroker run() throws EmfStoreException {
                return new AdminBrokerImpl(usersession.getServerInfo(), this.getSessionId());
            }
        }.execute();
    }

    @Override
    public EditingDomain getEditingDomain() {
        return Configuration.getEditingDomain();
    }

    @Override
    public List<HistoryInfo> getHistoryInfo(ServerInfo serverInfo, final ProjectId projectId, final HistoryQuery query) throws EmfStoreException {
        return (List)new ServerCall<List<HistoryInfo>>(serverInfo){

            @Override
            protected List<HistoryInfo> run() throws EmfStoreException {
                ConnectionManager connectionManager = WorkspaceManager.getInstance().getConnectionManager();
                return connectionManager.getHistoryInfo(this.getUsersession().getSessionId(), projectId, query);
            }
        }.execute();
    }

    @Override
    public List<HistoryInfo> getHistoryInfo(final Usersession usersession, final ProjectId projectId, final HistoryQuery query) throws EmfStoreException {
        return (List)new ServerCall<List<HistoryInfo>>(usersession){

            @Override
            protected List<HistoryInfo> run() throws EmfStoreException {
                ConnectionManager connectionManager = WorkspaceManager.getInstance().getConnectionManager();
                return connectionManager.getHistoryInfo(usersession.getSessionId(), projectId, query);
            }
        }.execute();
    }

    @Override
    public ProjectSpace getProjectSpace(Project project) throws UnkownProjectException {
        ProjectSpace projectSpace = this.projectToProjectSpaceMap.get(project);
        if (projectSpace == null) {
            throw new UnkownProjectException();
        }
        return projectSpace;
    }

    @Override
    public EList<ProjectSpace> getProjectSpaces() {
        if (this.projectSpaces == null) {
            this.projectSpaces = new EObjectContainmentWithInverseEList.Resolving(ProjectSpace.class, (InternalEObject)this, 0, 15);
        }
        return this.projectSpaces;
    }

    @Override
    public List<ProjectInfo> getRemoteProjectList(ServerInfo serverInfo) throws EmfStoreException {
        return (List)new ServerCall<List<ProjectInfo>>(serverInfo){

            @Override
            protected List<ProjectInfo> run() throws EmfStoreException {
                return this.getConnectionManager().getProjectList(this.getSessionId());
            }
        }.execute();
    }

    @Override
    public List<ProjectInfo> getRemoteProjectList(Usersession usersession) throws EmfStoreException {
        return (List)new ServerCall<List<ProjectInfo>>(usersession){

            @Override
            protected List<ProjectInfo> run() throws EmfStoreException {
                return this.getConnectionManager().getProjectList(this.getSessionId());
            }
        }.execute();
    }

    @Override
    public EList<ServerInfo> getServerInfos() {
        if (this.serverInfos == null) {
            this.serverInfos = new EObjectContainmentEList.Resolving(ServerInfo.class, (InternalEObject)this, 1);
        }
        return this.serverInfos;
    }

    @Override
    public EList<Usersession> getUsersessions() {
        if (this.usersessions == null) {
            this.usersessions = new EObjectContainmentEList.Resolving(Usersession.class, (InternalEObject)this, 2);
        }
        return this.usersessions;
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.workspaceResourceSet;
    }

    @Override
    public ProjectSpace importProject(Project project, String name, String description) {
        ProjectSpace projectSpace = ModelFactory.eINSTANCE.createProjectSpace();
        projectSpace.setProject(project);
        projectSpace.setProjectName(name);
        projectSpace.setProjectDescription(description);
        projectSpace.setLocalOperations(ModelFactory.eINSTANCE.createOperationComposite());
        projectSpace.initResources(this.workspaceResourceSet);
        this.addProjectSpace(projectSpace);
        this.save();
        return projectSpace;
    }

    @Override
    public ProjectSpace importProject(String absoluteFileName) throws IOException {
        Project project = ResourceHelper.getElementFromResource(absoluteFileName, Project.class, 0);
        return this.importProject(project, absoluteFileName.substring(absoluteFileName.lastIndexOf(File.separatorChar) + 1), "Imported from " + absoluteFileName);
    }

    @Override
    public ProjectSpace importProjectSpace(String absoluteFileName) throws IOException {
        ProjectSpace projectSpace = ResourceHelper.getElementFromResource(absoluteFileName, ProjectSpace.class, 0);
        projectSpace.initResources(this.workspaceResourceSet);
        this.addProjectSpace(projectSpace);
        this.save();
        return projectSpace;
    }

    @Override
    public void init() {
        this.projectToProjectSpaceMap = new HashMap<Project, ProjectSpace>();
        for (ProjectSpace projectSpace : this.getProjectSpaces()) {
            projectSpace.init();
            this.projectToProjectSpaceMap.put(projectSpace.getProject(), projectSpace);
        }
    }

    @Override
    public Set<ProjectSpace> resolve(ProjectUrlFragment projectUrlFragment) throws ProjectUrlResolutionException {
        HashSet<ProjectSpace> result = new HashSet<ProjectSpace>();
        for (ProjectSpace projectSpace : this.getProjectSpaces()) {
            if (!projectSpace.getProjectId().equals(projectUrlFragment.getProjectId())) continue;
            result.add(projectSpace);
        }
        if (result.size() == 0) {
            throw new ProjectUrlResolutionException();
        }
        return result;
    }

    @Override
    public Set<ServerInfo> resolve(ServerUrl serverUrl) throws ServerUrlResolutionException {
        HashSet<ServerInfo> result = new HashSet<ServerInfo>();
        for (ServerInfo serverInfo : this.getServerInfos()) {
            boolean matchingPort;
            boolean matchingHostname = serverInfo.getUrl().equals(serverUrl.getHostName());
            boolean bl = matchingPort = serverInfo.getPort() == serverUrl.getPort();
            if (!matchingHostname || !matchingPort) continue;
            result.add(serverInfo);
        }
        if (result.size() == 0) {
            throw new ServerUrlResolutionException();
        }
        return result;
    }

    @Override
    public PrimaryVersionSpec resolveVersionSpec(ServerInfo serverInfo, final VersionSpec versionSpec, final ProjectId projectId) throws EmfStoreException {
        return (PrimaryVersionSpec)new ServerCall<PrimaryVersionSpec>(serverInfo){

            @Override
            protected PrimaryVersionSpec run() throws EmfStoreException {
                ConnectionManager connectionManager = WorkspaceManager.getInstance().getConnectionManager();
                return connectionManager.resolveVersionSpec(this.getUsersession().getSessionId(), projectId, versionSpec);
            }
        }.execute();
    }

    @Override
    public PrimaryVersionSpec resolveVersionSpec(final Usersession usersession, final VersionSpec versionSpec, final ProjectId projectId) throws EmfStoreException {
        return (PrimaryVersionSpec)new ServerCall<PrimaryVersionSpec>(){

            @Override
            protected PrimaryVersionSpec run() throws EmfStoreException {
                ConnectionManager connectionManager = WorkspaceManager.getInstance().getConnectionManager();
                return connectionManager.resolveVersionSpec(usersession.getSessionId(), projectId, versionSpec);
            }
        }.execute();
    }

    @Override
    public void save() {
        try {
            this.eResource().save(Configuration.getResourceSaveOptions());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    @Override
    public void setResourceSet(ResourceSet resourceSet) {
        this.workspaceResourceSet = resourceSet;
    }

    @Override
    public void updateACUser(ServerInfo serverInfo) throws EmfStoreException {
        new ServerCall<Void>(serverInfo){

            @Override
            protected Void run() throws EmfStoreException {
                this.getUsersession().setACUser(this.getConnectionManager().resolveUser(this.getSessionId(), null));
                return null;
            }
        }.execute();
    }

    @Override
    public void updateACUser(Usersession usersession) throws EmfStoreException {
        new ServerCall<Void>(usersession){

            @Override
            protected Void run() throws EmfStoreException {
                this.getUsersession().setACUser(this.getConnectionManager().resolveUser(this.getSessionId(), null));
                return null;
            }
        }.execute();
    }

    @Override
    public void updateProjectInfos(final ServerInfo serverInfo) throws EmfStoreException {
        new ServerCall<Void>(serverInfo){

            @Override
            protected Void run() throws EmfStoreException {
                return WorkspaceImpl.this.updateProjectInfos(serverInfo, this.getUsersession());
            }
        }.execute();
    }

    private Void updateProjectInfos(ServerInfo serverInfo, Usersession usersession) {
        try {
            serverInfo.getProjectInfos().clear();
            if (WorkspaceManager.getInstance().getConnectionManager().isLoggedIn(usersession.getSessionId())) {
                serverInfo.getProjectInfos().addAll(this.getRemoteProjectList(usersession));
            }
            WorkspaceManager.getInstance().getCurrentWorkspace().save();
        }
        catch (EmfStoreException e) {
            WorkspaceUtil.logException(e.getMessage(), (Exception)((Object)e));
        }
        catch (RuntimeException e) {
            WorkspaceUtil.logException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public void updateProjectInfos(final Usersession usersession) throws EmfStoreException {
        new ServerCall<Void>(usersession){

            @Override
            protected Void run() throws EmfStoreException {
                return WorkspaceImpl.this.updateProjectInfos(usersession.getServerInfo(), usersession);
            }
        }.execute();
    }

    @Override
    public void addServerInfo(ServerInfo serverInfo) {
        this.getServerInfos().add((Object)serverInfo);
        this.save();
    }

    @Override
    public void removeServerInfo(ServerInfo serverInfo) {
        this.getServerInfos().remove((Object)serverInfo);
        this.save();
    }
}

