/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.filetransfer;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.client.model.connectionmanager.ConnectionManager;
import org.eclipse.emf.emfstore.client.model.filetransfer.FileTransferCacheManager;
import org.eclipse.emf.emfstore.client.model.filetransfer.FileTransferManager;
import org.eclipse.emf.emfstore.client.model.impl.ProjectSpaceBase;
import org.eclipse.emf.emfstore.client.model.util.EMFStoreCommand;
import org.eclipse.emf.emfstore.server.exceptions.FileTransferException;
import org.eclipse.emf.emfstore.server.filetransfer.FilePartitionerUtil;
import org.eclipse.emf.emfstore.server.filetransfer.FileTransferInformation;
import org.eclipse.emf.emfstore.server.model.FileIdentifier;
import org.eclipse.emf.emfstore.server.model.ProjectId;
import org.eclipse.emf.emfstore.server.model.SessionId;

public abstract class FileTransferJob
extends Job {
    private ConnectionManager connectionManager;
    private Exception exception;
    private File file;
    private ProjectId projectId;
    private SessionId sessionId;
    private boolean canceled;
    private final ProjectSpaceBase projectSpace;
    private final FileTransferManager transferManager;
    private final FileTransferCacheManager cache;
    private final FileTransferInformation fileInformation;
    private final FileIdentifier fileId;

    protected FileTransferJob(FileTransferManager transferManager, FileTransferInformation fileInfo, String name) {
        super(name);
        this.fileInformation = fileInfo;
        this.fileId = fileInfo.getFileIdentifier();
        this.projectSpace = transferManager.getProjectSpace();
        this.transferManager = transferManager;
        this.cache = transferManager.getCache();
    }

    protected void getConnectionAttributes() throws FileTransferException {
        this.connectionManager = WorkspaceManager.getInstance().getConnectionManager();
        this.projectId = this.projectSpace.getProjectId();
        if (this.projectSpace.getUsersession() == null) {
            throw new FileTransferException("Session ID is unknown. Please login first!");
        }
        new EMFStoreCommand(){

            protected void doRun() {
                FileTransferJob.this.sessionId = FileTransferJob.this.projectSpace.getUsersession().getSessionId();
            }
        }.run(false);
    }

    protected void setTotalWork(IProgressMonitor monitor) {
        monitor.beginTask("Transfering ", (int)(Math.ceil(this.fileInformation.getFileSize()) / (double)FilePartitionerUtil.getChunkSize()));
    }

    protected void canceling() {
        this.canceled = true;
        super.canceling();
    }

    protected void incrementChunkNumber() {
        this.fileInformation.setChunkNumber(this.fileInformation.getChunkNumber() + 1);
    }

    protected void initializeMonitor(IProgressMonitor monitor) {
        this.setTotalWork(monitor);
        monitor.worked(this.fileInformation.getChunkNumber());
    }

    public Exception getException() {
        return this.exception;
    }

    protected ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    protected File getFile() {
        return this.file;
    }

    protected void setFile(File file) {
        this.file = file;
    }

    protected ProjectId getProjectId() {
        return this.projectId;
    }

    protected SessionId getSessionId() {
        return this.sessionId;
    }

    protected boolean isCanceled() {
        return this.canceled;
    }

    protected ProjectSpaceBase getProjectSpace() {
        return this.projectSpace;
    }

    protected FileTransferManager getTransferManager() {
        return this.transferManager;
    }

    protected FileTransferCacheManager getCache() {
        return this.cache;
    }

    protected FileTransferInformation getFileInformation() {
        return this.fileInformation;
    }

    protected FileIdentifier getFileId() {
        return this.fileId;
    }

    protected void setException(Exception exception) {
        this.exception = exception;
    }
}

