/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.common.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.common.Activator;
import org.eclipse.emf.ecp.common.dialogs.SearchModelElementDialog;
import org.eclipse.emf.ecp.common.model.ECPWorkspaceManager;
import org.eclipse.emf.ecp.common.model.NoWorkspaceException;
import org.eclipse.emf.ecp.common.model.workSpaceModel.ECPProject;
import org.eclipse.emf.ecp.common.utilities.ActionHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SearchModelElementHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ECPProject project = null;
        try {
            project = ECPWorkspaceManager.getInstance().getWorkSpace().getActiveProject();
        }
        catch (NoWorkspaceException e) {
            Activator.getDefault().logException(e.getMessage(), (Exception)((Object)e));
        }
        if (project == null) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Information", (String)"You must first select the Project.");
        } else {
            Object[] selections;
            SearchModelElementDialog dialog = new SearchModelElementDialog(project);
            if (dialog.open() == 0 && (selections = dialog.getResult()) != null && selections.length == 1 && selections[0] instanceof EObject) {
                ActionHelper.openModelElement((EObject)selections[0], "org.eclipse.emf.ecp.navigator.handler.SearchModelElementHandler");
            }
        }
        return null;
    }
}

