/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.debug.gdbjtag.datamodel;

import ilg.gnumcueclipse.core.StringUtils;
import ilg.gnumcueclipse.core.Xml;
import ilg.gnumcueclipse.debug.gdbjtag.datamodel.SvdDMNode;
import ilg.gnumcueclipse.packs.core.tree.Leaf;
import ilg.gnumcueclipse.packs.core.tree.Node;

public class SvdObjectDMNode {
    private Leaf fNode;
    private String fName;
    private Leaf fDerivedFromNode;
    private String fDescription;
    private SvdObjectDMNode[] fChildren;

    public SvdObjectDMNode(Leaf node) {
        this.fNode = node;
        this.fName = null;
        this.fDerivedFromNode = null;
        this.fDescription = null;
        this.fChildren = null;
    }

    public void dispose() {
        if (this.fNode == null) {
            return;
        }
        this.fNode = null;
        this.fDerivedFromNode = null;
        this.fDescription = null;
        this.disposeChildren();
    }

    protected void disposeChildren() {
        if (this.fChildren != null) {
            int i = 0;
            while (i < this.fChildren.length) {
                this.fChildren[i].dispose();
                ++i;
            }
            this.fChildren = null;
        }
    }

    public Leaf getNode() {
        return this.fNode;
    }

    public String getName() {
        if (this.fName == null) {
            this.fName = this.fNode.getName();
            if (this.fName.isEmpty()) {
                this.fName = this.fNode.getKeyName();
                if (this.fName.isEmpty()) {
                    this.fName = null;
                    return "";
                }
            }
        }
        return this.fName;
    }

    public boolean isDerived() {
        return this.fNode.hasProperty("derivedFrom");
    }

    public Leaf getDerivedFromNode() {
        if (this.fDerivedFromNode == null) {
            this.fDerivedFromNode = this.findDerivedFromNode();
        }
        return this.fDerivedFromNode;
    }

    protected Leaf findDerivedFromNode() {
        return null;
    }

    public String getDisplayName() {
        String str = this.getNode().getProperty("displayName");
        if (!str.isEmpty()) {
            return str;
        }
        return this.getName();
    }

    public String getDescription() {
        if (this.fDescription == null) {
            this.fDescription = this.fNode.getDescription();
            if (this.fDescription.isEmpty() && this.getDerivedFromNode() != null) {
                this.fDescription = this.getDerivedFromNode().getDescription();
            }
            this.fDescription = this.fDescription != null ? Xml.joinMultiLine((String)this.fDescription) : "";
            this.fDescription = StringUtils.capitalizeFirst((String)this.fDescription);
        }
        return this.fDescription;
    }

    public SvdObjectDMNode[] getChildren() {
        if (this.fChildren == null) {
            this.fChildren = this.prepareChildren(this.getDerivedFromNode());
            if (this.fChildren == null) {
                this.fChildren = this.prepareChildren(this.fNode);
            }
            if (this.fChildren == null) {
                this.fChildren = new SvdDMNode[0];
            }
        }
        return this.fChildren;
    }

    protected SvdObjectDMNode[] prepareChildren(Leaf node) {
        return null;
    }

    public String getPropertyWithDerived(String name, String defaultValue) {
        String property = this.fNode.getProperty(name);
        if (!property.isEmpty()) {
            return property;
        }
        if (this.isDerived() && !(property = this.getDerivedFromNode().getProperty(name)).isEmpty()) {
            return property;
        }
        return defaultValue;
    }

    public String getPropertyWithDerived(String name) {
        return this.getPropertyWithDerived(name, "");
    }

    public String getPropertyWithDerivedWithParent(String name, String defaultValue) {
        String property = this.fNode.getProperty(name);
        if (!property.isEmpty()) {
            return property;
        }
        if (this.isDerived() && !(property = this.getDerivedFromNode().getProperty(name)).isEmpty()) {
            return property;
        }
        property = "";
        Node n = this.fNode.getParent();
        while (n != null) {
            property = n.getProperty(name);
            if (!property.isEmpty()) {
                return property;
            }
            n = n.getParent();
        }
        return defaultValue;
    }

    public String getPropertyWithDerivedWithParent(String name) {
        return this.getPropertyWithDerivedWithParent(name, "");
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + ": " + this.getName() + ", \"" + this.getDescription() + "\"]";
    }
}

