/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.packs.core.jstree;

import ilg.gnumcueclipse.packs.core.jstree.IJsTreeIterator;
import ilg.gnumcueclipse.packs.core.jstree.JsNode;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractJsTreePreOrderIterator
implements IJsTreeIterator {
    private JsNode fTopNode = null;
    private JsNode fCurrentNode = null;
    private JsNode fNextNode = null;

    @Override
    public void setTreeNode(JsNode node) {
        this.fTopNode = node;
        this.fCurrentNode = null;
        this.fNextNode = null;
    }

    @Override
    public Iterator<JsNode> iterator() {
        return this;
    }

    public abstract boolean isIterable(JsNode var1);

    public abstract boolean isLeaf(JsNode var1);

    @Override
    public boolean hasNext() {
        JsNode node = this.tryNext(this.fCurrentNode);
        if (node != null) {
            this.fNextNode = node;
            return true;
        }
        return false;
    }

    @Override
    public JsNode next() {
        JsNode node = this.fNextNode != null ? this.fNextNode : this.tryNext(this.fCurrentNode);
        if (node != null) {
            this.fCurrentNode = node;
            this.fNextNode = null;
            return node;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
    }

    private JsNode tryNext(JsNode node) {
        block0: do {
            if (node == null) {
                node = this.fTopNode;
                continue;
            }
            if (!this.isLeaf(node) && node.hasChildren()) {
                node = node.getFirstChild();
                continue;
            }
            while (true) {
                JsNode sibling;
                if ((sibling = node.getNextSibling()) != null) {
                    node = sibling;
                    continue block0;
                }
                if (node.getParent() == null) break;
                node = node.getParent();
            }
            node = null;
        } while (node != null && !this.isIterable(node));
        return node;
    }
}

